package terms;

import parsers.*;

/** A signature, i.e., a set of symbols. */
public interface signature {

/** Find out whether this signature contains a given symbol. */
  public abstract boolean contains(symbol sym);
  
/** Yields the string representation of the signature **/
  public abstract String toString();
  
/** Parse the signature from a stream, like in <code>parsable</code>.
  * @see parsable
  * @exception ParseException if an error occurs
  */
  public abstract void parse(ASCII_CharStream stream) throws ParseException;

}
