package terms;

/** A ranked symbol.
  */
public class synchronizedSymbol extends symbol {

  private int[] syncInfo;
  
/** A symbol of rank 0 with synchronization information.
  * @param n the name of the symbol
  * @param syncSize the number of synchronization numbers
  */
  public synchronizedSymbol(String n, int syncSize) {
    super(n,0);
    syncInfo = new int[syncSize];
  }
  
  public void setSync(int index, int sync) {
    syncInfo[index] = sync;
  }
  
  public int[] getSync() {
    return (int[])syncInfo.clone();
  }
  
  public void setSync(int syncInfo[]) {
    this.syncInfo = syncInfo;
  } 
}
