package terms;

public class variable extends symbol {

  int index = 0;

  public variable(String name) {
    super(name, 0);
    try {
      index = Integer.parseInt(name.substring(1));
    } catch (NumberFormatException e)
    { throw new InternalError(); }
  }
  
  public variable(int index) {
    super("x" + new Integer(index).toString(), 0);
    this.index = index;
  }
  
  public static boolean isVariable(String name) {
    if (name.length() < 2) return false;
    if (name.charAt(0) != 'x') return false;
    if (name.charAt(1) == '0' && name.length() > 2) return false;
    for (int i = 1; i < name.length(); i++) {
      if (name.charAt(i) < '0' || name.charAt(i) > '9') return false;
    }
    return true;
  }
  
  public int index() { return index; }
  
}
