package util;

public class list implements Cloneable { 
  
  private Object contents = null;
  private list next = null;
  
/** Add an object as the list's first element. */
  public void prepend(Object o) {
    list old = new list();
    old.contents = contents;
    old.next = next;
    contents = o;
    next = old;
  }
  
/** Add an object as the list's last element. */
  public void append(Object o) {
    list l = this;
    while (l.next != null) l = l.next;
    l.contents = o;
    l.next = new list();
  }
  
/** Append another list to this one (without copying). */
  public void concat(list arg) {
    list l = this;
    while (l.next != null) l = l.next;
    l.contents = arg.contents;
    l.next = arg.next;
  }
  
/** Determine whether the list is empty. */
  public boolean isEmpty() { return next == null; }
  
  public Object head() {
    if (isEmpty()) {
      throw new InternalError("head of empty list requested");
    }
    else return contents;
  }
  
/** Return the tail of the list (which is required to be non-empty). */
  public list tail() {
    if (isEmpty()) {
      throw new InternalError("tail of empty list requested");
    }
    else return next;
  }
  
/** Remove the head of the list (which is required to be non-empty). */
  public void removeFirst() {
    if (isEmpty()) {
      throw new InternalError("tried to remove element from empty list");
    }
    else {
      contents = next.contents;
      next = next.next;
    }
  }
  
/** Discard all elements of the list. */
  public void removeAllElements() {
    contents = null;
    next = null;
  }
  
/** Return the length of the list. */
  public int length() {
    int result = 0;
    list l = this;
    while (!l.isEmpty()) {
      result++;
      l = l.tail();
    }
    return result;
  }
  
/** Return the string representation <code>(&lt;first element&gt;,
  * ..., &lt;first element&gt;)</code> of the list.
  */
  public String toString() {
    if (isEmpty()) return "()";
    String result = "(" + head().toString();
    list l = this.tail();
    while (!l.isEmpty()) {
      result += ", " + l.head().toString();
      l = l.tail();
    }
    return result + ")";
  }
  
/** Return a clone of the list; the individual elements are those of this
  * original list, i.e., they are <em>not</em> copied.
  */
  public Object clone() {
    list result = null;
    try { result = (list)super.clone(); } catch (CloneNotSupportedException e) {
      throw new InternalError();
    }
    if (!isEmpty()) result.next = (list)next.clone();
    return result;
  }
    

}
