package algebras;

import terms.*;
import parsers.*;
import util.*;

/** An algebra - an object that interprets symbols as
  * operations on a certain domain (and thus assigns a value
  * to each term over an appropriate signature).
  */
abstract public class algebra extends parsable {

/** Compute the value of a term with respect to the meaning of symbols
  * provided by this algebra.
  * This is the canonical extension of the method <code>apply</code> to terms.
  * If the value of the term is undefined <code>null</code> is returned. This may happen
  * in two situations, namely if an undefined symbol occurs in the term, or if the
  * operation associated with one of the symbols in the term is not defined on the values
  * of the immediate subterms of the respective occurrence.<br>
  */
  public final synchronized Object valueOf(term t) throws ExitException {
    allowExit();
    int rank = t.topSymbol().rank();
    Object[] args = new Object[rank];
    for (int i = 0; i < rank; i++) {
      if ((args[i] = valueOf(t.subterm(i))) == null) return null;
    }
    return apply(t.topSymbol(), args);
  }
  
/** Apply the operation associated with a symbol to an array of arguments.
  * This will have to be implemented in order to define the semantics of symbols.
  * It can be assumed that all arguments are non-null.
  * If an operation is not defined for a given argument tuple,
  * <code>null</code> must be returned.
  */
  abstract protected Object apply(symbol op, Object[] args);
  
}
