package applications.collages;

import java.awt.geom.*;
import java.util.*;
import util.*;

public class collage extends exitable implements Cloneable {

  private list parts = new list();
  private list end = parts;
  protected int numParts = 0;
  public void add(part p) {
    end.append(p);
    end = end.tail();
    numParts++;
  }
  
  public void unionWith(collage c) {
    if (!c.parts.isEmpty()) {
      end.concat(c.parts);
      end = c.end;
      numParts += c.numParts;
    }
  }
  
  public void transferFrom(collage c, int i) {
    if (i > c.numParts) i = c.numParts;
    numParts += i;
    c.numParts -= i;
    while (i-- > 0) {
      end.prepend(c.parts.head());
      end = end.tail();
      c.parts.removeFirst();
    }
  }
  
  public void transform(AffineTransform t) {
    list l = parts;
    while (!l.isEmpty()) {
      ((part)l.head()).transform(t);
      l = l.tail();
    }
  }
  
  public int numParts() {
    return numParts;
  }
  
  public Enumeration parts() {
    return new partEnumeration();
  }
  
  public void changeColours(colourOperation op) {
    list l = parts;
    while (!l.isEmpty()) {
      ((part)l.head()).changeColour(op);
      l = l.tail();
    }
  }
  
  public Rectangle2D.Double bounds() {
    list l = parts;
    if (l.isEmpty()) return new Rectangle2D.Double();
    Rectangle2D.Double result = ((part) l.head()).bounds();
    l = l.tail();
    while (!l.isEmpty()) {
      result.add(((part) l.head()).bounds());
      l = l.tail();
    }
    return result;
  }
  
  public Object clone() {
    try {
      collage result = (collage)super.clone();
      result.parts = result.end = new list();
      list l = parts;
      while (!l.isEmpty()) {
        part p = (part)((part)l.head()).clone();
        result.end.append(p);
        result.end = result.end.tail();
        l = l.tail();
      }
      return result;
    }
    catch (CloneNotSupportedException e) { throw new InternalError(); }
  }
  
  private class partEnumeration implements Enumeration {
    private list next = parts;
    public boolean hasMoreElements() { return !next.isEmpty(); }
    public Object nextElement() {
      Object result = next.head();
      next = next.tail();
      return result;
    }
  }
    
}
