package generators;

import util.*;
import terms.*;
import parsers.*;
import algebras.*;

/** The YIELD transduction.
  * The output term is the value of the input term with respect to the
  * <code>YIELDAlgebra</code>, if that value is a ground term (i.e., if
  * it contains no variables), and is undefined (i.e., <code>null</code>)
  * otherwise.
  * @see YIELDAlgebra
  */
public class YIELDTransduction extends treeTransducer {

  private term currTerm = null;
  private YIELDAlgebra Y = new YIELDAlgebra();

/** The list of commands this class can deal with is empty. */
  public list commands() { return new list(); }

/** Useless, as long as no commands are implemented. */
  public void execute(String command) { }

/** Computes the output term for a given input term as described above. */
  public term apply(term t) {
    currTerm = t == null ? null : (term)Y.valueOf(t);
    if (currTerm!=null && currTerm.highestVariable() >= 0) currTerm = null;
    return currTerm;
  }
  
  public term currentTerm() { return currTerm; }

/** Parsing does nothing. */
  public void parse(ASCII_CharStream stream) throws ParseException {
    Y.parse(stream);
  }

}
