package gui;

import java.awt.*;
import java.util.*;
import gui.nodeTypes.*;

public class edge extends Component implements Observer {

  /**
	 * 
	 */
  private static final long serialVersionUID = -3659412087089404459L;
  public static Object MOVEMENT = new Object();
  private static int arrowAngle = 40;
  private static int arrowLength = 15;
  private static int arrowWidth;
    { arrowWidth = (int)(arrowLength * Math.sin(arrowAngle/2)); }
  private Color colour = Color.black;

  public node source, target;
  private Point from, to;
  private Rectangle bounds = new Rectangle();

  public edge(node source, node target) {
    super();
    this.source = source;
    this.target = target;
    source.observeMotionBy(this);
    target.observeMotionBy(this);
    setBounds();
  }
  
  public void setColour(Color c) {
    colour = c;
  }
  
  private void setBounds() {
    from = source.getBorderPoint(target.position);
    to = target.getBorderPoint(source.position);
    if (from != null && to != null) {
      bounds.x = Math.min(from.x, to.x) - arrowWidth;
      bounds.y = Math.min(from.y, to.y) - arrowWidth;
      bounds.width = Math.abs(from.x - to.x) + 1 + 2 * arrowWidth;
      bounds.height = Math.abs(from.y - to.y) + 1 + 2 * arrowWidth;
    }
    else {
      bounds.width = 0;
      bounds.height = 0;
    }
    setBounds(bounds);
  }
  
  public boolean contains(int x, int y) {
    if (from == null || to == null) return false;
    if (x < 0 || x > bounds.width || y < 0 || y > bounds.height) return false;
    x += bounds.x;
    y += bounds.y;
    double a = to.y - from.y;
    double b = from.x - to.x;
    double l = Math.sqrt(a * a + b * b);
    a /= l;
    b /= l;
    double dist = a * x + b * y - (a * from.x + b * from.y);
    return Math.abs(dist) <= 5;
  }
  
  public boolean contains(Point p) {
    return contains(p.x, p.y);
  }
  
  public void paint(Graphics g) {
    super.paint(g);
    g.setColor(colour);
    if (from == null || to == null) return;
    int x1 = from.x-bounds.x;
    int y1 = from.y-bounds.y;
    int x2 = to.x-bounds.x;
    int y2 = to.y-bounds.y;
    int angle = (int)(90 + 180/Math.PI*Math.atan2(x2 - x1, y2 - y1));
    g.drawLine(x1, y1, x2, y2);
    g.fillArc(x2 - arrowLength, y2 - arrowLength,
              2*arrowLength, 2*arrowLength, angle - arrowAngle/2, arrowAngle);
  }
  
  public void update(Observable o, Object arg) {
    if (arg == MOVEMENT) { // one of the two nodes has been moved
      setBounds();
      invalidate();
      repaint();
    }
    else { // argument is a new value communicated by source node
      ((worksheetNode)target).transferCommand(arg, worksheetNode.VALUE);
    }
  }
  
}
