package gui.nodeTypes;

import algebras.*;
import gui.*;
import parsers.*;
import terms.*;

public class algebraNode extends worksheetNode {

  /**
	 * 
	 */
  private static final long serialVersionUID = -5150826423030568690L;
  private static int dist = radius/2;
  private static int [] iconX = { -dist, -dist, dist, dist };
  private static int [] iconY = { dist, -dist, dist, -dist };

  private Object curr = null;

  public algebraNode(algebra alg, String fileName) {
    super(alg, fileName);
    figureX = iconX;
    figureY = iconY;
  }
  
  protected synchronized Object current() { return curr; }

  public void runContents(Object command, int type) {
    if (type == VALUE) {
      Object result;
      if (command == null) result = null;
      else result = ((algebra)contents).valueOf((term)command);
      synchronized (this) { curr = result; }
      broadcastResult(result);
    }
    else {
      super.runContents(command, type);
      if (type == USER_COMMAND) {
        if (inputEdge != null) {
          worksheetNode source = (worksheetNode)inputEdge.source;
          transferCommand(source.current(), VALUE);
        }
        else transferCommand(null, VALUE);
      }
    }
  }
    
  public boolean acceptsSource(worksheetNode source) {
    return source instanceof treeGeneratorNode;
  }
  
  public void inputEdgeDeleted(edge e) {
    curr = null;
    super.inputEdgeDeleted(e);
  }
  
  protected void reinit(parsable newContents) {
    super.reinit(newContents);
    curr = null;
  }
    
}
