package gui;

import util.*;

public interface reactive {

/** Yields a list of arrays of strings - the names of the commands that this
  * object can deal with.
  * The result may depend on the object's current state, so two consecutive
  * calls need not yield the same list.
  */
  public abstract list commands();

/** Execute a command. */
  public abstract void execute(String command);
  
/** Determine whether <code>command</code> will result in an
  * <code>exitRequest</code> if the component is busy. Default implementations
  * may return <code>false</code>.
  */
  public abstract boolean requestsExit(String command);

}
