/* Generated By:JavaCC: Do not edit this line. BSTGrammarParser.java */
package parsers;

import terms.*;
import java.util.*;
import generators.*;
import util.*;

/** This is the class used to parse BST grammars.
  */
public class BSTGrammarParser implements BSTGrammarParserConstants {

  public static int TYPE_PLAIN = 0;
  public static int TYPE_NORMAL = 1;
  public static int TYPE_EXTENDED = 2;

  public finiteSignature sig = new finiteSignature();
  public fixedRankSignature nonterminals = new fixedRankSignature(0);
  public fixedRankSignature syncSymbols = new fixedRankSignature(0);
  public int depth;
  public SuperTable tables;
  public term axiom;
  public Vector axiomSyncStrings;  //Vector av int[] object som i SynedRule
  public boolean implicitRules = false;
  public int translationType = TYPE_NORMAL;
  public rexp regulation = null;

  protected ASCII_CharStream inputStream;
  private syncTermParser terms;
  private nameParser names;
  private Vector tableNames = new Vector();
  private Hashtable topTableNames = new Hashtable();
  private int topTableCount = 0;

  public BSTGrammarParser(ASCII_CharStream input) {
    this(new BSTGrammarParserTokenManager(input));
    names = new nameParser(input);
    inputStream = input;
  }

  public Vector checkRhs(term rhs, Vector sync) throws ParseException {
    symbol top = rhs.topSymbol();
    if (nonterminals.contains(top)) {
      if (top instanceof synchronizedSymbol) {
        sync.addElement(((synchronizedSymbol)top).getSync());
      }
      else throw new ParseException(
        "Nonterminal " + top + " requires synchronization symbols");
    }
    else if (sig.contains(top)) {
      for (int i = 0; i < top.rank(); i++) checkRhs(rhs.subterm(i), sync);
    }
    else throw new ParseException(
      "Symbol " + top + " neither an output symbol nor a nonterminal");
    return sync;
  }

  final public void BSTGrammar() throws ParseException {
  boolean a = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPLICIT:
    case NO:
    case PLAIN:
    case NORMAL:
    case EXT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPLICIT:
      case NO:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NO:
          jj_consume_token(NO);
             a = false;
          break;
        default:
          jj_la1[0] = jj_gen;
          ;
        }
        jj_consume_token(IMPLICIT);
        jj_consume_token(RULES);
                                                 implicitRules = a;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 17:
          jj_consume_token(17);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PLAIN:
            jj_consume_token(PLAIN);
                  translationType = TYPE_PLAIN;
            break;
          case NORMAL:
            jj_consume_token(NORMAL);
                     translationType = TYPE_NORMAL;
            break;
          case EXT:
            jj_consume_token(EXT);
                  translationType = TYPE_EXTENDED;
            break;
          default:
            jj_la1[1] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(TRANSLATION);
          break;
        default:
          jj_la1[2] = jj_gen;
          ;
        }
        break;
      case PLAIN:
      case NORMAL:
      case EXT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLAIN:
          jj_consume_token(PLAIN);
                translationType = TYPE_PLAIN;
          break;
        case NORMAL:
          jj_consume_token(NORMAL);
                   translationType = TYPE_NORMAL;
          break;
        case EXT:
          jj_consume_token(EXT);
                translationType = TYPE_EXTENDED;
          break;
        default:
          jj_la1[3] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(TRANSLATION);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 17:
          jj_consume_token(17);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NO:
            jj_consume_token(NO);
                   a = false;
            break;
          default:
            jj_la1[4] = jj_gen;
            ;
          }
          jj_consume_token(IMPLICIT);
          jj_consume_token(RULES);
                                                       implicitRules = a;
          break;
        default:
          jj_la1[5] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    jj_consume_token(18);
    nonterminals.parse(inputStream);
    jj_consume_token(17);
    sig.parse(inputStream);
    jj_consume_token(17);
    syncSymbols.parse(inputStream);
    jj_consume_token(17);
    depth = nat();
    terms = new syncTermParser(inputStream, depth, nonterminals, syncSymbols);
    tables = new SuperTable(depth > 0);
    jj_consume_token(17);
    table(tables, 0, "");
    jj_consume_token(17);
    axiom = terms.term();
    axiomSyncStrings = checkRhs(axiom, new Vector());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 17:
      if (!sig.disjointWith(nonterminals))
        {if (true) throw new ParseException("Restriction by regular expression only allowed if no nonterminals are output symbols.");}
      jj_consume_token(17);
      regulation = rexp();
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    jj_consume_token(19);
  }

  final public void table(SuperTable t, int d, String name) throws ParseException {
  boolean nameDefined = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
      jj_consume_token(TABLE);
              name = string(); nameDefined = true;
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    if (tableNames.contains(name))
      {if (true) throw new ParseException("Table name " + name + " used twice");}
    tableNames.add(name);
    t.setName("TBL" + name);
    if (d == 1) {
      topTableCount++;
      if (nameDefined) topTableNames.put(name, new Integer(topTableCount));
    }
    jj_consume_token(20);
    if (d < depth) tableList(t, d+1, name, 1);
    else ruleList(t);
    jj_consume_token(21);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WEIGHT:
      jj_consume_token(WEIGHT);
               t.setWeight(rat());
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
  }

  final public void tableList(SuperTable t, int d, String name, int count) throws ParseException {
  SuperTable subtable = new SuperTable(d < depth);
  t.addSubTable(subtable);
    table(subtable, d, name + "_" + count);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 17:
      jj_consume_token(17);
      tableList(t, d, name, count+1);
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
  }

  final public void ruleList(SuperTable t) throws ParseException {
    rule(t);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 17:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_1;
      }
      jj_consume_token(17);
      rule(t);
    }
  }

  final public void rule(SuperTable t) throws ParseException {
  symbol lhs;
  term rhs;
  SyncedRule r;
    lhs = new symbol(names.name(), 0);
    if (!nonterminals.contains(lhs))
      {if (true) throw new ParseException(lhs + " not a nonterminal");}
    jj_consume_token(22);
    rhs = terms.term();
    t.addRule(r = new SyncedRule(lhs, rhs));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WEIGHT:
      jj_consume_token(WEIGHT);
               r.setWeight(rat());
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
  }

  final public rexp rexp() throws ParseException {
  Token t;
  rexp r1, r2;
    r1 = rexp1();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 17:
      jj_consume_token(17);
      r2 = rexp();
                      {if (true) return rexp.union(r1, r2);}
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    {if (true) return r1;}
    throw new Error("Missing return statement in function");
  }

  final public rexp rexp1() throws ParseException {
  Token t;
  rexp r1, r2;
    r1 = rexp2();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
    case 18:
    case 25:
      r2 = rexp1();
                   {if (true) return rexp.conc(r1, r2);}
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    {if (true) return r1;}
    throw new Error("Missing return statement in function");
  }

  final public rexp rexp2() throws ParseException {
  Token t;
  rexp r;
    r = rexp3();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 23:
      jj_consume_token(23);
          {if (true) return rexp.star(r);}
      break;
    case 24:
      jj_consume_token(24);
          {if (true) return rexp.plus(r);}
      break;
    default:
      jj_la1[16] = jj_gen;
      {if (true) return r;}
    }
    throw new Error("Missing return statement in function");
  }

  final public rexp rexp3() throws ParseException {
  String name;
  rexp r;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
      name = string();
    Object n = topTableNames.get(name);
    if (n == null) {
      {if (true) throw new ParseException("undefined table `" + name + "' in regulating expression");}
    }
    {if (true) return rexp.num(((Integer)n).intValue());}
      break;
    case 18:
      jj_consume_token(18);
      r = rexp();
      jj_consume_token(19);
                       {if (true) return r;}
      break;
    case 25:
      jj_consume_token(25);
      r = rexp();
      jj_consume_token(26);
                       {if (true) return rexp.opt(r);}
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String string() throws ParseException {
  Token token;
    token = jj_consume_token(QUOTED_STRING);
     {if (true) return token.image.substring(1, token.image.length()-1);}
    throw new Error("Missing return statement in function");
  }

  final public double rat() throws ParseException {
  Token token;
    token = jj_consume_token(RAT);
    try { {if (true) return Double.parseDouble(token.image);} }
    catch (NumberFormatException e) {
      {if (true) throw new ParseException(token.image+" not a valid number");}
      {if (true) return 0;}
    }
    throw new Error("Missing return statement in function");
  }

  final public int nat() throws ParseException {
  double d;
    d = rat();
    if (d == Math.ceil(d) && d >= 0) {if (true) return (int)d;}
    else {if (true) throw new ParseException(d + " not a natural number");}
    throw new Error("Missing return statement in function");
  }

  public BSTGrammarParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[18];
  final private int[] jj_la1_0 = {0x1000,0xe000,0x20000,0xe000,0x1000,0x20000,0xf400,0xf400,0x20000,0x200,0x100,0x20000,0x20000,0x100,0x20000,0x2040080,0x1800000,0x2040080,};

  public BSTGrammarParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new BSTGrammarParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
  }

  public BSTGrammarParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new BSTGrammarParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
  }

  public BSTGrammarParser(BSTGrammarParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
  }

  public void ReInit(BSTGrammarParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[27];
    for (int i = 0; i < 27; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 18; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 27; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
