/* Generated By:JavaCC: Do not edit this line. configParser.java */
package parsers;

import gui.*;
import java.awt.*;
import java.io.*;
import java.util.*;

public class configParser implements configParserConstants {

  public Vector nodes=new Vector();
  public Vector edges=new Vector();
  public int xDim, yDim;
  public String readMe = null;
  private int number;

  public class nodeInfo {
    public String fileName;
    public Point position;
    public int openWindows;
    public Vector execute = new Vector();
    public nodeInfo(String myPath, int ups, String name, int x, int y, int win) throws ParseException {
      name = name.substring(1,name.length()-1);
      File file = new File(name);
      if (!file.isAbsolute()) {
        File dir = new File(myPath);
        for (int i = 0; i <= ups; i++) {
          dir = dir.getParentFile();
        }
        file = new File(dir,name);
      }
      try { fileName = file.getCanonicalPath(); }
      catch (IOException e) {
        throw new ParseException(e.getMessage());
      }
      position = new Point(x,y);
      openWindows = win;
    }
  }

  public class edgeInfo {
    public int source;
    public int target;
    public edgeInfo(int s, int t) {
      source = s; target = t;
    }
  }

  private int getInt(Token t) {
    try { return Integer.parseInt(t.image); }
    catch ( NumberFormatException e ) { return 0; } // This should never happen.
  }

/**
  */
  final public void parse(String myPath) throws ParseException {
  nodes.removeAllElements();
  number = xDim = yDim = -1;
  Token t;
    jj_consume_token(WS);
    jj_consume_token(CONF);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WS:
      dimensions();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMPONENT:
      nodeList(myPath);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EDGES:
      jj_consume_token(EDGES);
      jj_consume_token(ARE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUM:
        edgeList();
        break;
      default:
        jj_la1[2] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    jj_consume_token(END);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXEC:
      jj_consume_token(EXEC);
      jj_consume_token(INITIALLY);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUM:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_1;
        }
        init();
      }
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case README:
      jj_consume_token(README);
      jj_consume_token(COLON);
      token_source.SwitchTo(graball);
      t = jj_consume_token(text);
      readMe = t.image;
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
  }

  final public void dimensions() throws ParseException {
  Token num1, num2;
    jj_consume_token(WS);
    jj_consume_token(SIZE);
    jj_consume_token(IS);
    jj_consume_token(LEFT_PAR);
    num1 = jj_consume_token(NUM);
    jj_consume_token(COMMA);
    num2 = jj_consume_token(NUM);
    jj_consume_token(RIGHT_PAR);
    xDim = getInt(num1); yDim = getInt(num2);
  }

  final public void nodeList(String myPath) throws ParseException {
  Token num1,num2,name,openWindows;
  int open = 0;
  int ups = 0;
  nodeInfo info = null;
    jj_consume_token(COMPONENT);
    token = jj_consume_token(NUM);
    if (getInt(token) != ++number) {
      {if (true) throw new ParseException("Encountered component number " + token.image +
                                         "; next number should be " + number);}
    }
    jj_consume_token(IS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUM:
      num1 = jj_consume_token(NUM);
                 ups = getInt(num1);
      jj_consume_token(UP);
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    name = jj_consume_token(STRING);
    jj_consume_token(AT);
    jj_consume_token(LEFT_PAR);
    num1 = jj_consume_token(NUM);
    jj_consume_token(COMMA);
    num2 = jj_consume_token(NUM);
    jj_consume_token(RIGHT_PAR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPEN:
      openWindows = jj_consume_token(OPEN);
                           open = openWindows.image.length();
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    nodes.addElement(info =
      new nodeInfo(myPath,ups, name.image, getInt(num1), getInt(num2), open));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      commandList(info.execute);
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMPONENT:
      nodeList(myPath);
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
  }

  final public void commandList(Vector store) throws ParseException {
  Token t;
  int multiplicity = 1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUM:
      t = jj_consume_token(NUM);
      multiplicity = getInt(t);
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    t = jj_consume_token(STRING);
    store.addElement(new Integer(multiplicity));
    String c = t.image.substring(1,t.image.length()-1);
    store.addElement(c);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      commandList(store);
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
  }

  final public void edgeList() throws ParseException {
  Token from, to;
  int source = 0;
  int target = 0;
    from = jj_consume_token(NUM);
    jj_consume_token(ARROW);
    to = jj_consume_token(NUM);
    source = getInt(from);
    target = getInt(to);
    if (source > number || target > number) {
      errorDisplay.show("Unknown node number in edge " + from.image + " -> " + to.image + "; will be ignored");
    }
    else edges.addElement(new edgeInfo(source,target));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUM:
      edgeList();
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
  }

  final public void init() throws ParseException {
  Token t;
  Vector execute;
    t = jj_consume_token(NUM);
    jj_consume_token(COLON);
    int i = getInt(t);
    if (i >= nodes.size()) {if (true) throw new ParseException("Attempt to pass commands to nonexisting component " + i);}
    nodeInfo info = (nodeInfo)nodes.elementAt(i);
    execute = info.execute;
    commandList(execute);
  }

  public configParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[14];
  final private int[] jj_la1_0 = {0x40,0x100,0x200000,0x200,0x200000,0x40000,0x800,0x200000,0x400000,0x10000,0x100,0x200000,0x800000,0x200000,};

  public configParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new configParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  public configParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new configParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  public configParser(configParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  public void ReInit(configParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[29];
    for (int i = 0; i < 29; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 14; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 29; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
