/* Generated By:JavaCC: Do not edit this line. gridAlgebraParser.java */
package parsers;

import java.awt.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.util.*;
import terms.*;
import applications.collages.*;
import applications.*;

public class gridAlgebraParser implements componentParser, gridAlgebraParserConstants {

  private ASCII_CharStream inputStream = null;
  private setParser definitions;
  private nameParser names;
  private gridAlgebra alg;
  private Hashtable synonyms = new Hashtable();

  // Used as global variables by segments(...):
  float firstCx, firstCy, firstPx, firstPy, lx, ly, rx, ry, px, py;
  boolean close;

  public gridAlgebraParser(ASCII_CharStream input) {
    this(new gridAlgebraParserTokenManager(input));
    names = new nameParser(input);
    definitions = new setParser(input);
    inputStream = input;
  }

  private void addConstants() {
    Enumeration names = synonyms.keys();
    while (names.hasMoreElements()) {
      symbol sym = (symbol)names.nextElement();
      Object op = synonyms.get(sym);
      if (op instanceof collage) {
        collage col = (collage)op;
        col.unionWith(gridAlgebra.frame());
        alg.defineSymbol(sym, col);
      }
    }
  }

/** Parse a <code>gridAlgebra</code>.
  * The syntax consists only of a natural number &gt; 0 which determines the grid size, or
  * a pair whose first component is the grid size and whose second component is a set of
  * equations defining synonyms for standard symbols (given by their names).
  * @exception ParseException if an error occurs
  */
  final public void gridAlgebra(gridAlgebra alg) throws ParseException {
  this.alg = alg;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RAT:
      gridSize();
      break;
    case LEFT_PAR:
      jj_consume_token(LEFT_PAR);
      gridSize();
      jj_consume_token(COMMA);
    definitions.set(this);
      jj_consume_token(RIGHT_PAR);
    addConstants();
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void component() throws ParseException {
    String name = names.name();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUALS:
      jj_consume_token(EQUALS);
      operation(name);
      break;
    case ADDTO:
      jj_consume_token(ADDTO);
      collage(name);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void operation(String name) throws ParseException {
  int rankLhs, rankRhs;
    String rhs = names.name();
    Object rhsOp = alg.decodeOp(rhs);
    if (rhsOp == null) {
      {if (true) throw new ParseException("Cannot introduce a synonym for " + rhs +
                               ".\nThis symbol does not denote an allowed operation");}
    }
    if (rhsOp instanceof collage) rankRhs = 0;
    else rankRhs = ((collageOperation)rhsOp).arity();
    Object lhsOp = alg.decodeOp(name);
    if (lhsOp != null) {
      if (lhsOp instanceof collage) rankLhs = 0;
      else rankLhs = ((collageOperation)lhsOp).arity();
      if (rankLhs == rankRhs) {
        {if (true) throw new ParseException("Symbol " + name + " of rank " +
                                  rankLhs + " has a standard meaning." +
                                 " Such symbols cannot be used as synonyms");}
      }
    }
    symbol synonym = new symbol(name, rankRhs);
    if (synonyms.get(synonym)  != null) {
      {if (true) throw new ParseException("Symbol " + name + " of rank " + rankRhs +
                               " already used as a synonym for " +
                                 synonyms.get(synonym) + ".\nYou cannot use it" +
                               " for " + rhs + " at the same time");}
    }
    synonyms.put(synonym,rhs);
    alg.defineSymbol(synonym, rhsOp);
  }

  final public void collage(String name) throws ParseException {
   collage col;
    boolean predefined = gridAlgebra.squareName.equals(name);
    if (!predefined) {
      Object op = alg.decodeOp(name);
      predefined = op != null &&
                   op instanceof AffineTransform[] &&
                   ((AffineTransform[])op).length == 0;
    }
    if (predefined) {if (true) throw new ParseException("Symbol " + name +
                     ":0 has a standard interpretation that cannot be altered");}
    symbol sym = new symbol(name, 0);
    if (synonyms.get(sym) == null) {
      col = gridAlgebra.greySquare();
      synonyms.put(sym,col);
    }
    else col = (collage)synonyms.get(sym);
    jj_consume_token(LEFT_BRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
    case CURVE:
    case FILLED_CURVE:
    case CLOSED_CURVE:
    case ELLIPSE:
    case FILLED_ELLIPSE:
    case PIE:
    case FILLED_PIE:
    case ARC:
    case CLOSED_ARC:
    case FILLED_ARC:
      parts(col);
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    jj_consume_token(RIGHT_BRACE);
  }

  final public void parts(collage col) throws ParseException {
  part p;
  collage ncol;
    p = part();
               col.add(p);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      parts(col);
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
  }

  final public part part() throws ParseException {
  GeneralPath seg = new GeneralPath();
  double x,y,r,rx,ry,alpha,beta;
  float pt;
  part result;
  String s,t;
  String fname = null;
  boolean bold = false;
  boolean italic = false;
  int style = part.FILLED;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CURVE:
      jj_consume_token(CURVE);
      jj_consume_token(LEFT_PAR);
      seg = segments(false);
                                       result = new part(part.OUTLINE,seg);
      break;
    case CLOSED_CURVE:
      jj_consume_token(CLOSED_CURVE);
      jj_consume_token(LEFT_PAR);
      seg = segments(true);
                                      result = new part(part.OUTLINE,seg);
      break;
    case FILLED_CURVE:
      jj_consume_token(FILLED_CURVE);
      jj_consume_token(LEFT_PAR);
      seg = segments(true);
                                      result = new part(part.FILLED,seg);
      break;
    case ELLIPSE:
      jj_consume_token(ELLIPSE);
      jj_consume_token(LEFT_PAR);
      x = rat();
      jj_consume_token(COMMA);
      y = rat();
      jj_consume_token(COMMA);
      rx = rat();
      jj_consume_token(COMMA);
      ry = rat();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.OUTLINE,new GeneralPath(new Ellipse2D.Double(x-rx,y-ry,rx*2.0,ry*2.0)));
      break;
    case FILLED_ELLIPSE:
      jj_consume_token(FILLED_ELLIPSE);
      jj_consume_token(LEFT_PAR);
      x = rat();
      jj_consume_token(COMMA);
      y = rat();
      jj_consume_token(COMMA);
      rx = rat();
      jj_consume_token(COMMA);
      ry = rat();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.FILLED,new GeneralPath(new Ellipse2D.Double(x-rx,y-ry,rx*2.0,ry*2.0)));
      break;
    case PIE:
      jj_consume_token(PIE);
      jj_consume_token(LEFT_PAR);
      x = rat();
      jj_consume_token(COMMA);
      y = rat();
      jj_consume_token(COMMA);
      r = rat();
      jj_consume_token(COMMA);
      alpha = rat();
      jj_consume_token(COMMA);
      beta = rat();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.OUTLINE,new GeneralPath(new Arc2D.Double(x-r,y-r,r*2.0,r*2.0,-alpha,-beta,Arc2D.PIE)));
      break;
    case FILLED_PIE:
      jj_consume_token(FILLED_PIE);
      jj_consume_token(LEFT_PAR);
      x = rat();
      jj_consume_token(COMMA);
      y = rat();
      jj_consume_token(COMMA);
      r = rat();
      jj_consume_token(COMMA);
      alpha = rat();
      jj_consume_token(COMMA);
      beta = rat();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.FILLED,new GeneralPath(new Arc2D.Double(x-r,y-r,r*2.0,r*2.0,-alpha,-beta,Arc2D.PIE)));
      break;
    case ARC:
      jj_consume_token(ARC);
      jj_consume_token(LEFT_PAR);
      x = rat();
      jj_consume_token(COMMA);
      y = rat();
      jj_consume_token(COMMA);
      r = rat();
      jj_consume_token(COMMA);
      alpha = rat();
      jj_consume_token(COMMA);
      beta = rat();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.OUTLINE,new GeneralPath(new Arc2D.Double(x-r,y-r,r*2.0,r*2.0,-alpha,-beta,Arc2D.OPEN)));
      break;
    case CLOSED_ARC:
      jj_consume_token(CLOSED_ARC);
      jj_consume_token(LEFT_PAR);
      x = rat();
      jj_consume_token(COMMA);
      y = rat();
      jj_consume_token(COMMA);
      r = rat();
      jj_consume_token(COMMA);
      alpha = rat();
      jj_consume_token(COMMA);
      beta = rat();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.OUTLINE,new GeneralPath(new Arc2D.Double(x-r,y-r,r*2.0,r*2.0,-alpha,-beta,Arc2D.CHORD)));
      break;
    case FILLED_ARC:
      jj_consume_token(FILLED_ARC);
      jj_consume_token(LEFT_PAR);
      x = rat();
      jj_consume_token(COMMA);
      y = rat();
      jj_consume_token(COMMA);
      r = rat();
      jj_consume_token(COMMA);
      alpha = rat();
      jj_consume_token(COMMA);
      beta = rat();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.FILLED,new GeneralPath(new Arc2D.Double(x-r,y-r,r*2.0,r*2.0,-alpha,-beta,Arc2D.CHORD)));
      break;
    case STRING:
      s = str();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFT_BRACKET:
        jj_consume_token(LEFT_BRACKET);
        label_1:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STRING:
          case BOLD:
          case ITALIC:
          case OUTLINED:
            ;
            break;
          default:
            jj_la1[4] = jj_gen;
            break label_1;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STRING:
            t = str();
                    if (fname != null && !t.equals(fname)) {if (true) throw new ParseException("Two font names specified");} fname = t;
            break;
          case BOLD:
            jj_consume_token(BOLD);
                 bold = true;
            break;
          case ITALIC:
            jj_consume_token(ITALIC);
                   italic = true;
            break;
          case OUTLINED:
            jj_consume_token(OUTLINED);
                     style = part.OUTLINE;
            break;
          default:
            jj_la1[5] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(RIGHT_BRACKET);
        break;
      default:
        jj_la1[6] = jj_gen;
        ;
      }
      jj_consume_token(SIZE);
      pt = ratf();
      if (Math.rint(Math.abs(pt)) != pt)
        {if (true) throw new ParseException("Point size of font must be a nonnegative integer");}
      jj_consume_token(AT);
      jj_consume_token(LEFT_PAR);
      x = rat();
      jj_consume_token(COMMA);
      y = rat();
      jj_consume_token(RIGHT_PAR);
      int spec = bold ? Font.BOLD : 0;
      if (italic) spec += Font.ITALIC;
      Font f = new Font(fname==null ? "SansSerif" : fname,
                        spec==0 ? Font.PLAIN : spec, Math.round(pt));
      GlyphVector gv = f.createGlyphVector(new FontRenderContext(null,false,true),s);
// For some reason, the following yields the wrong vertical placement on Mac OS X.
//      Rectangle2D b = gv.getVisualBounds();
//      GeneralPath path = new GeneralPath(gv.getOutline((float)(x-b.getCenterX()),-(float)(y+b.getCenterY())));
//      path.transform(new AffineTransform(1,0,0,-1,0,0));
      GeneralPath path = new GeneralPath(gv.getOutline());
      Rectangle2D b = path.getBounds2D();
      path.transform(new AffineTransform(1,0,0,-1,x-b.getCenterX(),y+b.getCenterY()));
      result = new part(style,path);
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT_BRACKET:
      jj_consume_token(LEFT_BRACKET);
      staticColour(result);
      jj_consume_token(RIGHT_BRACKET);
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WIDTH:
      jj_consume_token(WIDTH);
      double w = rat();
      if (w < 0) {if (true) throw new ParseException("Negative line width " + w);}
      result.setThickness(w);
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public GeneralPath segments(boolean closePath) throws ParseException {
  GeneralPath result = new GeneralPath();
    curvePoint();
    result.moveTo(px,py);
    firstCx = lx;
    firstCy = ly;
    firstPx = px;
    firstPy = py;
    close = closePath;
    tail(result,px,py,rx,ry);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public void tail(GeneralPath p, float currx, float curry, float nextCx, float nextCy) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      curvePoint();
    if (lx==0 && ly==0) {
      if (nextCx==0 && nextCy==0) p.lineTo(px,py);
      else p.quadTo(currx+nextCx,curry+nextCy,px,py);
    }
    else p.curveTo(currx+nextCx,curry+nextCy,px+lx,py+ly,px,py);
      tail(p,px,py,rx,ry);
      break;
    case RIGHT_PAR:
      jj_consume_token(RIGHT_PAR);
    if (close) {
      if (firstCx==0 && firstCy==0) {
        if (nextCx==0 && nextCy==0) p.lineTo(firstPx,firstPy);
        else p.quadTo(currx+nextCx,curry+nextCy,firstPx,firstPy);
      }
      else p.curveTo(currx+nextCx,curry+nextCy,firstCx+firstPx,firstCy+firstPy,firstPx,firstPy);
      p.closePath();
    }
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void curvePoint() throws ParseException {
  lx = ly = rx = ry = 0;
    jj_consume_token(LEFT_PAR);
    px = ratf();
    jj_consume_token(COMMA);
    py = ratf();
    jj_consume_token(RIGHT_PAR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT:
    case RIGHT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFT:
        jj_consume_token(LEFT);
        jj_consume_token(LEFT_PAR);
        lx = ratf();
        jj_consume_token(COMMA);
        ly = ratf();
        jj_consume_token(RIGHT_PAR);
      rx = -lx; ry = -ly;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case RIGHT:
          jj_consume_token(RIGHT);
          jj_consume_token(LEFT_PAR);
          rx = ratf();
          jj_consume_token(COMMA);
          ry = ratf();
          jj_consume_token(RIGHT_PAR);
          break;
        default:
          jj_la1[11] = jj_gen;
          ;
        }
        break;
      case RIGHT:
        jj_consume_token(RIGHT);
        jj_consume_token(LEFT_PAR);
        rx = ratf();
        jj_consume_token(COMMA);
        ry = ratf();
        jj_consume_token(RIGHT_PAR);
      lx = -rx; ly = -ry;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LEFT:
          jj_consume_token(LEFT);
          jj_consume_token(LEFT_PAR);
          lx = ratf();
          jj_consume_token(COMMA);
          ly = ratf();
          jj_consume_token(RIGHT_PAR);
          break;
        default:
          jj_la1[12] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
  }

  final public void staticColour(part p) throws ParseException {
  float r,g,b;
    r = ratf();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      g = ratf();
      jj_consume_token(COMMA);
      b = ratf();
      break;
    default:
      jj_la1[15] = jj_gen;
                                                         g=b=r;
    }
    if (r<0 || r>1 || g<0 || g>1 || b<0 || b>1)
      {if (true) throw new ParseException("rgb values must be numbers in the interval [0,1]");}
    p.setColour(r,g,b);
  }

  final public double rat() throws ParseException {
  Token token;
    token = jj_consume_token(RAT);
    try { {if (true) return new Double(token.image).doubleValue();} }
    catch (NumberFormatException e) {
      {if (true) throw new ParseException(token.image+" not a valid number");}
      {if (true) return 0;}
    }
    throw new Error("Missing return statement in function");
  }

  final public float ratf() throws ParseException {
  double d;
    d = rat();
    {if (true) return (float)d;}
    throw new Error("Missing return statement in function");
  }

  final public String str() throws ParseException {
  Token s;
    s = jj_consume_token(STRING);
    {if (true) return s.image.substring(1,s.image.length()-1);}
    throw new Error("Missing return statement in function");
  }

  final public void gridSize() throws ParseException {
  Token token;
    token = jj_consume_token(RAT);
    try {
      alg.setGridSize(Integer.parseInt(token.image));
    }
    catch (NumberFormatException e) { {if (true) throw new ParseException("Not a valid natural number");} }
  }

  public gridAlgebraParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[16];
  final private int[] jj_la1_0 = {0x180,0x18000,0x7fe0040,0x4000,0x80000040,0x80000040,0x400,0x7fe0040,0x400,0x0,0x4200,0x10000000,0x8000000,0x18000000,0x18000000,0x4000,};
  final private int[] jj_la1_1 = {0x0,0x0,0x0,0x0,0x3,0x3,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,};

  public gridAlgebraParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new gridAlgebraParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
  }

  public gridAlgebraParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new gridAlgebraParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
  }

  public gridAlgebraParser(gridAlgebraParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
  }

  public void ReInit(gridAlgebraParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[35];
    for (int i = 0; i < 35; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 16; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 35; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
