package parsers;

import java.util.*;
import util.*;

/** A class whose objects can be defined by reading from a file.
  * Every class implementing this interface will be parsable using
  * <code>objectParser</code>. There must always be a
  * noarg constructor!
  */
public class parsable extends exitable {

  private static Hashtable names = new Hashtable();
  private String name = null;
  private String fullName = null;
  private String className = null;
  private int myNumber = 0;

/** Initialize this object by reading its definition from a stream.
  * This is a default implementation that simply does nothing (which is ok
  * for all subclasses whose objects can be instantiated without the need
  * to get specific information from a file). Usually, this will be overwritten.
  * The parsing method should never read past the end of the definition
  * of the current object, so that the method can be used in a larger
  * context (i.e., no token of some other definition that may follow
  * is consumed).
  * @exception ParseException if an error occurs
  */
  public void parse(ASCII_CharStream stream) throws ParseException { }
  
/** Set the name of the object. 
  * This will be used by <code>objectParser</code>, which sets the name to
  * <code>xyz</code> if it reads an object definition like <code>classX(xyz):...</code>.
  * (If <code>xyz</code> is omitted, i.e., the definition reads <code>classX:...</code>,
  * the name is not set.)
  */
  public void setName(String name) {
    dispose();
    this.name = name;
    BitSet num;
    Object o = names.get(name);
    if (o == null) names.put(name, num = new BitSet(3));
    else num = (BitSet) o;
    myNumber = 0;
    while (num.get(myNumber)) myNumber++;
    if (myNumber==0) fullName = name;
    else fullName = name + " #" + Integer.toString(myNumber+1);
    num.set(myNumber);
  }
  
/** Set the class name of the object.
  * This will be used by <code>objectParser</code>, which sets the class name to
  * <code>classX</code> if it reads an object definition like <code>classX(...):...</code>.
  */
  public void setClassName(String className) { this.className = className; }
  
/** Return the full name of the object, including any running number. */
  public String getName() { return fullName; }
  
/** Return the base name of the object, excluding its running number. */
  public String getBasename() { return name; }
  
/** Return the class name of the object. */
  public String getClassName() { return className; }
  
/** Dispose the object.
  * This will make sure that the object's name can be re-used.
  */
  public void dispose() {
    if (name != null) {
      Object o = names.get(name);
      if (o != null) {
        BitSet num = (BitSet) o;
        num.clear(myNumber);
      }
    }
  }
  
}
