/* Generated By:JavaCC: Do not edit this line. syncTermParser.java */
package parsers;

import terms.*;
import util.*;

public class syncTermParser implements syncTermParserConstants {

  private nameParser names;
  private ASCII_CharStream inputStream = null;
  private int dpth;
  private fixedRankSignature nont;
  private fixedRankSignature syncSym;

  public syncTermParser(ASCII_CharStream input, int syncDepth, fixedRankSignature nont, fixedRankSignature syncSym) {
    this(new syncTermParserTokenManager(input));
    inputStream = input;
    dpth = syncDepth;
    this.nont = nont;
    this.syncSym = syncSym;
  }

  public static String toString(term t) {
    symbol top = t.topSymbol();
    if (top.rank() == 0) return top.toString();
    else {
      String result = top.toString() + "[" + t.subterm(0);
      for (int i = 1; i < top.rank(); i++) result += "," + t.subterm(i);
      return result + "]";
    }
  }

  public static String unparse(term t) {
    symbol top = t.topSymbol();
    if (top.rank() == 0) return nameParser.unparse(top.toString());
    else {
      String result = nameParser.unparse(top.toString()) + "[" + unparse(t.subterm(0));
      for (int i = 1; i < top.rank(); i++) result += "," + unparse(t.subterm(i));
      return result + "]";
    }
  }

/** Parse a term.
  * The syntax is as in the termParser class, but allows for tuples of
  * synchronization symbols in addition. Such a tuple may follow a symbol of
  * rank 0 and consists of a nonzero number of symbols names, separated by
  * commas and enclosed in angle brackets.
  * @exception ParseException if an error occurs
  */
  final public term term() throws ParseException {
  names = new nameParser(inputStream);
    term result = term2();
    token_source.SwitchTo(termParserConstants.DEFAULT);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public term term2() throws ParseException {
  term result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT_PAR:
      jj_consume_token(LEFT_PAR);
    term arg1 = term2();
    String name = names.name();
    result = new term(new symbol(name, 2));
    token_source.SwitchTo(termParserConstants.DEFAULT);
    result.defineSubterm(0, arg1);
    result.defineSubterm(1, term2());
      jj_consume_token(RIGHT_PAR);
    {if (true) return result;}
      break;
    case PREFIX:
      jj_consume_token(PREFIX);
    {if (true) return prefixNotation();}
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public term prefixNotation() throws ParseException {
  term result;
  String name;
    name = names.name();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT_BRACKET:
      jj_consume_token(LEFT_BRACKET);
      list subterms = new list();
      termList(subterms);
      int rank = subterms.length();
      result = new term(new symbol(name, rank));
      for (int i = 0; i < rank; i++) {
        result.defineSubterm(i, (term)subterms.head());
        subterms = subterms.tail();
      }
      jj_consume_token(RIGHT_BRACKET);
      break;
    case LEFT_ANGLE:
      jj_consume_token(LEFT_ANGLE);
      synchronizedSymbol sym = new synchronizedSymbol(name,dpth);
      if (!nont.contains(sym)) {if (true) throw new ParseException(sym + " not a nonterminal");}
      for (int i = 0; i < dpth; i++) {
        symbol sync = new symbol(names.name(), 0);
        if (!syncSym.contains(sync))
          {if (true) throw new ParseException(sync + " not a synchronization symbol");}
        sym.setSync(i,syncSym.indexOf(sync));
      }
      result = new term(sym);
      jj_consume_token(RIGHT_ANGLE);
      break;
    case NULLARY:
      jj_consume_token(NULLARY);
      if (variable.isVariable(name)) result = new term(new variable(name));
      else result = new term(new symbol(name, 0));
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public void termList(list l) throws ParseException {
    l.append(term2());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      termList(l);
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
  }

  public syncTermParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[3];
  final private int[] jj_la1_0 = {0xc0,0xb00,0x4000,};

  public syncTermParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new syncTermParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  public syncTermParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new syncTermParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  public syncTermParser(syncTermParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  public void ReInit(syncTermParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[15];
    for (int i = 0; i < 15; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 3; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 15; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
