package terms;

/**
 * A copy of variable.java, but symbol names must be
 * y1, y2, ... instead of x1, x2, ...
 */

public class parameter extends symbol {

    int index = 0;

    public parameter(String name) {
        super(name, 0);
        try {
            index = Integer.parseInt(name.substring(1));
        } catch (NumberFormatException e)
        { throw new InternalError(); }
    }

    public parameter(int index) {
        super("y" + new Integer(index).toString(), 0);
        this.index = index;
    }
    
    public static boolean isParameter(String name) {
        if (name.length() < 2) return false;
        if (name.charAt(0) != 'y') return false;
        if (name.charAt(1) == '0' && name.length() > 2) return false;
        for (int i = 1; i < name.length(); i++) {
            if (name.charAt(i) < '0' || name.charAt(i) > '9') return false;
        }
        return true;
    }

    public int index() { return index; }
}

