package util;

import java.io.*;

public class includer extends InputStream {

  private InputStream input;
  private File myDir = null;
  private includer including = null;
  private int[] buf = new int[9];
  private int bufStart = 0;
  private int bufLength = 0;
  
  public includer(File file) throws IncludeFileNotFoundException {
    try {
      myDir = file.getParentFile();
      input = new FileInputStream(file);
    }
    catch (FileNotFoundException e) { throw new IncludeFileNotFoundException(e.getMessage()); }
  }
  
  public int read() throws IOException, IncludeFileNotFoundException {
    if (including != null) {
      int result = including.read();
      if (result == -1) {
        including.close();
        including = null;
      }
      else return result;
    }
    return nextByte();
  }
  
  private int nextByte() throws IOException, IncludeFileNotFoundException {
    int result;
    do {
      if (bufLength == 0) {
        result = input.read();
        if (result != '#') return result;
        buf[(bufStart + bufLength++) % buf.length] = result;
      }
      result = checkInclude();
      if (result != -1) return result;
    } while (true);
  }
  
  private int checkInclude() throws IOException, IncludeFileNotFoundException {
    int result;
    if (isInclude()) {
      bufStart = bufLength = 0;
      try { including = new includer(new File(myDir,filename())); }
      catch (FileNotFoundException e) { throw new IncludeFileNotFoundException(e.getMessage()); }
      result = including.read();
      if (result == -1) including.close();
      return result;
    }
    else {
      bufLength--;
      result = buf[bufStart];
      bufStart = (bufStart + 1) % buf.length;
      return result;
    }
  }
  
  private boolean isInclude() throws IOException {
    while (bufLength < 9) {
      int result = input.read();
      if (result == -1) return false;
      buf[(bufStart + bufLength++) % buf.length] = result;
    }
    return buf[bufStart] == '#' &&
           (buf[(bufStart+1) % buf.length] == 'i' || buf[(bufStart+1) % buf.length] == 'I') &&
           (buf[(bufStart+2) % buf.length] == 'n' || buf[(bufStart+2) % buf.length] == 'N') &&
           (buf[(bufStart+3) % buf.length] == 'c' || buf[(bufStart+3) % buf.length] == 'C') &&
           (buf[(bufStart+4) % buf.length] == 'l' || buf[(bufStart+4) % buf.length] == 'L') &&
           (buf[(bufStart+5) % buf.length] == 'u' || buf[(bufStart+5) % buf.length] == 'U') &&
           (buf[(bufStart+6) % buf.length] == 'd' || buf[(bufStart+6) % buf.length] == 'D') &&
           (buf[(bufStart+7) % buf.length] == 'e' || buf[(bufStart+7) % buf.length] == 'E') &&
           buf[(bufStart+8) % buf.length] == '(';
  }
  
  public void close() throws IOException {
    input.close();
  }
  
  private String filename() throws IOException {
    StringBuffer result = new StringBuffer();
    while (true) {
      int c = input.read();
      if (c == -1) throw new IOException("unexpected end of file");
      if (c == ')') return result.toString();
      if (c == '\\') {
        int c2 = input.read();
        if (c2 == -1) throw new IOException("unexpected end of file");
        result.append((char)c2);
      }
      result.append((char)c);
    }
  }
  
  public class IncludeFileNotFoundException extends Error {
  
    /**
	 * 
	 */
	private static final long serialVersionUID = -4821091908649684910L;

	public IncludeFileNotFoundException(String msg) {
      super(msg);
    }
  }
  
}
