package util;

/** A intList of integers. **/
public class intList implements Cloneable { 
  
  private int contents;
  private intList next = null;
  
/** Add an object as the intList's first element. */
  public void prepend(int i) {
    intList old = new intList();
    old.contents = contents;
    old.next = next;
    contents = i;
    next = old;
  }
  
/** Add an object as the intList's last element. */
  public void append(int i) {
    intList l = this;
    while (l.next != null) l = l.next;
    l.contents = i;
    l.next = new intList();
  }
  
/** Append another intList to this one (without copying). */
  public void concat(intList arg) {
    intList l = this;
    while (l.next != null) l = l.next;
    l.contents = arg.contents;
    l.next = arg.next;
  }
  
/** Determine whether the intList is empty. */
  public boolean isEmpty() { return next == null; }
  
  public int head() {
    if (isEmpty()) {
      throw new InternalError("head of empty intList requested");
    }
    else return contents;
  }
  
/** Return the tail of the intList (which is required to be non-empty). */
  public intList tail() {
    if (isEmpty()) {
      throw new InternalError("tail of empty intList requested");
    }
    else return next;
  }
  
/** Remove the head of the intList (which is required to be non-empty). */
  public void removeFirst() {
    if (isEmpty()) {
      throw new InternalError("tried to remove element from empty intList");
    }
    else {
      contents = next.contents;
      next = next.next;
    }
  }
  
/** Return the length of the intList. */
  public int length() {
    int result = 0;
    intList l = this;
    while (!l.isEmpty()) {
      result++;
      l = l.tail();
    }
    return result;
  }
  
  public Object clone() {
    intList result = null;
    try { result = (intList)super.clone(); } catch (CloneNotSupportedException e) { }
    if (!isEmpty()) result.next = (intList)next.clone();
    return result;
  }

}
