/*
 * Decompiled with CFR 0.152.
 */
package haubold.birkdesktop;

import haubold.birkdesktop.AlignmentMenu;
import haubold.birkdesktop.EvolutionMenu;
import haubold.birkdesktop.MatchMenu;
import haubold.birkdesktop.ProbabilityMenu;
import haubold.resources.demo.DemoFrameListener;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.BirkhaeuserSplashWindow;
import haubold.resources.util.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class BirkDesktop
extends JFrame {
    JDesktopPane desktop;
    InternalFrameListener internalFrameListener;
    BirkhaeuserGUIComponents bgc;
    private static JFrame frame;
    static BirkhaeuserSplashWindow splash;
    JToolBar taskBar;
    JInternalFrame testFrame1;
    JInternalFrame testFrame2;
    JLabel imageLabel;
    DemoFrameListener dfl;
    int demoWidth = 550;
    int demoHeight = 400;
    Rectangle demoBounds;
    static int frameHeight;
    static int frameWidth;
    String version = "1.0";
    String helpPath = "haubold/resources/help/";
    ImageIcon frameIcon;
    ArrayList activeFrames;

    static {
        frameHeight = 750;
        frameWidth = 940;
    }

    public BirkDesktop() {
        super("Bioinformer");
        this.setDefaultCloseOperation(3);
        splash = new BirkhaeuserSplashWindow("haubold/resources/images/birk.jpg", this, 5000, this.version);
        this.bgc = new BirkhaeuserGUIComponents(this.version);
        this.activeFrames = new ArrayList();
        this.desktop = new JDesktopPane();
        this.desktop.setToolTipText("Select program from menu");
        this.frameIcon = Icons.getTreeIcon();
        this.setIconImage(this.frameIcon.getImage());
        String imageName = "haubold/resources/images/bioinformer.gif";
        ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource(imageName));
        this.imageLabel = new JLabel(icon);
        this.imageLabel.setBounds(0, 0, frameWidth, frameHeight);
        this.desktop.add((Component)this.imageLabel, new Integer(0));
        this.imageLabel.setVisible(true);
        this.desktop.setDragMode(1);
        this.internalFrameListener = new InternalFrameIconifyListener();
        this.demoBounds = new Rectangle(this.demoWidth, this.demoHeight);
        this.taskBar = new JToolBar();
        this.taskBar.setBackground(this.bgc.getColor2());
        this.taskBar.setToolTipText("Task Manager");
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBackground(this.bgc.getColor2());
        JMenu fileMenu = new JMenu("File");
        fileMenu.setBackground(this.bgc.getColor2());
        fileMenu.setMnemonic('F');
        menuBar.add(fileMenu);
        JMenuItem exitMenuItem = new JMenuItem("Exit", 88);
        exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        FileActionListener fileActionListener = new FileActionListener();
        exitMenuItem.addActionListener(fileActionListener);
        fileMenu.add(exitMenuItem);
        menuBar.add(new AlignmentMenu(this));
        menuBar.add(new MatchMenu(this));
        menuBar.add(new ProbabilityMenu(this));
        menuBar.add(new EvolutionMenu(this));
        JMenu aboutMenu = new JMenu("About");
        aboutMenu.setBackground(this.bgc.getColor2());
        aboutMenu.setMnemonic('b');
        menuBar.add(aboutMenu);
        JMenuItem menuItem = this.bgc.getAboutMenuItem("About Bioinformer");
        aboutMenu.add(menuItem);
        menuItem.setMnemonic('b');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.setJMenuBar(menuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.desktop, "Center");
        this.getContentPane().add((Component)this.taskBar, "South");
    }

    public static void main(String[] arg) {
        frame = new BirkDesktop();
        splash.close();
        frame.setSize(frameWidth, frameHeight);
        frame.setVisible(true);
    }

    public String getHelpPath() {
        return this.helpPath;
    }

    public Rectangle getDemoBounds() {
        return this.demoBounds;
    }

    public JToolBar getTaskBar() {
        return this.taskBar;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public ImageIcon getFrameIcon() {
        return this.frameIcon;
    }

    public ArrayList getActiveFrames() {
        return this.activeFrames;
    }

    public void setActiveFrames(ArrayList activeFrames) {
        this.activeFrames = activeFrames;
    }

    public class InternalFrameIconifyListener
    extends InternalFrameAdapter {
        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            JInternalFrame source = (JInternalFrame)internalFrameEvent.getSource();
            System.out.println("Iconified: " + source.getTitle());
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            JInternalFrame source = (JInternalFrame)internalFrameEvent.getSource();
            System.out.println("Deiconified: " + source.getTitle());
        }
    }

    class FileActionListener
    implements ActionListener {
        FileActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "Exit") {
                frame.dispose();
                System.exit(0);
            }
        }
    }
}

