/*
 * Decompiled with CFR 0.152.
 */
package haubold.coalescent;

import haubold.resources.util.BirkhaeuserGUIComponents;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class HaplotypePanel
extends JPanel {
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    int h = 150;
    int w = 503;
    boolean draw = false;
    double[][] haplotypes;

    public void setHeight(int h) {
    }

    public void setWidth(int w) {
    }

    public void drawHaplotypes(double[][] ha) {
        this.haplotypes = ha;
        this.draw = true;
        this.repaint();
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int border = 10;
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        g2.setPaint(this.bgc.getColor2());
        AffineTransform transform = g2.getTransform();
        g2.fill(rectangle);
        double xScale = (double)this.getWidth() / (double)this.w;
        double yScale = (double)this.getHeight() / (double)this.h;
        double scale = Math.min(xScale, yScale);
        int tx = (int)(((double)this.getWidth() - (double)this.w * scale) / 2.0);
        int ty = (int)(((double)this.getHeight() - (double)this.h * scale) / 2.0);
        g2.translate(tx, ty);
        g2.scale(scale, scale);
        if (this.draw) {
            int sampleSize = this.haplotypes.length;
            int positions = this.haplotypes[0].length;
            int step = (int)((double)(this.h - border) / (double)sampleSize);
            if (step < 1) {
                step = 1;
            }
            double yPos = border;
            int i = 0;
            while (i < sampleSize) {
                g2.setPaint(Color.black);
                if (sampleSize < 16) {
                    g2.drawString(String.valueOf(i + 1), 2, (int)yPos + 2);
                }
                g2.drawLine(2 * border, (int)yPos, this.w - border, (int)yPos);
                g2.setPaint(Color.red);
                int j = 0;
                while (j < positions) {
                    if (this.haplotypes[i][j] > 0.0) {
                        Rectangle2D.Float dot = new Rectangle2D.Float((int)((double)(2 * border) + this.haplotypes[i][j] * (double)(this.w - 3 * border)), (int)yPos - 2, 4.0f, 4.0f);
                        g2.fill(dot);
                    }
                    ++j;
                }
                yPos += (double)step;
                ++i;
            }
        }
        g2.setTransform(transform);
    }

    public void setDrawing(boolean d) {
        this.draw = d;
    }
}

