/*
 * Decompiled with CFR 0.152.
 */
package haubold.hashtable;

import haubold.hashtable.SequenceHash;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.PrintableJPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class DotPlot
extends PrintableJPanel {
    SequenceHash hash = new SequenceHash();
    char[] seq1;
    char[] seq2;
    int wordLength;
    StringBuffer key = new StringBuffer();
    ArrayList list;
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    boolean reset = false;

    public void paint(Graphics g) {
        double sx = 1.0;
        double sy = 1.0;
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D big = bi.createGraphics();
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        big.setRenderingHints(qualityHints);
        big.setColor(this.bgc.getColor1());
        big.fillRect(0, 0, this.getWidth(), this.getHeight());
        big.setColor(Color.black);
        if (this.seq1 != null) {
            AffineTransform transform = big.getTransform();
            sx = (double)this.getWidth() / (double)this.seq1.length * 0.9;
            sy = (double)this.getHeight() / (double)this.seq2.length * 0.9;
            double scale = Math.min(sx, sy);
            int tx = (int)(((double)this.getWidth() - (double)this.seq1.length * scale) / 2.0);
            int ty = (int)(((double)this.getHeight() - (double)this.seq2.length * scale) / 2.0);
            big.translate(tx, ty);
            big.scale(scale, scale);
            big.setColor(Color.red);
            big.drawRect(0, 0, this.seq1.length, this.seq2.length);
            big.scale(1.0 / scale, 1.0 / scale);
            big.drawString("Sequence 1 ->", 0, (int)((double)this.seq2.length * scale) + 10);
            big.rotate(1.5707963267948966);
            big.drawString("Sequence 2 ->", 0, 10);
            big.rotate(-1.5707963267948966);
            big.scale(scale, scale);
            double tickX = Math.pow(10.0, Math.floor(Math.log(this.seq1.length) / Math.log(10.0)));
            double tickY = Math.pow(10.0, Math.floor(Math.log(this.seq2.length) / Math.log(10.0)));
            big.setColor(Color.black);
            int i = 0;
            if (this.seq1.length > 99 && this.seq2.length > 99) {
                while (i < this.seq1.length) {
                    big.drawLine(i, -((int)((double)Math.min(ty, tx) / 5.0 * 4.0)), i, 0);
                    big.scale(1.0 / scale, 1.0 / scale);
                    big.drawString(String.valueOf(i), (int)((double)i * scale), -((int)((double)ty / 5.0 * 4.0 * scale)));
                    big.scale(scale, scale);
                    i = (int)((double)i + tickX);
                }
                i = 0;
                while (i < this.seq2.length) {
                    big.drawLine(this.seq1.length, i, (int)((double)this.seq1.length + (double)Math.min(tx, ty) / 5.0 * 4.0), i);
                    big.scale(1.0 / scale, 1.0 / scale);
                    big.drawString(String.valueOf(i), (int)(((double)this.seq1.length + (double)Math.min(tx, ty) / 5.0 * 4.0) * scale), (int)((double)i * scale));
                    big.scale(scale, scale);
                    i = (int)((double)i + tickY);
                }
                g = big;
            }
            this.hash.hashSequence(this.seq1, this.wordLength);
            int max = 0;
            i = 0;
            while (i < this.seq2.length - this.wordLength + 1) {
                this.key.delete(0, this.key.length());
                int j = 0;
                while (j < this.wordLength) {
                    this.key.append(this.seq2[i + j]);
                    ++j;
                }
                if (this.hash.containsKey(this.key.toString())) {
                    this.list = (ArrayList)this.hash.get(this.key.toString());
                    j = 0;
                    while (j < this.list.size()) {
                        Integer pos = (Integer)this.list.get(j);
                        if (max < pos) {
                            max = pos;
                        }
                        double x1 = ((Integer)this.list.get(j)).doubleValue();
                        double y1 = i;
                        double x2 = x1 + (double)this.wordLength;
                        double y2 = y1 + (double)this.wordLength;
                        big.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                        ++j;
                    }
                }
                ++i;
            }
            big.setTransform(transform);
        }
        g2.drawImage((Image)bi, 0, 0, this);
    }

    public void setSequences(String sequence1, String sequence2) {
        this.seq1 = sequence1.toCharArray();
        this.seq2 = sequence2.toCharArray();
        this.reset = false;
        this.repaint();
    }

    public void setWordLength(int wordLength) {
        this.wordLength = wordLength;
        this.repaint();
    }

    public void reset() {
        this.seq1 = null;
        this.repaint();
    }
}

