/*
 * Decompiled with CFR 0.152.
 */
package haubold.hashtable;

import haubold.hashtable.DotPlot;
import haubold.resources.demo.DemoFileMenu;
import haubold.resources.demo.DemoFrame;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.DataContainer;
import haubold.resources.util.Icons;
import haubold.resources.util.OpenSequenceMenuItem;
import haubold.resources.util.PrintMenuItem;
import haubold.sequencetools.SequenceTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DotPlotDemo
extends DemoFrame {
    JTextPane textPane1;
    JTextPane textPane2;
    JScrollPane scrollPane1;
    JScrollPane scrollPane2;
    JSlider slider;
    JLabel lengthLabel;
    JButton dotButton;
    JButton resetButton;
    JButton randomizeButton;
    JToolBar toolBar;
    JPanel controlPanel;
    JPanel textPanel;
    DotPlot plotPanel;
    DataContainer dataContainer;
    String initialText1;
    String initialText2;
    JSplitPane splitPane = new JSplitPane();
    int initialWordLength = 11;
    BirkhaeuserGUIComponents bgc;
    Random random;
    SequenceTools sequenceTools;
    PrintMenuItem pmi;

    public DotPlotDemo(String titleString, String helpPath) {
        this.setTitle(titleString);
        this.setHelpPath(helpPath);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BorderLayout());
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new GridLayout(2, 1));
        this.toolBar = new JToolBar();
        this.bgc = new BirkhaeuserGUIComponents();
        DefaultBoundedRangeModel brm = new DefaultBoundedRangeModel(this.initialWordLength, 0, 1, 40);
        this.slider = new JSlider(brm);
        this.slider.setMajorTickSpacing(10);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(false);
        int i = 1;
        while (i <= 4) {
            this.slider.getLabelTable().remove(new Integer(i * 10 + 1));
            this.slider.getLabelTable().put(new Integer(i * 10), new JLabel(new Integer(i * 10).toString(), 0));
            ++i;
        }
        this.slider.setLabelTable(this.slider.getLabelTable());
        this.slider.setBorder(new TitledBorder("Match Length"));
        LengthListener lengthListener = new LengthListener();
        this.slider.addChangeListener(lengthListener);
        this.lengthLabel = new JLabel();
        this.lengthLabel.setPreferredSize(new Dimension(30, 30));
        this.lengthLabel.setHorizontalTextPosition(4);
        this.lengthLabel.setText(" " + String.valueOf(this.slider.getValue()));
        this.dotButton = new JButton(Icons.get1rightArrow());
        this.dotButton.setToolTipText("Dot");
        HashActionListener hashActionListener = new HashActionListener();
        this.dotButton.addActionListener(hashActionListener);
        this.resetButton = new JButton(Icons.getUndo());
        this.resetButton.setToolTipText("Reset");
        ResetActionListener resetActionListener = new ResetActionListener();
        this.resetButton.addActionListener(resetActionListener);
        this.randomizeButton = new JButton(Icons.getDie());
        this.randomizeButton.setToolTipText("Randomize Sequence");
        RandomActionListener randomActionListener = new RandomActionListener();
        this.randomizeButton.addActionListener(randomActionListener);
        this.toolBar.add(this.dotButton);
        this.toolBar.add(this.randomizeButton);
        this.toolBar.add(this.resetButton);
        this.toolBar.add(this.slider);
        this.toolBar.add(this.lengthLabel);
        this.dataContainer = new DataContainer();
        this.initialText1 = this.dataContainer.getAdh();
        this.initialText2 = this.dataContainer.getAdh2();
        this.textPane1 = new JTextPane();
        this.textPane2 = new JTextPane();
        this.scrollPane1 = new JScrollPane(this.textPane1);
        this.scrollPane2 = new JScrollPane(this.textPane2);
        TitledBorder scrollBorder1 = new TitledBorder("Sequence 1");
        TitledBorder scrollBorder2 = new TitledBorder("Sequence 2");
        this.scrollPane1.setBorder(scrollBorder1);
        this.scrollPane2.setBorder(scrollBorder2);
        this.scrollPane1.setPreferredSize(new Dimension(200, 100));
        this.scrollPane2.setPreferredSize(new Dimension(200, 100));
        Font font = new Font("monospaced", 0, 12);
        this.textPane1.setFont(font);
        this.textPane2.setFont(font);
        this.textPane1.setText(this.initialText1);
        this.textPane2.setText(this.initialText2);
        this.textPane1.setCaretPosition(0);
        this.textPane2.setCaretPosition(0);
        this.plotPanel = new DotPlot();
        DemoFileMenu fileMenu = this.getFileMenu();
        JMenuItem exitMenuItem = fileMenu.getExitMenuItem();
        OpenSequenceMenuItem osmi1 = new OpenSequenceMenuItem("Open Sequence 1", this.textPane1);
        osmi1.setMnemonic(49);
        osmi1.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        fileMenu.add(osmi1);
        OpenSequenceMenuItem osmi2 = new OpenSequenceMenuItem("Open Sequence 2", this.textPane2);
        osmi2.setMnemonic(50);
        osmi2.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        fileMenu.add(osmi2);
        this.pmi = this.getFileMenu().getPrintMenuItem();
        this.pmi.setPrintable(this.plotPanel);
        fileMenu.add(this.pmi);
        fileMenu.add(exitMenuItem);
        this.setFileMenu(fileMenu);
        this.textPanel.add((Component)this.scrollPane1, "North");
        this.textPanel.add((Component)this.scrollPane2, "South");
        this.controlPanel.add((Component)this.toolBar, "North");
        this.controlPanel.add((Component)this.textPanel, "Center");
        this.splitPane = new JSplitPane(0);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.add(this.controlPanel);
        this.splitPane.add(this.plotPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.random = new Random();
        this.sequenceTools = new SequenceTools();
    }

    class ResetActionListener
    implements ActionListener {
        ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DotPlotDemo.this.textPane1.setText(DotPlotDemo.this.initialText1);
            DotPlotDemo.this.textPane2.setText(DotPlotDemo.this.initialText2);
            DotPlotDemo.this.textPane1.setCaretPosition(0);
            DotPlotDemo.this.textPane2.setCaretPosition(0);
            DotPlotDemo.this.slider.setValue(DotPlotDemo.this.initialWordLength);
            DotPlotDemo.this.plotPanel.reset();
        }
    }

    class HashActionListener
    implements ActionListener {
        ArrayList list;
        String key;
        String position = "";

        HashActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String seq1 = DotPlotDemo.this.textPane1.getText();
            String seq2 = DotPlotDemo.this.textPane2.getText();
            int l = DotPlotDemo.this.slider.getValue();
            DotPlotDemo.this.plotPanel.setWordLength(l);
            DotPlotDemo.this.plotPanel.setSequences(seq1, seq2);
        }
    }

    class RandomActionListener
    implements ActionListener {
        RandomActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String s1 = DotPlotDemo.this.textPane1.getText();
            String s2 = DotPlotDemo.this.textPane2.getText();
            DotPlotDemo.this.textPane1.setText(DotPlotDemo.this.sequenceTools.randomizeSequence(s1));
            DotPlotDemo.this.textPane2.setText(DotPlotDemo.this.sequenceTools.randomizeSequence(s2));
        }
    }

    class LengthListener
    implements ChangeListener {
        LengthListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int l = DotPlotDemo.this.slider.getValue();
            DotPlotDemo.this.lengthLabel.setText(" " + String.valueOf(l));
        }
    }
}

