/*
 * Decompiled with CFR 0.152.
 */
package haubold.hashtable;

import haubold.hashtable.SequenceHash;
import haubold.resources.demo.DemoFrame;
import haubold.resources.util.BirkhaeuserAboutButton;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.Icons;
import haubold.resources.util.StringTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

public class HashTableDemo
extends DemoFrame {
    JSlider slider;
    JLabel lengthLabel;
    JButton hashButton;
    JButton resetButton;
    JPanel controlPanel;
    JLabel textLabel;
    BirkhaeuserAboutButton aboutButton;
    JTextField textField;
    JToolBar toolBar;
    JTable table;
    JScrollPane scrollPane;
    String initialText = "AAGACGTAGATAGACCGT";
    SequenceHash hash;
    DefaultTableModel tableModel;
    String[] tableHeader;
    BirkhaeuserGUIComponents bgc;
    StringTablePanel tablePanel;

    public HashTableDemo(String titleString, String helpPath) {
        this.setTitle(titleString);
        this.setHelpPath(helpPath);
        this.hash = new SequenceHash();
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.bgc = new BirkhaeuserGUIComponents();
        this.slider = this.bgc.getSlider(1, 20, 3, "Word Length");
        this.slider.setMinorTickSpacing(1);
        this.slider.setMajorTickSpacing(5);
        LengthListener lengthListener = new LengthListener();
        this.slider.addChangeListener(lengthListener);
        this.lengthLabel = new JLabel();
        this.lengthLabel.setPreferredSize(new Dimension(30, 30));
        this.lengthLabel.setHorizontalTextPosition(4);
        this.lengthLabel.setText(String.valueOf(this.slider.getValue()));
        this.hashButton = new JButton(Icons.get1rightArrow());
        this.hashButton.setToolTipText("Hash Sequence");
        HashActionListener hashActionListener = new HashActionListener();
        this.hashButton.addActionListener(hashActionListener);
        this.resetButton = new JButton(Icons.getUndo());
        this.resetButton.setToolTipText("Reset");
        ResetActionListener resetActionListener = new ResetActionListener();
        this.resetButton.addActionListener(resetActionListener);
        this.toolBar.add(this.slider);
        this.toolBar.add(this.lengthLabel);
        this.toolBar.add(this.hashButton);
        this.toolBar.add(this.resetButton);
        this.textLabel = new JLabel(" Text: ");
        this.textField = new JTextField();
        this.textField.addActionListener(hashActionListener);
        this.textField.setText(this.initialText);
        this.tablePanel = new StringTablePanel();
        this.tablePanel.setPreferredSize(new Dimension(200, 50));
        this.tablePanel.setText("".toCharArray());
        this.controlPanel.add((Component)this.toolBar, "North");
        this.controlPanel.add((Component)this.textLabel, "West");
        this.controlPanel.add((Component)this.textField, "Center");
        this.controlPanel.add((Component)this.tablePanel, "South");
        this.tableModel = new DefaultTableModel();
        this.tableHeader = new String[2];
        this.tableHeader[0] = "Word";
        this.tableHeader[1] = "Position";
        this.tableModel.setColumnIdentifiers(this.tableHeader);
        this.table = new JTable();
        this.table.setModel(this.tableModel);
        this.scrollPane = new JScrollPane(this.table);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.controlPanel, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
    }

    private void fillTable() {
        String position = "";
        String text = this.textField.getText();
        int l = this.slider.getValue();
        this.hash.hashSequence(text.toCharArray(), l);
        Set keys = this.hash.keySet();
        Object[][] tableData = new Object[keys.size()][2];
        Iterator keyIterator = keys.iterator();
        int i = 0;
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            tableData[i][0] = key;
            ArrayList list = (ArrayList)this.hash.get(key);
            position = "";
            int j = 0;
            while (j < list.size()) {
                int p = (Integer)list.get(j) + 1;
                position = String.valueOf(position) + p + " ";
                ++j;
            }
            tableData[i][1] = position;
            ++i;
        }
        this.tableModel.setDataVector(tableData, this.tableHeader);
        this.tablePanel.setText(text.toCharArray());
    }

    class ResetActionListener
    implements ActionListener {
        ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            HashTableDemo.this.textField.setText(HashTableDemo.this.initialText);
            Object[][] o = new Object[0][0];
            HashTableDemo.this.tableModel.setDataVector(o, HashTableDemo.this.tableHeader);
            HashTableDemo.this.slider.setValue(3);
            HashTableDemo.this.tablePanel.setText("".toCharArray());
        }
    }

    class HashActionListener
    implements ActionListener {
        HashActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            HashTableDemo.this.fillTable();
        }
    }

    class LengthListener
    implements ChangeListener {
        LengthListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int l = HashTableDemo.this.slider.getValue();
            HashTableDemo.this.lengthLabel.setText(String.valueOf(l));
        }
    }
}

