/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.algorithm;

import haubold.hmm.algorithm.HiddenMarkovModel;

public class Forward {
    private double[][] forwardProbabilities;
    private double[] scale;
    private double logP;

    public void computeForward(HiddenMarkovModel hmm, int[] observedStates) {
        int states = hmm.getNumStates();
        int length = observedStates.length;
        this.forwardProbabilities = new double[states][length];
        this.scale = new double[length];
        double[][] observationProbabilities = hmm.getObservationProbabilities();
        double[][] transitionProbabilities = hmm.getTransitionProbabilities();
        int i = 0;
        while (i < length) {
            this.scale[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < states) {
            this.forwardProbabilities[i][0] = hmm.getInitialProbabilities()[i] * transitionProbabilities[i][observedStates[0]];
            this.scale[0] = this.scale[0] + this.forwardProbabilities[i][0];
            ++i;
        }
        i = 1;
        while (i < states) {
            double[] dArray = this.forwardProbabilities[i];
            dArray[0] = dArray[0] / this.scale[0];
            ++i;
        }
        i = 1;
        while (i < length) {
            int j = 0;
            while (j < states) {
                double s = 0.0;
                int k = 0;
                while (k < states) {
                    s += this.forwardProbabilities[k][i - 1] * transitionProbabilities[k][j];
                    ++k;
                }
                this.forwardProbabilities[j][i] = s * observationProbabilities[j][observedStates[i]];
                int n = i;
                this.scale[n] = this.scale[n] + this.forwardProbabilities[j][i];
                ++j;
            }
            j = 0;
            while (j < states) {
                double[] dArray = this.forwardProbabilities[j];
                int n = i;
                dArray[n] = dArray[n] / this.scale[i];
                ++j;
            }
            ++i;
        }
        this.logP = 0.0;
        i = 0;
        while (i < length) {
            this.logP += Math.log(this.scale[i]);
            ++i;
        }
    }

    public double[][] getForwardProbabilities() {
        return this.forwardProbabilities;
    }

    public double[] getScale() {
        return this.scale;
    }

    public double getLogP() {
        return this.logP;
    }
}

