/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.gui;

import haubold.hmm.algorithm.SequenceUnit;
import haubold.resources.util.BirkhaeuserGUIComponents;
import java.awt.Color;
import java.util.Random;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class HmmPane
extends JTextPane {
    private BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    private Color state1Color = this.bgc.getColor2();
    private Color state2Color = this.bgc.getColor4();
    private Color emission1Color = this.bgc.getColor3();
    private Color emission2Color = this.bgc.getColor5();
    private Style[][] styleQuartet;
    private String[][] styleNameQuartet;
    private Random ran;

    public HmmPane() {
        this.getStyleNameQuartet();
        this.ran = new Random();
        this.setEditable(false);
    }

    public String[][] getStyleNameQuartet() {
        this.styleQuartet = new Style[2][2];
        this.styleNameQuartet = new String[2][2];
        this.styleNameQuartet[0][0] = "1";
        this.styleNameQuartet[0][1] = "2";
        this.styleNameQuartet[1][0] = "3";
        this.styleNameQuartet[1][1] = "4";
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style base = this.addStyle("base", def);
        StyleConstants.setFontFamily(base, "monospaced");
        StyleConstants.setFontSize(base, 12);
        this.styleQuartet[0][0] = this.addStyle(this.styleNameQuartet[0][0], base);
        this.styleQuartet[0][1] = this.addStyle(this.styleNameQuartet[0][1], base);
        this.styleQuartet[1][0] = this.addStyle(this.styleNameQuartet[1][0], base);
        this.styleQuartet[1][1] = this.addStyle(this.styleNameQuartet[1][1], base);
        StyleConstants.setForeground(this.styleQuartet[0][0], this.emission1Color);
        StyleConstants.setForeground(this.styleQuartet[0][1], this.emission2Color);
        StyleConstants.setForeground(this.styleQuartet[1][0], this.emission1Color);
        StyleConstants.setForeground(this.styleQuartet[1][1], this.emission2Color);
        StyleConstants.setBackground(this.styleQuartet[0][0], this.state1Color);
        StyleConstants.setBackground(this.styleQuartet[0][1], this.state1Color);
        StyleConstants.setBackground(this.styleQuartet[1][0], this.state2Color);
        StyleConstants.setBackground(this.styleQuartet[1][1], this.state2Color);
        return this.styleNameQuartet;
    }

    public void setSequenceData(SequenceUnit[] sequenceData) {
        Document doc = this.getDocument();
        try {
            doc.remove(0, doc.getLength());
            int i = 0;
            while (i < sequenceData.length) {
                if (sequenceData[i].getNucleotide().equals("A") || sequenceData[i].getNucleotide().equals("T")) {
                    doc.insertString(doc.getLength(), sequenceData[i].getNucleotide(), this.getStyle(this.styleNameQuartet[sequenceData[i].getHiddenState()][0]));
                } else {
                    doc.insertString(doc.getLength(), sequenceData[i].getNucleotide(), this.getStyle(this.styleNameQuartet[sequenceData[i].getHiddenState()][1]));
                }
                ++i;
            }
            this.setCaretPosition(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setState1Color(Color color) {
        this.state1Color = color;
    }

    public void setState2Color(Color color) {
        this.state2Color = color;
    }

    public void setEmission1Color(Color color) {
        this.emission1Color = color;
    }

    public void setEmission2Color(Color color) {
        this.emission2Color = color;
    }
}

