/*
 * Decompiled with CFR 0.152.
 */
package haubold.phylogeny.distance;

import haubold.phylogeny.distance.Alignment;
import haubold.phylogeny.distance.DistanceComputationGUI;
import haubold.phylogeny.distance.DistanceTreeGUI;
import haubold.phylogeny.util.Node;
import haubold.phylogeny.util.TreePanel;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.DataContainer;
import haubold.resources.util.Icons;
import haubold.resources.util.PrintableJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;

public class BootstrapGUI
extends PrintableJPanel {
    JToolBar toolBar;
    JButton bootstrapButton;
    JButton resetButton;
    JButton animateButton;
    JPanel dataPanel;
    JSplitPane splitPane;
    JScrollPane alignmentScroll;
    JScrollPane distanceScroll;
    JScrollPane bootstrapScroll;
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    TreePanel treePanel;
    JTextPane bootstrapPane;
    JSlider stepSlider;
    Random ran;
    StringBuffer sb;
    boolean animate = false;
    DistanceComputationGUI distanceComputationGUI = new DistanceComputationGUI();
    DistanceTreeGUI distanceTreeGUI = new DistanceTreeGUI();
    DataContainer dataContainer;

    public BootstrapGUI() {
        this.toolBar = new JToolBar();
        this.bootstrapButton = new JButton(Icons.get2rightArrow());
        this.bootstrapButton.setToolTipText("Bootstrap");
        BootstrapActionListener bal = new BootstrapActionListener();
        this.bootstrapButton.addActionListener(bal);
        this.animateButton = new JButton(Icons.getRun());
        this.animateButton.setToolTipText("Animate");
        AnimateActionListener aal = new AnimateActionListener();
        this.animateButton.addActionListener(aal);
        this.resetButton = new JButton(Icons.getUndo());
        this.resetButton.setToolTipText("Reset");
        ResetActionListener ral = new ResetActionListener();
        this.resetButton.addActionListener(ral);
        this.stepSlider = this.bgc.getSlider(1, 10, 4, "Step Time");
        this.stepSlider.setEnabled(false);
        this.stepSlider.setSnapToTicks(true);
        this.toolBar.add(this.bootstrapButton);
        this.toolBar.add(this.animateButton);
        this.toolBar.add(this.resetButton);
        this.toolBar.add(this.stepSlider);
        this.distanceScroll = this.distanceComputationGUI.getDistanceScroll();
        this.distanceTreeGUI.setDistancePane(this.distanceComputationGUI.getDistancePane());
        System.out.println(this.distanceTreeGUI.getDistancePane().getText());
        this.alignmentScroll = this.distanceComputationGUI.getAlignmentScroll();
        this.treePanel = new TreePanel();
        this.distanceTreeGUI.setTreePanel(this.treePanel);
        this.bootstrapPane = new JTextPane();
        Font font = new Font("Courier", 0, 12);
        this.bootstrapPane.setFont(font);
        this.bootstrapPane.setBackground(this.bgc.getColor1());
        this.bootstrapScroll = new JScrollPane(this.bootstrapPane);
        this.bootstrapPane.setBackground(this.bgc.getColor1());
        this.distanceComputationGUI.setAlignmentPane2(this.bootstrapPane);
        this.alignmentScroll.setBorder(new TitledBorder("Original Data"));
        this.bootstrapScroll.setBorder(new TitledBorder("Bootstrapped Data"));
        this.distanceScroll.setBorder(new TitledBorder("Distance Matrix"));
        this.dataPanel = new JPanel();
        this.dataPanel.setLayout(new GridLayout(3, 1));
        this.dataPanel.add(this.alignmentScroll);
        this.dataPanel.add(this.bootstrapScroll);
        this.dataPanel.add(this.distanceScroll);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.treePanel = new TreePanel();
        this.splitPane = new JSplitPane(0, this.dataPanel, this.treePanel);
        this.dataPanel.setPreferredSize(new Dimension(100, 200));
        this.splitPane.setOneTouchExpandable(true);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setDividerLocation(-1);
        this.ran = new Random();
        this.sb = new StringBuffer();
        this.dataContainer = new DataContainer();
    }

    private Alignment bootstrap(Alignment alignment) {
        char[][] al1 = alignment.getAlignment();
        char[][] al2 = new char[al1.length][al1[0].length];
        int i = 0;
        while (i < al1[0].length) {
            int r = this.ran.nextInt(al1[0].length);
            int j = 0;
            while (j < al1.length) {
                al2[j][i] = al1[j][r];
                ++j;
            }
            ++i;
        }
        alignment.setAlignment(al2);
        return alignment;
    }

    private void step0() {
        Alignment alignment = this.distanceComputationGUI.getAlignment();
        this.distanceComputationGUI.getAlignmentPane().setCaretPosition(0);
        alignment = this.bootstrap(alignment);
        String[] taxa = alignment.getTaxa();
        char[][] al = alignment.getAlignment();
        if (this.sb.length() > 0) {
            this.sb.delete(0, this.sb.length());
        }
        int i = 0;
        while (i < taxa.length) {
            this.sb.append(">" + taxa[i] + "\n");
            int j = 0;
            while (j < al[i].length) {
                this.sb.append(al[i][j]);
                ++j;
            }
            this.sb.append("\n");
            ++i;
        }
        this.bootstrapPane.setText(this.sb.toString());
        this.bootstrapPane.setCaretPosition(0);
        if (!this.animate) {
            this.distanceComputationGUI.getDistancePane().setText("");
            this.treePanel.setTree(null);
        }
    }

    private void step1() {
        this.distanceComputationGUI.runAction();
    }

    private void step2() {
        this.distanceTreeGUI.runAction();
        Node[] tree = this.distanceTreeGUI.getTree();
        this.treePanel.setTree(tree);
    }

    public DistanceComputationGUI getDistanceComputationGUI() {
        return this.distanceComputationGUI;
    }

    public void setDistanceComputationGUI(DistanceComputationGUI computationGUI) {
        this.distanceComputationGUI = computationGUI;
    }

    class ResetActionListener
    implements ActionListener {
        ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            BootstrapGUI.this.distanceComputationGUI.getAlignmentPane().setText(BootstrapGUI.this.dataContainer.getAlignment());
            BootstrapGUI.this.distanceComputationGUI.getAlignmentPane().setCaretPosition(0);
            BootstrapGUI.this.distanceComputationGUI.getDistancePane().setText("");
            BootstrapGUI.this.treePanel.setTree(null);
            BootstrapGUI.this.bootstrapPane.setText("");
        }
    }

    class BootstrapActionListener
    implements ActionListener {
        Alignment alignment;
        String[] taxa;
        char[][] al;
        int step = 0;

        BootstrapActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (this.step == 0) {
                BootstrapGUI.this.bootstrapButton.setToolTipText("Distance");
                BootstrapGUI.this.step0();
                ++this.step;
            } else if (this.step == 1) {
                BootstrapGUI.this.bootstrapButton.setToolTipText("Tree");
                BootstrapGUI.this.step1();
                ++this.step;
            } else if (this.step == 2) {
                BootstrapGUI.this.bootstrapButton.setToolTipText("Bootstrap");
                BootstrapGUI.this.step2();
                this.step = 0;
            }
        }
    }

    class AnimateActionListener
    implements ActionListener {
        Animation animation;

        AnimateActionListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            if (!BootstrapGUI.this.animate) {
                this.animation = new Animation();
                BootstrapGUI.this.animate = true;
                this.animation.start();
                BootstrapGUI.this.animateButton.setToolTipText("Stop");
                BootstrapGUI.this.animateButton.setIcon(Icons.getStop());
                BootstrapGUI.this.bootstrapButton.setEnabled(false);
                BootstrapGUI.this.resetButton.setEnabled(false);
                BootstrapGUI.this.stepSlider.setEnabled(true);
            } else {
                BootstrapGUI.this.animate = false;
                BootstrapGUI.this.animateButton.setToolTipText("Animate");
                BootstrapGUI.this.animateButton.setIcon(Icons.getRun());
                BootstrapGUI.this.bootstrapButton.setEnabled(true);
                BootstrapGUI.this.resetButton.setEnabled(true);
                BootstrapGUI.this.stepSlider.setEnabled(false);
            }
        }
    }

    class Animation
    extends Thread {
        long sleepTime = 200L;

        Animation() {
        }

        public void run() {
            while (BootstrapGUI.this.animate) {
                this.sleepTime = BootstrapGUI.this.stepSlider.getValue() * 50;
                BootstrapGUI.this.step0();
                if (!BootstrapGUI.this.animate) break;
                try {
                    Animation.sleep(this.sleepTime);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (!BootstrapGUI.this.animate) break;
                BootstrapGUI.this.step1();
                if (!BootstrapGUI.this.animate) break;
                try {
                    Animation.sleep(this.sleepTime);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (!BootstrapGUI.this.animate) break;
                BootstrapGUI.this.step2();
                if (!BootstrapGUI.this.animate) break;
                try {
                    Animation.sleep(this.sleepTime);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

