/*
 * Decompiled with CFR 0.152.
 */
package haubold.phylogeny.distance;

import haubold.phylogeny.distance.DistanceTree;
import haubold.phylogeny.util.InternalNode;
import haubold.phylogeny.util.LeafNode;
import haubold.phylogeny.util.Node;
import haubold.phylogeny.util.TreePanel;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class NJTree
extends DistanceTree {
    Node root = null;
    Node[] tree;
    ArrayList indexList1 = new ArrayList();
    ArrayList indexList2 = new ArrayList();
    DecimalFormat decimalFormat = new DecimalFormat("0.000");
    int nodeCounter;
    boolean debug;
    TreePanel treePanel = new TreePanel();

    public NJTree(double[][] distanceMatrix, String[] taxa) {
        this.distanceMatrix = distanceMatrix;
        this.taxa = taxa;
        this.computeTree();
    }

    private void computeTree() {
        this.tree = this.initializeTree(this.distanceMatrix, this.taxa);
        this.tree = this.constructTreeTopology(this.distanceMatrix, this.tree);
        this.tree = this.computeXPositions(this.tree);
        this.treePanel.setTree(this.tree);
        if (this.debug) {
            this.monitorTree(this.tree[this.tree.length - 1]);
        }
    }

    private Node[] initializeTree(double[][] dm, String[] taxa) {
        int n = dm.length;
        Node[] tree = new Node[2 * n - 2];
        Object root = null;
        int i = 0;
        while (i < n) {
            tree[i] = new LeafNode();
            tree[i].setYPosition(0.0);
            tree[i].setIndex(i);
            if (taxa[i] != null) {
                ((LeafNode)tree[i]).setLabel(taxa[i]);
            } else {
                ((LeafNode)tree[i]).setLabel("");
            }
            ++i;
        }
        i = n;
        while (i < 2 * n - 2) {
            tree[i] = new InternalNode();
            tree[i].setIndex(i);
            ++i;
        }
        return tree;
    }

    private Node[] constructTreeTopology(double[][] dm, Node[] tree) {
        int j;
        double[][] dm2 = new double[dm.length][dm.length];
        double[][] correctedDist = new double[dm.length][dm.length];
        double[] totalDist = new double[dm.length];
        int[] indices = new int[dm.length];
        Object root = null;
        int n = dm.length - 2;
        double yPosition = 0.0;
        int i = 0;
        while (i < indices.length) {
            indices[i] = i;
            ++i;
        }
        i = 0;
        while (i < dm.length) {
            j = 0;
            while (j < dm.length) {
                dm2[i][j] = dm[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < dm.length) {
            totalDist[i] = 0.0;
            j = 0;
            while (j < dm.length) {
                int n2 = i;
                totalDist[n2] = totalDist[n2] + dm[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < dm.length) {
            j = 0;
            while (j < dm.length) {
                correctedDist[i][j] = dm[i][j] - (totalDist[i] + totalDist[j]) / ((double)dm.length - 2.0);
                ++j;
            }
            ++i;
        }
        i = dm.length;
        while (i < tree.length - 3) {
            int[] minIndices = this.findMinIndices(correctedDist);
            tree[i].setLeftChild(tree[indices[minIndices[0]]]);
            tree[i].setRightChild(tree[indices[minIndices[1]]]);
            tree[i].getLeftChild().setParent(tree[i]);
            tree[i].getRightChild().setParent(tree[i]);
            double dLeft = 1.0 / (2.0 * ((double)n - 2.0)) * (((double)n - 2.0) * dm2[indices[minIndices[0]]][indices[minIndices[1]]] + totalDist[indices[minIndices[0]]] - totalDist[indices[minIndices[1]]]);
            double dRight = 1.0 / (2.0 * ((double)n - 2.0)) * (((double)n - 2.0) * dm2[indices[minIndices[0]]][indices[minIndices[1]]] - totalDist[indices[minIndices[0]]] + totalDist[indices[minIndices[1]]]);
            tree[i].getLeftChild().setBranchLength(dLeft);
            tree[i].getRightChild().setBranchLength(dRight);
            indices[Math.max((int)minIndices[0], (int)minIndices[1])] = indices[--n];
            indices[Math.min((int)minIndices[1], (int)minIndices[0])] = i;
            double[][] dm3 = new double[n][n];
            int k = 0;
            while (k < n) {
                int l = k + 1;
                while (l < 0) {
                    if (indices[k] != i && indices[l] != i) {
                        dm3[k][l] = dm2[k][l];
                        dm3[l][k] = dm3[k][l];
                    }
                    ++l;
                }
                ++k;
            }
            dm2 = this.reconstructDistanceMatrix(dm2, indices, n, tree);
            ++i;
        }
        return tree;
    }

    private double[][] reconstructDistanceMatrix(double[][] dm, int[] indices, int n, Node[] tree) {
        double[][] dm2 = new double[n][n];
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                double d = this.distance(tree[indices[i]], tree[indices[j]], dm);
                dm2[i][j] = d;
                dm2[i][j] = d;
                dm2[j][i] = dm2[i][j];
                ++j;
            }
            ++i;
        }
        return dm2;
    }

    private int[] findMinIndices(double[][] dm) {
        int[] indices = new int[2];
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < dm.length - 1) {
            int j = i + 1;
            while (j < dm.length) {
                if (min > dm[i][j]) {
                    min = dm[i][j];
                    indices[0] = i;
                    indices[1] = j;
                }
                ++j;
            }
            ++i;
        }
        return indices;
    }

    private double distance(Node node1, Node node2, double[][] dm) {
        double d = 0.0;
        this.indexList1.clear();
        this.indexList2.clear();
        this.findLeafIndices(node1, this.indexList1);
        this.findLeafIndices(node2, this.indexList2);
        int n1 = this.indexList1.size();
        int n2 = this.indexList2.size();
        int i = 0;
        while (i < n1) {
            int j = 0;
            while (j < n2) {
                int x = Integer.parseInt(this.indexList1.get(i).toString());
                int y = Integer.parseInt(this.indexList2.get(j).toString());
                d += dm[x][y];
                ++j;
            }
            ++i;
        }
        return d /= (double)n1 * (double)n2;
    }

    private void findLeafIndices(Node node, ArrayList indexList) {
        if (!node.isLeaf()) {
            this.findLeafIndices(node.getLeftChild(), indexList);
        }
        if (!node.isLeaf()) {
            this.findLeafIndices(node.getRightChild(), indexList);
        } else {
            indexList.add(new Integer(node.getIndex()));
        }
    }

    public void setDistanceMatrix(double[][] distanceMatrix) {
        this.distanceMatrix = distanceMatrix;
        this.computeTree();
    }

    private Node[] computeXPositions(Node[] tree) {
        double h = tree[tree.length - 1].getYPosition();
        double w = h / 1.618;
        double xStep = w / (double)(tree.length - 1);
        this.nodeCounter = 0;
        this.traverseXPositions(tree[tree.length - 1], xStep);
        return tree;
    }

    public Node[] getTree() {
        return this.tree;
    }

    private void printDistanceMatrix(double[][] dm, int[] indices) {
        System.out.print("\n\n");
        int i = 0;
        while (i < dm.length) {
            System.out.print(String.valueOf(indices[i]) + "\t");
            int j = 0;
            while (j < dm.length) {
                System.out.print(String.valueOf(this.decimalFormat.format(dm[i][j])) + "\t");
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
    }

    private void monitorTree(Node node) {
        if (!node.isLeaf()) {
            this.monitorTree(node.getLeftChild());
        }
        System.out.println("id: " + node.getId() + " leaf: " + node.isLeaf() + " xPosition: " + node.getXPosition());
        if (!node.isLeaf()) {
            node = node.getRightChild();
            this.monitorTree(node);
        }
    }

    private void traverseXPositions(Node node, double xStep) {
        if (!node.isLeaf()) {
            this.traverseXPositions(node.getLeftChild(), xStep);
        }
        node.setXPosition((double)this.nodeCounter * xStep);
        ++this.nodeCounter;
        if (!node.isLeaf()) {
            this.traverseXPositions(node.getRightChild(), xStep);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

