/*
 * Decompiled with CFR 0.152.
 */
package haubold.resources.util;

import haubold.resources.util.ExtensionFileFilter;
import haubold.resources.util.StringUtils;
import haubold.sequencetools.BioSequence;
import haubold.sequencetools.SequenceReader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;

public class OpenSequenceMenuItem
extends JMenuItem {
    JTextPane textPane;
    JFileChooser fileChooser;
    StringUtils stringUtils;
    StringBuffer stringBuffer;

    public OpenSequenceMenuItem() {
        this.fileChooser = new JFileChooser();
        this.addActionListener(new OpenActionListener());
        this.stringUtils = new StringUtils();
        this.stringBuffer = new StringBuffer();
    }

    public OpenSequenceMenuItem(String title, JTextPane textPane) {
        this.setText(title);
        this.textPane = textPane;
        this.fileChooser = new JFileChooser();
        ExtensionFileFilter fileFilter = new ExtensionFileFilter("Sequence Files (*.fasta, *.fas, *.embl, *.em, *.gbk, *.gb)", new String[]{"fasta", "fas", "embl", "em", "gbk", "gb"});
        this.fileChooser.addChoosableFileFilter(fileFilter);
        this.addActionListener(new OpenActionListener());
        this.stringUtils = new StringUtils();
        this.stringBuffer = new StringBuffer();
    }

    public OpenSequenceMenuItem(String title, int mnemonic, JTextPane textPane) {
        this.setText(title);
        this.setMnemonic(mnemonic);
        this.textPane = textPane;
        this.fileChooser = new JFileChooser();
        ExtensionFileFilter fileFilter = new ExtensionFileFilter("Sequence Files (*.fasta, *.fas, *.embl, *.em, *.gbk, *.gb)", new String[]{"fasta", "fas", "embl", "em", "gbk", "gb"});
        this.fileChooser.addChoosableFileFilter(fileFilter);
        this.addActionListener(new OpenActionListener());
        this.stringUtils = new StringUtils();
        this.stringBuffer = new StringBuffer();
    }

    private void open() {
        String seq = "";
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            SequenceReader sequenceReader = new SequenceReader(file.getPath());
            this.stringBuffer.delete(0, this.stringBuffer.length());
            while (!sequenceReader.isEmpty()) {
                BioSequence bioSequence = sequenceReader.getBioSequence();
                seq = bioSequence.getSequence();
                String name = bioSequence.getName();
                this.stringBuffer.append(">" + name + "\n" + seq + "\n");
            }
            if (this.stringBuffer.length() < 499001) {
                this.setSequence(this.stringBuffer.toString());
                this.textPane.setCaretPosition(0);
            } else {
                JOptionPane.showMessageDialog(this, "I am sorry, but I cannot display sequence data totalling more than 499,000 residues.");
            }
        }
    }

    private void setSequence(String seq) throws Error {
        this.textPane.setText(seq);
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void setTextPane(JTextPane pane) {
        this.textPane = pane;
    }

    class OpenActionListener
    implements ActionListener {
        OpenActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            OpenSequenceMenuItem.this.open();
        }
    }
}

