/*
 * Decompiled with CFR 0.152.
 */
package haubold.resources.util;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.text.Document;

public class PrintMenuItem
extends JMenuItem {
    private Printable printable;
    private JMenuItem menuItem;

    public PrintMenuItem(String text, int mnemonic, Printable printable) {
        this.setText(text);
        this.setMnemonic(mnemonic);
        this.printable = printable;
        this.addActionListener(new PrintActionListener());
        this.menuItem = this;
    }

    public PrintMenuItem(String text, int mnemonic, Document document) {
        DocFlavor.STRING docFlavor = DocFlavor.STRING.TEXT_HTML;
        SimpleDoc myDoc = new SimpleDoc(document, docFlavor, null);
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        PrintService[] services = PrintServiceLookup.lookupPrintServices(docFlavor, aset);
        ServiceUI.printDialog(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0].getConfigurations()[0], 100, 100, services, services[0], docFlavor, aset);
    }

    public Printable getPrintable() {
        return this.printable;
    }

    public void setPrintable(Printable printable) {
        this.printable = printable;
    }

    class PrintActionListener
    implements ActionListener {
        PrintActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setPrintable(PrintMenuItem.this.printable);
            if (pj.printDialog()) {
                try {
                    pj.print();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(PrintMenuItem.this.menuItem, "Unfortunately, the current printer setup leads to an error. Please choose a different printer setup");
                    ex.printStackTrace();
                }
            }
        }
    }
}

