/*
 * Decompiled with CFR 0.152.
 */
package haubold.sm;

import haubold.maths.Algebra;

public class PamComputation {
    int[][] lod = new int[20][20];
    double[][] pamN = new double[20][20];
    double[][] pam1 = new double[][]{{9867.0, 2.0, 9.0, 10.0, 3.0, 8.0, 17.0, 21.0, 2.0, 6.0, 4.0, 2.0, 6.0, 2.0, 22.0, 35.0, 32.0, 0.0, 2.0, 18.0}, {1.0, 9913.0, 1.0, 0.0, 1.0, 10.0, 0.0, 0.0, 10.0, 3.0, 1.0, 19.0, 4.0, 1.0, 4.0, 6.0, 1.0, 8.0, 0.0, 1.0}, {4.0, 1.0, 9822.0, 36.0, 0.0, 4.0, 6.0, 6.0, 21.0, 3.0, 1.0, 13.0, 0.0, 1.0, 2.0, 20.0, 9.0, 1.0, 4.0, 1.0}, {6.0, 0.0, 42.0, 9859.0, 0.0, 6.0, 53.0, 6.0, 4.0, 1.0, 0.0, 3.0, 0.0, 0.0, 1.0, 5.0, 3.0, 0.0, 0.0, 1.0}, {1.0, 1.0, 0.0, 0.0, 9973.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 5.0, 1.0, 0.0, 3.0, 2.0}, {3.0, 9.0, 4.0, 5.0, 0.0, 9876.0, 27.0, 1.0, 23.0, 1.0, 3.0, 6.0, 4.0, 0.0, 6.0, 2.0, 2.0, 0.0, 0.0, 1.0}, {10.0, 0.0, 7.0, 56.0, 0.0, 35.0, 9865.0, 4.0, 2.0, 3.0, 1.0, 4.0, 1.0, 0.0, 3.0, 4.0, 2.0, 0.0, 1.0, 2.0}, {21.0, 1.0, 12.0, 11.0, 1.0, 3.0, 7.0, 9935.0, 1.0, 0.0, 1.0, 2.0, 1.0, 1.0, 3.0, 21.0, 3.0, 0.0, 0.0, 5.0}, {1.0, 8.0, 18.0, 3.0, 1.0, 20.0, 1.0, 0.0, 9912.0, 0.0, 1.0, 1.0, 0.0, 2.0, 3.0, 1.0, 1.0, 1.0, 4.0, 1.0}, {2.0, 2.0, 3.0, 1.0, 2.0, 1.0, 2.0, 0.0, 0.0, 9872.0, 9.0, 2.0, 12.0, 7.0, 0.0, 1.0, 7.0, 0.0, 1.0, 33.0}, {3.0, 1.0, 3.0, 0.0, 0.0, 6.0, 1.0, 1.0, 4.0, 22.0, 9947.0, 2.0, 45.0, 13.0, 3.0, 1.0, 3.0, 4.0, 2.0, 15.0}, {2.0, 37.0, 25.0, 6.0, 0.0, 12.0, 7.0, 2.0, 2.0, 4.0, 1.0, 9926.0, 20.0, 0.0, 3.0, 8.0, 11.0, 0.0, 1.0, 1.0}, {1.0, 1.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 5.0, 8.0, 4.0, 9874.0, 1.0, 0.0, 1.0, 2.0, 0.0, 0.0, 4.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 8.0, 6.0, 0.0, 4.0, 9946.0, 0.0, 2.0, 1.0, 3.0, 28.0, 0.0}, {13.0, 5.0, 2.0, 1.0, 1.0, 8.0, 3.0, 2.0, 5.0, 1.0, 2.0, 2.0, 1.0, 1.0, 9926.0, 12.0, 4.0, 0.0, 0.0, 2.0}, {28.0, 11.0, 34.0, 7.0, 11.0, 4.0, 6.0, 16.0, 2.0, 2.0, 1.0, 7.0, 4.0, 3.0, 17.0, 9840.0, 38.0, 5.0, 2.0, 2.0}, {22.0, 2.0, 13.0, 4.0, 1.0, 3.0, 2.0, 2.0, 1.0, 11.0, 2.0, 8.0, 6.0, 1.0, 5.0, 32.0, 9871.0, 0.0, 2.0, 9.0}, {0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 9976.0, 1.0, 0.0}, {1.0, 0.0, 3.0, 0.0, 3.0, 0.0, 1.0, 0.0, 4.0, 1.0, 1.0, 0.0, 0.0, 21.0, 0.0, 1.0, 1.0, 2.0, 9945.0, 1.0}, {13.0, 2.0, 1.0, 1.0, 3.0, 2.0, 2.0, 3.0, 3.0, 57.0, 11.0, 1.0, 17.0, 1.0, 3.0, 2.0, 10.0, 0.0, 2.0, 9901.0}};
    double[] frequency = new double[]{0.087, 0.041, 0.04, 0.047, 0.033, 0.038, 0.05, 0.089, 0.034, 0.037, 0.085, 0.081, 0.015, 0.04, 0.051, 0.07, 0.058, 0.01, 0.03, 0.065};
    String[] aminoAcids = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V"};

    public PamComputation() {
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                this.pam1[i][j] = this.pam1[i][j] / 10000.0;
                ++j;
            }
            ++i;
        }
    }

    private double[][] computePamN(int n) {
        int i = 0;
        while (i < 20) {
            this.pamN[i][i] = 1.0;
            int j = 0;
            while (j < 20) {
                if (i != j) {
                    this.pamN[i][j] = 0.0;
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= n) {
            this.pamN = Algebra.matrixMultiplication((double[][])this.pamN, (double[][])this.pam1);
            ++i;
        }
        return this.pamN;
    }

    public int getPercentDifference() {
        double s = 0.0;
        int i = 0;
        while (i < 20) {
            s += this.frequency[i] * 1.0 * this.pamN[i][i];
            ++i;
        }
        int difference = (int)Math.round(100.0 * (1.0 - s));
        return difference;
    }

    public int[][] getLod(int n, double scale) {
        this.computePamN(n);
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                this.lod[i][j] = (int)Math.round(Math.log(this.pamN[i][j] / this.frequency[i]) / (Math.log(2.0) / scale));
                ++j;
            }
            ++i;
        }
        return this.lod;
    }

    public String[] getAminoAcids() {
        return this.aminoAcids;
    }
}

