/*
 * Decompiled with CFR 0.152.
 */
package haubold.sm;

import haubold.resources.util.BirkhaeuserAboutButton;
import haubold.resources.util.Icons;
import haubold.resources.util.PrintableJPanel;
import haubold.sm.MatrixDisplayPanel;
import haubold.sm.PamComputation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PamPanel
extends PrintableJPanel {
    MatrixDisplayPanel lodPanel;
    static JSlider nSlider;
    static JSlider sSlider;
    JLabel nLabel;
    JLabel sLabel;
    JButton resetButton;
    JButton aboutButton;
    ResetActionListener resetAction;
    JToolBar toolBar;
    JDialog aboutDialog;
    BirkhaeuserAboutButton birkButton;
    PamComputation pamComputation = new PamComputation();
    int initN = 70;
    int initS = 2;
    String[] aminoAcids;
    int[][] values = this.pamComputation.getLod(this.initN, this.initS);
    int diff;

    public PamPanel() {
        this.aminoAcids = this.pamComputation.getAminoAcids();
        this.diff = this.pamComputation.getPercentDifference();
        this.lodPanel = new MatrixDisplayPanel(this.values, this.aminoAcids, this.diff);
        this.lodPanel.setAminoAcids(this.pamComputation.getAminoAcids());
        this.lodPanel.setValues(this.pamComputation.getLod(this.initN, this.initS));
        this.lodPanel.setPercentDifference(this.pamComputation.getPercentDifference());
        this.lodPanel.repaint();
        this.nLabel = new JLabel();
        this.nLabel.setPreferredSize(new Dimension(40, 10));
        this.nLabel.setHorizontalAlignment(0);
        this.nLabel.setText(String.valueOf(this.initN));
        this.sLabel = new JLabel();
        this.sLabel.setPreferredSize(new Dimension(40, 10));
        this.sLabel.setHorizontalAlignment(0);
        this.sLabel.setText("1/" + this.initS);
        DefaultBoundedRangeModel brm = new DefaultBoundedRangeModel(10, 2, 2, 502);
        nSlider = new JSlider(brm);
        nSlider.setMajorTickSpacing(100);
        nSlider.setPaintTicks(true);
        nSlider.setPaintLabels(true);
        nSlider.setSnapToTicks(false);
        int i = 1;
        while (i <= 5) {
            nSlider.getLabelTable().remove(new Integer(i * 100 + 2));
            nSlider.getLabelTable().put(new Integer(i * 100), new JLabel(new Integer(i * 100).toString(), 0));
            ++i;
        }
        nSlider.setLabelTable(nSlider.getLabelTable());
        nSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PamPanel.this.nSliderChanged(e);
            }
        });
        TitledBorder nBorder = new TitledBorder("PAM");
        nSlider.setBorder(nBorder);
        sSlider = new JSlider(1, 5, this.initS);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(1), new JLabel("1/1"));
        labelTable.put(new Integer(2), new JLabel("1/2"));
        labelTable.put(new Integer(3), new JLabel("1/3"));
        labelTable.put(new Integer(4), new JLabel("1/4"));
        labelTable.put(new Integer(5), new JLabel("1/5"));
        sSlider.setLabelTable(labelTable);
        sSlider.setMajorTickSpacing(1);
        sSlider.setPaintTicks(true);
        sSlider.setPaintLabels(true);
        sSlider.setSnapToTicks(true);
        sSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PamPanel.this.sSliderChanged(e);
            }
        });
        TitledBorder sBorder = new TitledBorder("Bits");
        sSlider.setBorder(sBorder);
        this.resetButton = new JButton(Icons.getUndo());
        this.resetButton.setToolTipText("Reset");
        this.resetAction = new ResetActionListener();
        this.resetButton.addActionListener(this.resetAction);
        this.birkButton = new BirkhaeuserAboutButton();
        this.birkButton.setTitleString("About \"PAM\"");
        this.toolBar = new JToolBar();
        this.toolBar.add(nSlider);
        this.toolBar.add(this.nLabel);
        this.toolBar.add(sSlider);
        this.toolBar.add(this.resetButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.lodPanel, "Center");
    }

    void resetButtonAction(ActionEvent e) {
        nSlider.setValue(this.initN);
        sSlider.setValue(this.initS);
    }

    public static int getN() {
        return nSlider.getValue();
    }

    public static int getScale() {
        return sSlider.getValue();
    }

    void nSliderChanged(ChangeEvent e) {
        int n = nSlider.getValue();
        int s = sSlider.getValue();
        this.nLabel.setText(String.valueOf(n));
        this.lodPanel.setValues(this.pamComputation.getLod(n, s));
        this.lodPanel.setPercentDifference(this.pamComputation.getPercentDifference());
        this.lodPanel.repaint();
    }

    void sSliderChanged(ChangeEvent e) {
        int n = nSlider.getValue();
        int s = sSlider.getValue();
        this.sLabel.setText("1/" + s);
        this.lodPanel.setValues(this.pamComputation.getLod(n, s));
        this.lodPanel.setPercentDifference(this.pamComputation.getPercentDifference());
        this.lodPanel.repaint();
    }

    class ResetActionListener
    implements ActionListener {
        ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            nSlider.setValue(PamPanel.this.initN);
            sSlider.setValue(PamPanel.this.initS);
        }
    }
}

