/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.suffixtree.algorithms;

import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.PrintableJPanel;
import haubold.stringmatching.suffixtree.algorithms.SuffixNode;
import haubold.stringmatching.suffixtree.algorithms.SuffixTree;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.QuadCurve2D;
import javax.swing.JPanel;

public class DrawPanel
extends PrintableJPanel {
    SuffixTree tree;
    float xPos;
    int maxLabel;
    int maxLevel;
    int tableHeight;
    SuffixNode root;
    JPanel panel;
    float xScale;
    float yScale;
    float borderWidth = 20.0f;
    int labelLength;
    float xIncrement;
    float yIncrement;
    float arrowSize = 10.0f;
    float arrowAngle = (float)Math.toRadians(15.0);
    float xPositionString;
    float yPositionString;
    AffineTransform originalTransform;
    AffineTransform transform;
    char[] text;
    boolean first = true;
    Color green = new Color(0, 153, 0);
    Color darkBlue = new Color(0, 0, 153);
    Color lightBlue = new Color(150, 150, 255);
    boolean edgeLabel = true;
    boolean nodeLabel = true;
    boolean leafLabel = true;
    boolean suffixLink = false;
    QuadCurve2D.Float quad = new QuadCurve2D.Float();
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();

    public DrawPanel() {
        this.transform = new AffineTransform();
    }

    public DrawPanel(SuffixTree tree) {
        this.tree = tree;
        this.transform = new AffineTransform();
    }

    private void positionNodes() {
        this.root = this.tree.getRoot();
        this.text = this.tree.getText();
        this.text[this.text.length - 1] = 36;
        this.maxLabel = 0;
        this.maxLevel = 0;
        if (this.root != null) {
            this.initializeTree(this.root);
            this.root.setYPos(0.5f);
            this.xPos = 2.0f;
            this.traverseTree(this.root);
        }
    }

    private void initializeTree(SuffixNode node) {
        node.setYPos(0.0f);
        node.setXPos(0.0f);
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.initializeTree(children[i]);
                ++i;
            }
        }
    }

    private void traverseTree(SuffixNode node) {
        if (node.getParent() != null && (double)node.getYPos() == 0.0) {
            node.setYPos(node.getParent().getYPos() + 1.0f);
            if (node.getYPos() > (float)this.maxLevel) {
                this.maxLevel = (int)node.getYPos();
            }
            if (node.getEndLabel() - node.getStartLabel() > this.maxLabel) {
                this.maxLabel = node.getEndLabel() - node.getStartLabel();
            }
        }
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.traverseTree(children[i]);
                ++i;
            }
            children = node.getChildren();
            node.setXPos(children[0].getXPos() + (children[children.length - 1].getXPos() - children[0].getXPos()) / 2.0f);
        } else {
            float f = this.xPos;
            this.xPos = f + 1.0f;
            node.setXPos(f);
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHints(qualityHints);
        g2.setColor(this.bgc.getColor1());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(Color.BLACK);
        AffineTransform t = g2.getTransform();
        if (this.root != null) {
            g2 = this.drawTable(g2);
            this.xScale = (float)(this.getWidth() - 25) / (this.xPos + 1.0f);
            this.yScale = (float)(this.getHeight() - 2 * this.tableHeight) / (float)(this.maxLevel + 1);
            g2.translate(0.0, 1.5 * (double)this.tableHeight);
            g2 = this.drawTree(this.root, g2);
            g2.setTransform(t);
        }
    }

    private Graphics2D drawTree(SuffixNode root, Graphics2D g2) {
        g2 = this.drawEdges(root, g2);
        g2 = this.drawNodes(root, g2);
        if (this.edgeLabel) {
            g2 = this.drawEdgeLabels(root, g2);
        }
        if (this.suffixLink) {
            g2 = this.drawSuffixLinks(root, g2);
        }
        if (this.nodeLabel) {
            g2 = this.drawNodeDepth(root, g2);
        }
        return g2;
    }

    private Graphics2D drawEdges(SuffixNode node, Graphics2D g2) {
        if (node.getParent() != null) {
            g2.drawLine((int)(node.getXPos() * this.xScale), (int)(node.getYPos() * this.yScale), (int)(node.getParent().getXPos() * this.xScale), (int)(node.getParent().getYPos() * this.yScale));
        }
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.drawEdges(children[i], g2);
                ++i;
            }
        }
        return g2;
    }

    private Graphics2D drawEdgeLabels(SuffixNode node, Graphics2D g2) {
        if (node.getParent() != null) {
            AffineTransform aT;
            AffineTransform rotate;
            this.labelLength = node.getEndLabel() - node.getStartLabel();
            float a = (node.getParent().getXPos() - node.getXPos()) * this.xScale;
            float b = (node.getYPos() - node.getParent().getYPos()) * this.yScale;
            float c = (float)Math.sqrt(Math.pow(a, 2.0) + Math.pow(b, 2.0));
            double theta = 1.5707963267948966 + Math.asin((double)a / (double)c);
            double sc = 1.0;
            if ((float)(this.labelLength * 10) > c / 2.0f) {
                this.xPositionString = node.getXPos() * this.xScale + a / 1.2f;
                this.yPositionString = node.getYPos() * this.yScale - b / 1.2f;
                rotate = AffineTransform.getRotateInstance(theta, this.xPositionString, this.yPositionString);
                aT = g2.getTransform();
                g2.transform(rotate);
                sc = Math.min((double)c / 1.2 / (double)this.labelLength / 10.0, 1.0);
                AffineTransform scale = AffineTransform.getScaleInstance(sc, sc);
                g2.transform(scale);
            } else {
                this.xPositionString = node.getXPos() * this.xScale + a / 2.0f;
                this.yPositionString = node.getYPos() * this.yScale - b / 2.0f;
                rotate = AffineTransform.getRotateInstance(theta, this.xPositionString, this.yPositionString);
                aT = g2.getTransform();
                g2.transform(rotate);
            }
            if (sc > 0.1 && this.edgeLabel) {
                g2.setColor(Color.red);
                g2.drawChars(this.text, node.getStartLabel(), node.getEndLabel() - node.getStartLabel() + 1, (int)((double)this.xPositionString / sc), (int)((double)this.yPositionString / sc));
                g2.setColor(Color.black);
            }
            g2.setTransform(aT);
        }
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.drawEdgeLabels(children[i], g2);
                ++i;
            }
        }
        return g2;
    }

    private Graphics2D drawNodes(SuffixNode node, Graphics2D g2) {
        if (node.isLeaf()) {
            g2.setColor(this.green);
            g2.fillRect((int)(node.getXPos() * this.xScale - 2.0f), (int)(node.getYPos() * this.yScale), 5, 5);
            if (this.leafLabel) {
                g2.drawString(String.valueOf(node.getLeafLabel() + 1), node.getXPos() * this.xScale - 5.0f, node.getYPos() * this.yScale + 15.0f);
            }
            g2.setColor(Color.black);
        } else if (node.getParent() != null) {
            g2.fillOval((int)(node.getXPos() * this.xScale - 2.0f), (int)(node.getYPos() * this.yScale), 5, 5);
        } else {
            g2.setColor(this.lightBlue);
            g2.fillOval((int)(node.getXPos() * this.xScale - 2.0f), (int)(node.getYPos() * this.yScale), 5, 5);
            g2.setColor(Color.black);
        }
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.drawNodes(children[i], g2);
                ++i;
            }
        }
        return g2;
    }

    private Graphics2D drawNodeDepth(SuffixNode node, Graphics2D g2) {
        if (node.getParent() == null) {
            g2.setColor(this.lightBlue);
            g2.drawString(String.valueOf(node.getNodeDepth()), node.getXPos() * this.xScale - 4.0f, node.getYPos() * this.yScale - 2.0f);
            g2.setColor(Color.black);
        } else if (!node.isLeaf()) {
            g2.drawString(String.valueOf(node.getNodeDepth()), node.getXPos() * this.xScale + 5.0f, node.getYPos() * this.yScale + 5.0f);
        }
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.drawNodeDepth(children[i], g2);
                ++i;
            }
        }
        return g2;
    }

    private Graphics2D drawSuffixLinks(SuffixNode node, Graphics2D g2) {
        if (node.getSuffixLink() != null && node.getParent() != null) {
            float cy;
            float cx;
            float nx = node.getXPos() * this.xScale;
            float ny = node.getYPos() * this.yScale;
            float sx = node.getSuffixLink().getXPos() * this.xScale;
            float sy = node.getSuffixLink().getYPos() * this.yScale;
            if (node.getYPos() != node.getSuffixLink().getYPos()) {
                cx = node.getSuffixLink().getXPos() * this.xScale;
                cy = node.getYPos() * this.yScale;
            } else {
                cx = Math.min(node.getXPos(), node.getSuffixLink().getXPos()) + (Math.max(node.getXPos(), node.getSuffixLink().getXPos()) - Math.min(node.getXPos(), node.getSuffixLink().getXPos())) / 2.0f;
                cx *= this.xScale;
                cy = (node.getYPos() + 0.5f) * this.yScale;
            }
            if ((double)(node.getXPos() - node.getSuffixLink().getXPos()) < 0.1) {
                cx += 0.5f * this.xScale;
            }
            this.quad.setCurve(nx, ny, cx, cy, sx, sy);
            g2.setColor(this.darkBlue);
            g2.draw(this.quad);
            g2.drawLine((int)(node.getSuffixLink().getXPos() * this.xScale), (int)(node.getSuffixLink().getYPos() * this.yScale), (int)(node.getSuffixLink().getXPos() * this.xScale), (int)(node.getSuffixLink().getYPos() * this.yScale + 5.0f));
            float angle = (float)Math.atan2(sy - cy, sx - cx) + (float)Math.PI;
            float x3 = (int)((double)sx + Math.cos(angle - this.arrowAngle) * (double)this.arrowSize);
            float y3 = (int)((double)sy + Math.sin(angle - this.arrowAngle) * (double)this.arrowSize);
            float x4 = (int)((double)sx + Math.cos(angle + this.arrowAngle) * (double)this.arrowSize);
            float y4 = (int)((double)sy + Math.sin(angle + this.arrowAngle) * (double)this.arrowSize);
            g2.drawLine((int)sx, (int)sy, (int)x3, (int)y3);
            g2.drawLine((int)sx, (int)sy, (int)x4, (int)y4);
            g2.drawLine((int)x3, (int)y3, (int)x4, (int)y4);
            g2.setColor(Color.black);
        }
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.drawSuffixLinks(children[i], g2);
                ++i;
            }
        }
        return g2;
    }

    private Graphics2D drawTable(Graphics2D g2) {
        int cellWidth = 17;
        int cellHeight = 17;
        int tableY = 6;
        int tableX = cellWidth;
        int tableWidth = tableX + cellWidth * this.text.length;
        this.tableHeight = tableY + 2 * cellHeight;
        g2.drawLine(tableX, tableY, tableWidth, tableY);
        g2.drawLine(tableX, tableY + cellHeight, tableWidth, tableY + cellHeight);
        g2.drawLine(tableX, this.tableHeight, tableWidth, this.tableHeight);
        int i = 0;
        while (i < this.text.length) {
            g2.setColor(this.green);
            g2.drawString(String.valueOf(i + 1), tableX + cellWidth * i + 1, tableY + cellHeight - 1);
            g2.setColor(Color.black);
            g2.drawString(String.valueOf(this.text[i]), tableX + cellWidth * i + 1, tableY + 2 * cellHeight - 1);
            g2.drawLine(tableX + cellWidth * i, tableY, tableX + cellWidth * i, this.tableHeight);
            ++i;
        }
        g2.drawLine(tableX + cellWidth * i, tableY, tableX + cellWidth * i, this.tableHeight);
        return g2;
    }

    private int computeNodeDepth(SuffixNode node) {
        int nd = 0;
        while (node.getParent() != null) {
            nd += node.getEndLabel() - node.getStartLabel() + 1;
            node = node.getParent();
        }
        return nd;
    }

    public SuffixTree getTree() {
        return this.tree;
    }

    public void setTree(SuffixTree tree) {
        this.tree = tree;
        if (tree != null) {
            this.positionNodes();
        } else {
            this.root = null;
        }
        this.repaint();
    }

    public boolean isEdgeLabel() {
        return this.edgeLabel;
    }

    public boolean isLeafLabel() {
        return this.leafLabel;
    }

    public boolean isNodeLabel() {
        return this.nodeLabel;
    }

    public void setEdgeLabel(boolean edgeLabel) {
        this.edgeLabel = edgeLabel;
    }

    public void setLeafLabel(boolean leafLabel) {
        this.leafLabel = leafLabel;
    }

    public void setNodeLabel(boolean nodeLabel) {
        this.nodeLabel = nodeLabel;
    }

    public float getArrowAngle() {
        return this.arrowAngle;
    }

    public float getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowAngle(float arrowAngle) {
        this.arrowAngle = arrowAngle;
    }

    public void setArrowSize(float arrowSize) {
        this.arrowSize = arrowSize;
    }

    public boolean isSuffixLink() {
        return this.suffixLink;
    }

    public void setSuffixLink(boolean suffixLink) {
        this.suffixLink = suffixLink;
    }
}

