/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.suffixtree.algorithms;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public class SuffixNode {
    private SuffixNode parent = null;
    private SuffixNode suffixLink = null;
    private TreeMap children = null;
    private int leafLabel = -1;
    private int endLabel = -1;
    private int startLabel = -1;
    private int matchEnd = -1;
    private int nodeDepth = 0;
    private int id = nextId++;
    private float xPos = 0.0f;
    private float yPos = 0.0f;
    private boolean leaf = true;
    private boolean masked = false;
    private int stringId = 0;
    private static int nextId = 1;

    public SuffixNode() {
    }

    public SuffixNode(SuffixNode parent, int startLabel, int endLabel) {
        this.parent = parent;
        this.startLabel = startLabel;
        this.endLabel = endLabel;
    }

    public SuffixNode(SuffixNode parent, int startLabel) {
        this.parent = parent;
        this.startLabel = startLabel;
    }

    public SuffixNode getChild(char c) {
        if (this.children != null) {
            return (SuffixNode)this.children.get(new Character(c));
        }
        return null;
    }

    public void addChild(char c, SuffixNode node) {
        if (this.children == null) {
            this.children = new TreeMap();
            this.leaf = false;
        }
        this.children.put(new Character(c), node);
    }

    public void removeChild(char c) {
        this.children.remove(new Character(c));
    }

    public static int getNextId() {
        return nextId;
    }

    public SuffixNode[] getChildren() {
        Collection collection = this.children.values();
        SuffixNode[] nodes = new SuffixNode[collection.size()];
        Iterator iterator = collection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            nodes[i++] = (SuffixNode)iterator.next();
        }
        return nodes;
    }

    public int getEndLabel() {
        return this.endLabel;
    }

    public int getId() {
        return this.id;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public int getMatchEnd() {
        return this.matchEnd;
    }

    public SuffixNode getParent() {
        return this.parent;
    }

    public int getStartLabel() {
        return this.startLabel;
    }

    public float getXPos() {
        return this.xPos;
    }

    public float getYPos() {
        return this.yPos;
    }

    public static void setNextId(int nextId) {
        SuffixNode.nextId = nextId;
    }

    public void setEndLabel(int endLabel) {
        this.endLabel = endLabel;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public void setMatchEnd(int matchEnd) {
        this.matchEnd = matchEnd;
    }

    public void setParent(SuffixNode parent) {
        this.parent = parent;
    }

    public void setStartLabel(int startLabel) {
        this.startLabel = startLabel;
    }

    public void setXPos(float xPos) {
        this.xPos = xPos;
    }

    public void setYPos(float yPos) {
        this.yPos = yPos;
    }

    public int getLeafLabel() {
        return this.leafLabel;
    }

    public void setLeafLabel(int leafLabel) {
        this.leafLabel = leafLabel;
    }

    public SuffixNode getSuffixLink() {
        return this.suffixLink;
    }

    public void setSuffixLink(SuffixNode suffixLink) {
        this.suffixLink = suffixLink;
    }

    public int getNodeDepth() {
        return this.nodeDepth;
    }

    public void setNodeDepth(int nodeDepth) {
        this.nodeDepth = nodeDepth;
    }

    public boolean isMasked() {
        return this.masked;
    }

    public void setMasked(boolean masked) {
        this.masked = masked;
    }

    public int getStringId() {
        return this.stringId;
    }

    public void setStringId(int stringId) {
        this.stringId = stringId;
    }
}

