/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.suffixtree.gui;

import haubold.resources.demo.DemoFrame;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.DataContainer;
import haubold.resources.util.Icons;
import haubold.resources.util.OpenSequenceMenuItem;
import haubold.stringmatching.suffixtree.algorithms.Repeat;
import haubold.stringmatching.suffixtree.algorithms.UkkonenSuffixTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class RepeatDemo
extends DemoFrame {
    BirkhaeuserGUIComponents bgc;
    JButton runButton;
    JCheckBox longestRepeatBox;
    JComboBox textCombo;
    JSlider lengthSlider;
    JLabel lengthLabel;
    JLabel maxLabel;
    JTextPane textPane;
    int initialLength = 5;
    StyledDocument document;
    SimpleAttributeSet defaultAttributes;
    SimpleAttributeSet selectedAttributes;
    DataContainer container;
    UkkonenSuffixTree suffixTree;
    String PHI = "Phi-X174 Genome";
    String ADH = "Drosophila Adh";
    String DNA = "Double Helix Paper";
    String BLANK = "Blank Page";
    Random random = new Random();

    public RepeatDemo(String titleString, String helpPath) {
        this.setTitle(titleString);
        this.setHelpPath(helpPath);
        this.runButton = new JButton(Icons.get1rightArrow());
        this.runButton.setToolTipText("Search Repeats");
        RunListener runListener = new RunListener();
        this.runButton.addActionListener(runListener);
        this.longestRepeatBox = new JCheckBox("Longest Repeat", false);
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        this.longestRepeatBox.addActionListener(checkBoxListener);
        this.bgc = new BirkhaeuserGUIComponents();
        this.lengthSlider = this.bgc.getSlider(2, 20, this.initialLength, "Repeat Length");
        this.lengthLabel = new JLabel(String.valueOf(this.initialLength));
        this.lengthLabel.setPreferredSize(new Dimension(20, 10));
        this.lengthLabel.setHorizontalAlignment(4);
        this.lengthLabel.setFont(new Font("monospaced", 1, 12));
        LengthListener lengthListener = new LengthListener();
        this.lengthSlider.addChangeListener(lengthListener);
        TitledBorder border = new TitledBorder("Repeat Length");
        this.lengthSlider.setBorder(border);
        String[] textItems = new String[]{this.PHI, this.ADH, this.DNA, this.BLANK};
        this.textCombo = new JComboBox<String>(textItems);
        this.textCombo.setMaximumSize(new Dimension(150, 25));
        this.textCombo.setToolTipText("Text for searching");
        TextBoxListener textBoxListener = new TextBoxListener();
        this.textCombo.addActionListener(textBoxListener);
        this.maxLabel = new JLabel("; Length: ");
        this.maxLabel.setPreferredSize(new Dimension(80, 10));
        this.maxLabel.setEnabled(false);
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.runButton);
        toolBar.add(this.textCombo);
        toolBar.add(this.longestRepeatBox);
        toolBar.add(this.maxLabel);
        toolBar.add(this.lengthSlider);
        toolBar.add(this.lengthLabel);
        StyleContext context = new StyleContext();
        this.document = new DefaultStyledDocument(context);
        this.defaultAttributes = new SimpleAttributeSet();
        this.selectedAttributes = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.defaultAttributes, "monospaced");
        StyleConstants.setFontSize(this.defaultAttributes, 12);
        StyleConstants.setFontFamily(this.selectedAttributes, "monospaced");
        StyleConstants.setFontSize(this.selectedAttributes, 12);
        StyleConstants.setBackground(this.selectedAttributes, new Color(255, 204, 51));
        this.textPane = new JTextPane(this.document);
        this.textPane.setEditable(true);
        this.textPane.setDoubleBuffered(true);
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        OpenSequenceMenuItem osmi = new OpenSequenceMenuItem("Open Sequence", this.textPane);
        osmi.setMnemonic(79);
        osmi.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.getFileMenu().add((Component)osmi, 0);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)toolBar, "North");
        this.getContentPane().add((Component)scrollPane, "Center");
        this.suffixTree = new UkkonenSuffixTree();
        this.container = new DataContainer();
        this.setText();
        String text = this.textPane.getText();
        this.suffixTree.constructSuffixTree((String.valueOf(text) + "\u0000").toCharArray());
        int length = this.suffixTree.getLongestRepeatLength();
        if (length > this.lengthSlider.getMaximum()) {
            this.lengthSlider.setMaximum(length + 2);
        }
        this.lengthSlider.setValue(length);
    }

    private void setText() {
        String item = (String)this.textCombo.getSelectedItem();
        this.maxLabel.setText("length: ");
        String text = item.equals(this.ADH) ? this.container.getAdh2() : (item.equals(this.PHI) ? this.container.getPhi() : (item.equals(this.DNA) ? this.container.getWatsonCrick() : ""));
        try {
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, text, this.defaultAttributes);
            this.textPane.setCaretPosition(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.suffixTree.constructSuffixTree((String.valueOf(text) + "\u0000").toCharArray());
        int length = this.suffixTree.getLongestRepeatLength();
        if (length > this.lengthSlider.getMaximum()) {
            this.lengthSlider.setMaximum(length + 2);
        }
    }

    private void repeat() {
        String text = "";
        ArrayList repeatList = null;
        try {
            this.document.setCharacterAttributes(0, this.document.getLength(), this.defaultAttributes, true);
            text = this.document.getText(0, this.document.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.suffixTree.constructSuffixTree((String.valueOf(text) + "\u0000").toCharArray());
        if (this.longestRepeatBox.isSelected()) {
            repeatList = this.suffixTree.getLongestRepeat();
        } else {
            int length = this.lengthSlider.getValue();
            repeatList = this.suffixTree.findRepeat(length);
        }
        if (repeatList != null) {
            int i = 0;
            while (i < repeatList.size()) {
                Repeat repeat = (Repeat)repeatList.get(i);
                if (this.longestRepeatBox.isSelected()) {
                    this.maxLabel.setText("length: " + String.valueOf(repeat.getLength()));
                }
                StyleConstants.setBackground(this.selectedAttributes, new Color(this.random.nextInt(235) + 20, this.random.nextInt(235) + 20, this.random.nextInt(235) + 20));
                int j = 0;
                while (j < repeat.size()) {
                    this.document.setCharacterAttributes((Integer)repeat.get(j), repeat.getLength(), this.selectedAttributes, true);
                    ++j;
                }
                ++i;
            }
        }
    }

    class LengthListener
    implements ChangeListener {
        LengthListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int l = RepeatDemo.this.lengthSlider.getValue();
            RepeatDemo.this.lengthLabel.setText(String.valueOf(l));
        }
    }

    class TextBoxListener
    implements ActionListener {
        TextBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            RepeatDemo.this.setText();
        }
    }

    class CheckBoxListener
    implements ActionListener {
        CheckBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (RepeatDemo.this.longestRepeatBox.isSelected()) {
                RepeatDemo.this.lengthSlider.setEnabled(false);
                RepeatDemo.this.lengthLabel.setEnabled(false);
                RepeatDemo.this.maxLabel.setEnabled(true);
            } else {
                RepeatDemo.this.lengthSlider.setEnabled(true);
                RepeatDemo.this.lengthLabel.setEnabled(true);
                RepeatDemo.this.maxLabel.setText("length: ");
                RepeatDemo.this.maxLabel.setEnabled(false);
            }
        }
    }

    class RunListener
    implements ActionListener {
        RunListener() {
        }

        public void actionPerformed(ActionEvent e) {
            RepeatDemo.this.repeat();
        }
    }
}

