/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.suffixtree.gui;

import haubold.resources.demo.DemoFileMenu;
import haubold.resources.demo.DemoFrame;
import haubold.resources.util.Icons;
import haubold.stringmatching.suffixtree.algorithms.DrawPanel;
import haubold.stringmatching.suffixtree.algorithms.DrawSTLatex;
import haubold.stringmatching.suffixtree.algorithms.UkkonenSuffixTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class SuffixTreeDemo
extends DemoFrame {
    JLabel textLabel;
    JTextField textField;
    JPanel textPanel;
    JPanel guiPanel;
    JScrollPane scrollPane;
    DrawPanel treePanel;
    UkkonenSuffixTree suffixTree;
    DrawSTLatex latex;
    Random r;
    JCheckBox edgeCheckBox;
    JCheckBox nodeCheckBox;
    JCheckBox leafCheckBox;
    JCheckBox linkCheckBox;
    DemoFileMenu fileMenu;
    String initialString = "AGAAGACCTGA";

    public SuffixTreeDemo(String titleString, String helpPath) {
        this.setTitle(titleString);
        this.setHelpPath(helpPath);
        this.suffixTree = new UkkonenSuffixTree();
        this.suffixTree.setDebug(false);
        this.latex = new DrawSTLatex();
        this.textLabel = new JLabel(" Text ");
        this.textLabel.setHorizontalTextPosition(0);
        this.textLabel.setMinimumSize(new Dimension(this.textLabel.getHeight(), 20));
        this.textField = new JTextField(this.initialString);
        this.textField.setToolTipText("Enter text and press RETURN.");
        TextListener textListener = new TextListener();
        this.textField.addActionListener(textListener);
        JToolBar toolBar = new JToolBar();
        JButton treeButton = new JButton(Icons.get1rightArrow());
        treeButton.setToolTipText("Construct suffix tree.");
        treeButton.addActionListener(textListener);
        JButton resetButton = new JButton(Icons.getUndo());
        resetButton.setToolTipText("Reset");
        resetButton.addActionListener(new ResetListener());
        toolBar.add(treeButton);
        toolBar.add(resetButton);
        toolBar.add(this.textField);
        this.textPanel = new JPanel(new BorderLayout());
        this.textPanel.add((Component)toolBar, "North");
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new GridLayout(1, 4));
        this.edgeCheckBox = new JCheckBox("Edge Labels", true);
        this.edgeCheckBox.addActionListener(textListener);
        this.edgeCheckBox.setToolTipText("Labels along edges.");
        this.leafCheckBox = new JCheckBox("Leaf Labels", true);
        this.leafCheckBox.addActionListener(textListener);
        this.leafCheckBox.setToolTipText("Start positions of suffices.");
        this.nodeCheckBox = new JCheckBox("String Depth", true);
        this.nodeCheckBox.addActionListener(textListener);
        this.nodeCheckBox.setToolTipText("Repeat lengths.");
        this.linkCheckBox = new JCheckBox("Suffix Links", false);
        this.linkCheckBox.addActionListener(textListener);
        this.linkCheckBox.setToolTipText("Construction Aid");
        optionPanel.add(this.leafCheckBox);
        optionPanel.add(this.edgeCheckBox);
        optionPanel.add(this.nodeCheckBox);
        optionPanel.add(this.linkCheckBox);
        this.textPanel.add((Component)optionPanel, "South");
        this.treePanel = new DrawPanel();
        this.treePanel.setBackground(Color.RED);
        this.scrollPane = new JScrollPane(this.treePanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.textPanel, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.r = new Random();
        this.getFileMenu().getPrintMenuItem().setPrintable(this.treePanel);
    }

    class TextListener
    implements ActionListener {
        TextListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String string = SuffixTreeDemo.this.textField.getText();
            string = String.valueOf(string) + "\u0000";
            char[] c = string.toCharArray();
            SuffixTreeDemo.this.suffixTree.constructSuffixTree(c);
            if (SuffixTreeDemo.this.edgeCheckBox.isSelected()) {
                SuffixTreeDemo.this.treePanel.setEdgeLabel(true);
            } else {
                SuffixTreeDemo.this.treePanel.setEdgeLabel(false);
            }
            if (SuffixTreeDemo.this.leafCheckBox.isSelected()) {
                SuffixTreeDemo.this.treePanel.setLeafLabel(true);
            } else {
                SuffixTreeDemo.this.treePanel.setLeafLabel(false);
            }
            if (SuffixTreeDemo.this.nodeCheckBox.isSelected()) {
                SuffixTreeDemo.this.treePanel.setNodeLabel(true);
            } else {
                SuffixTreeDemo.this.treePanel.setNodeLabel(false);
            }
            if (SuffixTreeDemo.this.linkCheckBox.isSelected()) {
                SuffixTreeDemo.this.treePanel.setSuffixLink(true);
            } else {
                SuffixTreeDemo.this.treePanel.setSuffixLink(false);
            }
            SuffixTreeDemo.this.treePanel.setTree(SuffixTreeDemo.this.suffixTree);
        }
    }

    class ResetListener
    implements ActionListener {
        ResetListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            SuffixTreeDemo.this.textField.setText(SuffixTreeDemo.this.initialString);
            SuffixTreeDemo.this.treePanel.setTree(null);
        }
    }
}

