/*
 * Decompiled with CFR 0.152.
 */
package haubold.wrightfisher;

import haubold.resources.util.Arrow;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.PrintableJPanel;
import haubold.wrightfisher.Node;
import haubold.wrightfisher.TwoParent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class WrightFisherPanel
extends PrintableJPanel
implements MouseListener,
MouseMotionListener {
    Node[][] population;
    Node[][] untangledPop;
    Arrow arrow;
    Rectangle hitRect;
    Rectangle enteredRect;
    double scale;
    double translateX;
    double translateY;
    private boolean tangled;
    private boolean showMrca = false;
    private boolean showAncestral = false;
    private int offsetTop;
    private int offsetLeft;
    private int stepX;
    private int stepY;
    private int ovalSize;
    private boolean oneParent = false;
    private boolean forward;
    private boolean backward;
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    Graphics2D graphicsObject;
    TwoParent twoParent;

    public WrightFisherPanel() {
        this.arrow = new Arrow();
        this.setToolTipText("Click dots in top or bottom row");
        this.offsetTop = 10;
        this.offsetLeft = 1;
        this.stepX = 10;
        this.stepY = 12;
        this.ovalSize = 4;
        this.hitRect = new Rectangle(0, 0, 3, 3);
        this.enteredRect = new Rectangle(0, 0, 3, 3);
        this.twoParent = new TwoParent();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2;
        super.paintComponent(g);
        this.graphicsObject = g2 = (Graphics2D)g;
        g2.setColor(this.bgc.getColor1());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.population != null && this.population.length > 0 && this.population[0].length > 0) {
            this.paintPanel(g2);
        }
    }

    private void paintPanel(Graphics2D g2) {
        double w = this.population.length > 4 ? (double)(this.population[0].length + 10) * 10.0 : (double)(this.population[0].length + 6) * 10.0;
        double h = (double)(this.population.length + 2) * 12.0;
        double xScale = (double)this.getWidth() / w;
        double yScale = (double)this.getHeight() / h;
        this.scale = Math.min(xScale, yScale);
        this.translateX = ((double)this.getWidth() - w * this.scale) / 2.0;
        this.translateY = ((double)this.getHeight() - h * this.scale) / 2.0;
        g2.translate(this.translateX, this.translateY);
        g2.scale(this.scale, this.scale);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.oneParent) {
            this.paintOneParent(g2);
        } else {
            this.twoParent.paintTwoParent(g2, this.getWidth());
        }
        g2.setColor(Color.white);
        g2.setColor(this.bgc.getColor3());
        if (this.population.length > 4) {
            g2.drawString("present", (this.population[0].length + 5) * 10, (this.population.length + 1) * 12 - 7);
            g2.drawString("past", (this.population[0].length + 5) * 10, 17);
            this.arrow.drawArrow(g2, (this.population[0].length + 6) * 10, (this.population.length - 1) * 12, (this.population[0].length + 6) * 10, 29.0f);
        }
    }

    private void paintOneParent(Graphics2D g2) {
        int j;
        int width = this.getWidth();
        Node mrcaNode = null;
        int i = 0;
        g2.setColor(this.bgc.getColor3());
        g2.drawString(String.valueOf(i + 1), 10, (i + 2) * 12 - 7);
        i = 1;
        while (i < this.population.length) {
            g2.setColor(this.bgc.getColor3());
            g2.drawString(String.valueOf(i + 1), 10, (i + 2) * 12 - 7);
            g2.setColor(Color.black);
            j = 0;
            while (j < this.population[i].length) {
                Shape childShape;
                Shape parentShape;
                if (this.population[i][j].isGeneMrca()) {
                    mrcaNode = this.population[i][j];
                }
                Node parent = this.population[i][j].getAncestor1();
                Node child = this.population[i][j];
                if (this.forward) {
                    g2.setColor(child.getColorForward());
                } else {
                    g2.setColor(child.getColorBackward());
                }
                if (this.tangled) {
                    parentShape = parent.getShape();
                    childShape = child.getShape();
                } else {
                    parentShape = parent.getUntangledShape();
                    childShape = child.getUntangledShape();
                }
                g2.drawLine(parentShape.getBounds().x + 2, parentShape.getBounds().y + 2, childShape.getBounds().x + 2, childShape.getBounds().y + 2);
                ++j;
            }
            ++i;
        }
        g2.setColor(Color.black);
        int k = this.population.length - 1;
        i = 0;
        while (i < this.population[0].length) {
            if (this.population[0][i].isMouseOver()) {
                g2.setColor(Color.green);
            } else {
                g2.setColor(Color.lightGray);
            }
            g2.drawOval(this.population[0][i].getShape().getBounds().x - 1, this.population[0][i].getShape().getBounds().y - 1, 6, 6);
            ++i;
        }
        i = 0;
        while (i < this.population[0].length) {
            if (this.population[k][i].isMouseOver()) {
                g2.setColor(Color.blue);
            } else {
                g2.setColor(Color.lightGray);
            }
            g2.drawOval(this.population[k][i].getShape().getBounds().x - 1, this.population[k][i].getShape().getBounds().y - 1, 6, 6);
            g2.setColor(Color.black);
            int offset = String.valueOf(this.population[0][i].getId()).length() == 1 ? 0 : 2;
            if (this.tangled) {
                g2.translate(this.population[k][i].getShape().getBounds().x - offset, this.population[k][i].getShape().getBounds().y + 12);
                g2.scale(0.5, 0.5);
                g2.drawString(String.valueOf(this.population[0][i].getId()), 0, 0);
                g2.scale(2.0, 2.0);
                g2.translate(-(this.population[k][i].getShape().getBounds().x - offset), -(this.population[k][i].getShape().getBounds().y + 12));
            } else {
                g2.translate(this.population[k][i].getUntangledShape().getBounds().x - offset, this.population[k][i].getShape().getBounds().y + 12);
                g2.scale(0.5, 0.5);
                g2.drawString(String.valueOf(this.population[0][i].getId()), 0, 0);
                g2.scale(2.0, 2.0);
                g2.translate(-(this.population[k][i].getUntangledShape().getBounds().x - offset), -(this.population[k][i].getShape().getBounds().y + 12));
            }
            ++i;
        }
        i = 0;
        while (i < this.population.length) {
            j = 0;
            while (j < this.population[0].length) {
                if (this.forward) {
                    g2.setColor(this.population[i][j].getColorForward());
                } else if (this.population[i][j].isGeneMrca()) {
                    g2.setColor(Color.red);
                } else {
                    g2.setColor(this.population[i][j].getColorBackward());
                }
                if (this.tangled) {
                    g2.fill(this.population[i][j].getShape());
                } else {
                    g2.fill(this.population[i][j].getUntangledShape());
                }
                ++j;
            }
            ++i;
        }
        g2.setColor(Color.black);
    }

    public void setPopulation(Node[][] population) {
        this.population = population;
        this.twoParent.setPop(population);
    }

    public void setTangled(boolean tangled) {
        this.tangled = tangled;
        this.twoParent.setTangled(tangled);
    }

    public boolean isShowMrca() {
        return this.showMrca;
    }

    public void setShowMrca(boolean showMrca) {
        this.showMrca = showMrca;
    }

    public Node[][] getPopulation() {
        return this.population;
    }

    public boolean isShowAncestral() {
        return this.showAncestral;
    }

    public void setShowAncestral(boolean showAncestral) {
        this.showAncestral = showAncestral;
    }

    public void mouseClicked(MouseEvent e) {
        int popSizeMinusOne = this.population.length - 1;
        this.hitRect.x = (int)(((double)e.getX() - this.translateX) / this.scale);
        this.hitRect.y = (int)(((double)e.getY() - this.translateY) / this.scale);
        int i = 0;
        while (i < this.population[0].length) {
            if (this.tangled && this.population[0][i].getShape().intersects(this.hitRect) || !this.tangled && this.population[0][i].getUntangledShape().intersects(this.hitRect)) {
                this.forward = true;
                this.backward = false;
                if (this.population[0][i].isClicked()) {
                    this.population[0][i].setClicked(false);
                    this.population[0][i].setColorForward(Color.black);
                } else {
                    this.population[0][i].setClicked(true);
                    this.population[0][i].setColorForward(Color.green);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.population[0].length) {
            if (this.tangled && this.population[popSizeMinusOne][i].getShape().intersects(this.hitRect) || !this.tangled && this.population[popSizeMinusOne][i].getUntangledShape().intersects(this.hitRect)) {
                this.backward = true;
                this.forward = false;
                if (this.population[popSizeMinusOne][i].isClicked()) {
                    this.population[popSizeMinusOne][i].setClicked(false);
                    this.population[popSizeMinusOne][i].setColorForward(Color.black);
                } else {
                    this.population[popSizeMinusOne][i].setClicked(true);
                    this.population[popSizeMinusOne][i].setColorForward(Color.blue);
                }
            }
            ++i;
        }
        if (this.forward) {
            if (this.oneParent) {
                this.markForward(this.population);
            } else {
                this.twoParent.markForward(this.population);
            }
            this.repaint();
        } else if (this.backward) {
            if (this.oneParent) {
                this.markBackward(this.population);
            } else {
                this.twoParent.markBackward(this.population);
            }
            this.repaint();
        }
    }

    void markForward(Node[][] pop) {
        int i = 0;
        while (i < pop[0].length) {
            if (pop[pop.length - 1][i].isClicked()) {
                this.unmarkBackwardRecursive(pop[pop.length - 1][i]);
                pop[pop.length - 1][i].setClicked(false);
            }
            if (pop[0][i].isClicked()) {
                this.markForwardRecursive(pop[0][i]);
            } else {
                this.unmarkForwardRecursive(pop[0][i]);
            }
            ++i;
        }
    }

    void markForwardRecursive(Node node) {
        node.setColorForward(Color.green);
        int i = 0;
        while (i < node.getOffspring().size()) {
            this.markForwardRecursive((Node)node.getOffspring().get(i));
            ++i;
        }
    }

    void unmarkForwardRecursive(Node node) {
        node.setColorForward(Color.black);
        int i = 0;
        while (i < node.getOffspring().size()) {
            this.unmarkForwardRecursive((Node)node.getOffspring().get(i));
            ++i;
        }
    }

    private void markBackwardRecursive(Node node) {
        if (node != null) {
            node.setAncestral(true);
            node.setColorBackward(Color.blue);
            this.markBackwardRecursive(node.getAncestor1());
        }
    }

    private void unmarkBackwardRecursive(Node node) {
        if (node != null) {
            node.setGeneMrca(false);
            node.setAncestral(false);
            node.setColorBackward(Color.black);
            this.unmarkBackwardRecursive(node.getAncestor1());
        }
    }

    void markBackward(Node[][] pop) {
        int j;
        int indAnc = 0;
        int k = pop.length - 1;
        boolean color = true;
        int i = 0;
        while (i < pop.length) {
            j = 0;
            while (j < pop[0].length) {
                pop[i][j].setAncestral(false);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < pop[0].length) {
            this.unmarkBackwardRecursive(pop[k][i]);
            if (pop[0][i].isClicked()) {
                this.unmarkForwardRecursive(pop[0][i]);
                pop[0][i].setClicked(false);
            }
            ++i;
        }
        i = 0;
        while (i < pop[0].length) {
            if (pop[k][i].isClicked()) {
                this.markBackwardRecursive(pop[k][i]);
            } else {
                pop[k][i].setAncestral(false);
            }
            ++i;
        }
        i = k;
        while (i >= 0) {
            int numAnc = 0;
            j = 0;
            while (j < pop[0].length) {
                if (pop[i][j].isAncestral()) {
                    ++numAnc;
                    indAnc = j;
                }
                ++j;
            }
            if (numAnc == 1) {
                pop[i][indAnc].setGeneMrca(true);
                return;
            }
            --i;
        }
    }

    public void mouseMoved(MouseEvent e) {
        int numGenMinusOne;
        int popSize;
        if (this.population != null) {
            popSize = this.population[0].length;
            numGenMinusOne = this.population.length - 1;
        } else {
            popSize = 0;
            numGenMinusOne = -1;
        }
        boolean change = false;
        this.hitRect.x = (int)(((double)e.getX() - this.translateX) / this.scale);
        this.hitRect.y = (int)(((double)e.getY() - this.translateY) / this.scale);
        int i = 0;
        while (i < popSize) {
            if (this.population[0][i].getShape().intersects(this.hitRect)) {
                if (!this.population[0][i].isMouseOver()) {
                    change = true;
                    this.population[0][i].setMouseOver(true);
                }
            } else if (this.population[0][i].isMouseOver()) {
                change = true;
                this.population[0][i].setMouseOver(false);
            }
            ++i;
        }
        i = 0;
        while (i < popSize) {
            if (this.population[numGenMinusOne][i].getShape().intersects(this.hitRect)) {
                if (!this.population[numGenMinusOne][i].isMouseOver()) {
                    change = true;
                    this.population[numGenMinusOne][i].setMouseOver(true);
                }
            } else if (this.population[numGenMinusOne][i].isMouseOver()) {
                change = true;
                this.population[numGenMinusOne][i].setMouseOver(false);
            }
            ++i;
        }
        if (change) {
            this.repaint();
        }
    }

    public boolean isOneParent() {
        return this.oneParent;
    }

    public void setOneParent(boolean oneParent) {
        this.oneParent = oneParent;
        if (this.population != null) {
            int i = 0;
            while (i < this.population.length) {
                int j = 0;
                while (j < this.population[0].length) {
                    this.population[i][j].setColorBackward(Color.black);
                    this.population[i][j].setColorForward(Color.black);
                    this.population[i][j].setClicked(false);
                    this.population[i][j].setGeneMrca(false);
                    ++j;
                }
                ++i;
            }
            this.repaint();
        }
    }

    public Node[][] getUntangledPop() {
        return this.untangledPop;
    }

    public void setUntangledPop(Node[][] untangledPop) {
        this.untangledPop = untangledPop;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }
}

