/*
 * Decompiled with CFR 0.152.
 */
package haubold.maths;

public class Statistics {
    private double adev;
    private double ave;
    private double curt;
    private double sdev;
    private double skew;
    private double var;
    private double[] data;

    private void moment() {
        int n = this.data.length;
        if (n < 2) {
            System.out.println("Need at least 2 data popints in moment.");
            System.exit(0);
        }
        double s = 0.0;
        int j = 0;
        while (j < this.data.length) {
            s += this.data[j];
            ++j;
        }
        this.ave = s / (double)n;
        this.adev = 0.0;
        this.var = 0.0;
        this.skew = 0.0;
        this.curt = 0.0;
        double ep = 0.0;
        j = 0;
        while (j < this.data.length) {
            s = this.data[j] - this.ave;
            ep += s;
            this.adev += Math.abs(s);
            double p = s * s;
            this.var += p;
            this.skew += (p *= s);
            this.curt += (p *= s);
            ++j;
        }
        this.adev /= (double)n;
        this.var = (this.var - ep * ep / (double)n) / (double)(n - 1);
        this.sdev = Math.sqrt(this.var);
        if (this.var != 0.0) {
            this.skew /= (double)n * Math.pow(this.sdev, 3.0);
            this.curt /= (double)n * this.var * this.var - 3.0;
        } else {
            System.out.println("No skew or kurtosis when zero variance in moment.");
            System.exit(0);
        }
    }

    public double getAdev() {
        return this.adev;
    }

    public double getAve() {
        return this.ave;
    }

    public double getCurt() {
        return this.curt;
    }

    public double[] getData() {
        return this.data;
    }

    public double getSdev() {
        return this.sdev;
    }

    public double getSkew() {
        return this.skew;
    }

    public double getVar() {
        return this.var;
    }

    public void setData(double[] data) {
        this.data = data;
        this.moment();
    }
}

