/*
 * Decompiled with CFR 0.152.
 */
package haubold.sequencetools;

import haubold.sequencetools.BioSequence;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SequenceReader
extends ArrayList {
    private BufferedReader bufferedReader;
    private Pattern pattern;
    private String inputFile;
    private StringBuffer stringBuffer;
    private BioSequence bioSequence;

    public SequenceReader(String inputFile) {
        this.inputFile = inputFile;
        this.stringBuffer = new StringBuffer();
        this.bioSequence = null;
        this.pattern = Pattern.compile("[\\s\\d]");
        try {
            this.bufferedReader = new BufferedReader(new FileReader(inputFile));
            String line = this.bufferedReader.readLine();
            this.bufferedReader.close();
            this.bufferedReader = new BufferedReader(new FileReader(inputFile));
            if (line.matches("^ID.*")) {
                this.extractEmblSequences();
            } else if (line.matches("^LOCUS.*")) {
                this.extractGenBankSequences();
            } else if (line.matches(">.*")) {
                this.extractFastaSequences();
            } else {
                this.extractDefaultSequence();
            }
            this.bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void extractEmblSequences() {
        BufferedReader br = this.getBufferedReader();
        try {
            while (this.bufferedReader.ready()) {
                String line = this.bufferedReader.readLine();
                if (line.matches("^ID.*")) {
                    if (this.bioSequence != null) {
                        this.bioSequence.setSequence(this.stringBuffer.toString());
                    }
                    this.stringBuffer.delete(0, this.stringBuffer.length());
                    this.bioSequence = new BioSequence();
                    this.add(this.bioSequence);
                    String[] arguments = line.split("\\s+");
                    String name = arguments[1];
                    this.bioSequence.setName(name);
                }
                if (!line.matches("^SQ.*")) continue;
                line = this.bufferedReader.readLine();
                while (!line.matches("^//.*")) {
                    Matcher matcher = this.pattern.matcher(line);
                    line = matcher.replaceAll("");
                    this.stringBuffer.append(line);
                    line = this.bufferedReader.readLine();
                }
            }
            if (this.bioSequence != null) {
                this.bioSequence.setSequence(this.stringBuffer.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void extractGenBankSequences() {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = this.getBufferedReader();
        BioSequence bioSequence = null;
        try {
            while (this.bufferedReader.ready()) {
                String line = this.bufferedReader.readLine();
                if (line.matches("^LOCUS.*")) {
                    if (bioSequence != null) {
                        bioSequence.setSequence(this.stringBuffer.toString());
                    }
                    this.stringBuffer.delete(0, this.stringBuffer.length());
                    bioSequence = new BioSequence();
                    this.add(bioSequence);
                    String[] arguments = line.split("\\s+");
                    String name = arguments[1];
                    bioSequence.setName(name);
                }
                if (!line.matches("^ORIGIN.*")) continue;
                line = this.bufferedReader.readLine();
                while (!line.matches("^//.*")) {
                    Matcher matcher = this.pattern.matcher(line);
                    line = matcher.replaceAll("");
                    this.stringBuffer.append(line);
                    line = this.bufferedReader.readLine();
                }
            }
            if (bioSequence != null) {
                bioSequence.setSequence(this.stringBuffer.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void extractFastaSequences() {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = this.getBufferedReader();
        BioSequence bioSequence = null;
        try {
            while (this.bufferedReader.ready()) {
                String line = this.bufferedReader.readLine();
                if (line.matches("^>.*")) {
                    if (bioSequence != null) {
                        bioSequence.setSequence(this.stringBuffer.toString());
                    }
                    this.stringBuffer.delete(0, this.stringBuffer.length());
                    bioSequence = new BioSequence();
                    this.add(bioSequence);
                    String name = line.indexOf(" ") > 0 ? line.substring(1, line.indexOf(" ")) : line.substring(1, line.length());
                    bioSequence.setName(name);
                    continue;
                }
                this.stringBuffer.append(line);
            }
            if (bioSequence != null) {
                bioSequence.setSequence(this.stringBuffer.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void extractDefaultSequence() {
        this.bioSequence = new BioSequence();
        this.add(this.bioSequence);
        this.bioSequence.setName(this.inputFile);
        try {
            while (this.bufferedReader.ready()) {
                String line = this.bufferedReader.readLine();
                Matcher matcher = this.pattern.matcher(line);
                line = matcher.replaceAll("");
                this.stringBuffer.append(line);
                String string = this.bufferedReader.readLine();
            }
            if (this.bioSequence != null) {
                this.bioSequence.setSequence(this.stringBuffer.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    public BioSequence getBioSequence() {
        BioSequence bioSequence = (BioSequence)this.get(0);
        this.remove(0);
        return bioSequence;
    }
}

