/*
 * Decompiled with CFR 0.152.
 */
package haubold.sequencetools;

import haubold.sequencetools.Alignment;
import haubold.sequencetools.ComplementationMap;
import haubold.sequencetools.translation.NoSuchCodonException;
import haubold.sequencetools.translation.UniversalCodonMap;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SequenceTools {
    UniversalCodonMap codonMap = new UniversalCodonMap();
    static ComplementationMap complementationMap = new ComplementationMap();
    int lineLength = 70;
    float mismatchScore = -3.0f;
    float gapScore = -3.0f;
    float matchScore = 5.0f;
    Random ran = new Random();
    Pattern numbersBlanksPattern = Pattern.compile("[\\s\\d]");
    StringBuffer stringBuffer = new StringBuffer();
    private float[][] dpm;

    public String randomizeSequence(String seq) {
        char[] seqc = seq.toCharArray();
        char[] seqc2 = new char[seqc.length];
        int[] indices = new int[seqc.length];
        int i = 0;
        while (i < indices.length) {
            indices[i] = i;
            ++i;
        }
        i = seqc.length;
        while (i > 0) {
            int r = this.ran.nextInt(i);
            seqc2[i - 1] = seqc[indices[r]];
            indices[r] = indices[i - 1];
            --i;
        }
        return String.copyValueOf(seqc2);
    }

    public String removeNumbersBlanks(String seq) {
        Matcher matcher = this.numbersBlanksPattern.matcher(seq);
        return matcher.replaceAll("");
    }

    public String translate(String nucleotideSequence, int frame) throws NoSuchCodonException {
        nucleotideSequence = nucleotideSequence.toUpperCase();
        int i = frame;
        this.codonMap.setCodonTable(1);
        this.stringBuffer.delete(0, this.stringBuffer.length());
        while (i + 2 < nucleotideSequence.length()) {
            String codon = nucleotideSequence.substring(i, i + 3);
            this.stringBuffer.append(this.codonMap.getAminoAcid(codon));
            i += 3;
        }
        return this.stringBuffer.toString();
    }

    public int orf(String proteinSequence) {
        int i = 0;
        int maxOrf = 0;
        int currentOrf = 0;
        while (i < proteinSequence.length()) {
            if (proteinSequence.substring(i, i + 1).compareTo("*") == 0) {
                if (maxOrf < currentOrf) {
                    maxOrf = currentOrf;
                }
                currentOrf = 0;
            } else {
                ++currentOrf;
            }
            ++i;
        }
        return Math.max(currentOrf, maxOrf);
    }

    public Alignment simpleLocalAlignment(String firstSeq, String secondSeq) {
        float d;
        float v;
        float h;
        int j;
        Alignment alignment = new Alignment();
        float[][] dpm = new float[firstSeq.length() + 1][secondSeq.length() + 1];
        float maxScore = 0.0f;
        float max = 1.0f;
        boolean horizontal = false;
        boolean vertical = false;
        boolean diagonal = false;
        String secondSeqAlign = "";
        String firstSeqAlign = "";
        int i = 0;
        while (i < firstSeq.length() + 1) {
            dpm[i][0] = 0.0f;
            ++i;
        }
        i = 0;
        while (i < secondSeq.length() + 1) {
            dpm[0][i] = 0.0f;
            ++i;
        }
        i = 1;
        while (i < firstSeq.length() + 1) {
            j = 1;
            while (j < secondSeq.length() + 1) {
                h = dpm[i][j - 1] + this.gapScore;
                v = dpm[i - 1][j] + this.gapScore;
                d = firstSeq.substring(i - 1, i).equals(secondSeq.substring(j - 1, j)) ? dpm[i - 1][j - 1] + this.matchScore : dpm[i - 1][j - 1] + this.mismatchScore;
                dpm[i][j] = Math.max(h, Math.max(v, Math.max(d, 0.0f)));
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < firstSeq.length() + 1) {
            j = 1;
            while (j < secondSeq.length() + 1) {
                if (dpm[i][j] > maxScore) {
                    maxScore = dpm[i][j];
                    alignment.setEndFirstSeq(i);
                    alignment.setEndSecondSeq(j);
                }
                ++j;
            }
            ++i;
        }
        alignment.setScore(maxScore);
        i = alignment.getEndFirstSeq();
        j = alignment.getEndSecondSeq();
        alignment.setStartFirstSeq(i);
        alignment.setStartSecondSeq(j);
        max = maxScore;
        while (dpm[i][j] > 0.0f) {
            h = dpm[i][j - 1] + this.gapScore;
            v = dpm[i - 1][j] + this.gapScore;
            d = firstSeq.substring(i - 1, i).equals(secondSeq.substring(j - 1, j)) ? dpm[i - 1][j - 1] + this.matchScore : dpm[i - 1][j - 1] - this.mismatchScore;
            max = Math.max(h, Math.max(v, d));
            if (max == v) {
                alignment.setStartFirstSeq(i);
                firstSeqAlign = String.valueOf(firstSeqAlign) + firstSeq.substring(i - 1, i);
                secondSeqAlign = String.valueOf(secondSeqAlign) + "-";
                --i;
                continue;
            }
            if (max == h) {
                alignment.setStartSecondSeq(j);
                vertical = false;
                horizontal = true;
                diagonal = false;
                firstSeqAlign = String.valueOf(firstSeqAlign) + "-";
                secondSeqAlign = String.valueOf(secondSeqAlign) + secondSeq.substring(j - 1, j);
                --j;
                continue;
            }
            alignment.setStartFirstSeq(i);
            alignment.setStartSecondSeq(j);
            vertical = false;
            horizontal = false;
            diagonal = true;
            firstSeqAlign = String.valueOf(firstSeqAlign) + firstSeq.substring(i - 1, i);
            secondSeqAlign = String.valueOf(secondSeqAlign) + secondSeq.substring(j - 1, j);
            --i;
            --j;
        }
        alignment = this.constructAlignmentText(firstSeqAlign, secondSeqAlign, alignment);
        return alignment;
    }

    public Alignment simpleGlobalAlignment(String firstSeq, String secondSeq) {
        float d;
        float v;
        float h;
        int j;
        Alignment alignment = new Alignment();
        float[][] dpm = new float[firstSeq.length() + 1][secondSeq.length() + 1];
        float maxScore = 0.0f;
        float max = 1.0f;
        boolean horizontal = false;
        boolean vertical = false;
        boolean diagonal = false;
        String secondSeqAlign = "";
        String firstSeqAlign = "";
        dpm[0][0] = 0.0f;
        int i = 1;
        while (i < firstSeq.length() + 1) {
            dpm[i][0] = dpm[i - 1][0] + this.gapScore;
            ++i;
        }
        i = 1;
        while (i < secondSeq.length() + 1) {
            dpm[0][i] = dpm[0][i - 1] + this.gapScore;
            ++i;
        }
        i = 1;
        while (i < firstSeq.length() + 1) {
            j = 1;
            while (j < secondSeq.length() + 1) {
                h = dpm[i][j - 1] + this.gapScore;
                v = dpm[i - 1][j] + this.gapScore;
                d = firstSeq.substring(i - 1, i).equals(secondSeq.substring(j - 1, j)) ? dpm[i - 1][j - 1] + this.matchScore : dpm[i - 1][j - 1] + this.mismatchScore;
                dpm[i][j] = Math.max(h, Math.max(v, d));
                ++j;
            }
            ++i;
        }
        alignment.setScore(dpm[firstSeq.length()][secondSeq.length()]);
        i = firstSeq.length();
        j = secondSeq.length();
        max = maxScore;
        alignment.setStartFirstSeq(1);
        alignment.setStartSecondSeq(1);
        alignment.setEndFirstSeq(firstSeq.length());
        alignment.setEndSecondSeq(secondSeq.length());
        while (i > 0 && j > 0) {
            h = dpm[i][j - 1] + this.gapScore;
            v = dpm[i - 1][j] + this.gapScore;
            d = firstSeq.substring(i - 1, i).equals(secondSeq.substring(j - 1, j)) ? dpm[i - 1][j - 1] + this.matchScore : dpm[i - 1][j - 1] - this.mismatchScore;
            max = Math.max(h, Math.max(v, d));
            if (max == v) {
                vertical = true;
                horizontal = false;
                diagonal = false;
                firstSeqAlign = String.valueOf(firstSeqAlign) + firstSeq.substring(i - 1, i);
                secondSeqAlign = String.valueOf(secondSeqAlign) + "-";
                --i;
                continue;
            }
            if (max == h) {
                vertical = false;
                horizontal = true;
                diagonal = false;
                firstSeqAlign = String.valueOf(firstSeqAlign) + "-";
                secondSeqAlign = String.valueOf(secondSeqAlign) + secondSeq.substring(j - 1, j);
                --j;
                continue;
            }
            vertical = false;
            horizontal = false;
            diagonal = true;
            firstSeqAlign = String.valueOf(firstSeqAlign) + firstSeq.substring(i - 1, i);
            secondSeqAlign = String.valueOf(secondSeqAlign) + secondSeq.substring(j - 1, j);
            --i;
            --j;
        }
        if (i > 0) {
            int overhang;
            i = overhang = firstSeq.substring(0, i).length();
            while (i > 0) {
                firstSeqAlign = String.valueOf(firstSeqAlign) + firstSeq.substring(i - 1, i);
                secondSeqAlign = String.valueOf(secondSeqAlign) + "-";
                --i;
            }
        } else if (j > 0) {
            int overhang = firstSeq.substring(0, j).length();
            secondSeqAlign = String.valueOf(secondSeqAlign) + secondSeq.substring(0, j);
            i = overhang;
            while (i > 0) {
                secondSeqAlign = String.valueOf(secondSeqAlign) + secondSeq.substring(i - 1, i);
                firstSeqAlign = String.valueOf(firstSeqAlign) + "-";
                --i;
            }
        }
        alignment = this.constructAlignmentText(firstSeqAlign, secondSeqAlign, alignment);
        return alignment;
    }

    private Alignment constructAlignmentText(String firstSeqAlign, String secondSeqAlign, Alignment alignment) {
        int i;
        secondSeqAlign = SequenceTools.reverse(secondSeqAlign);
        firstSeqAlign = SequenceTools.reverse(firstSeqAlign);
        String alignmentString = new String();
        int currentsecondSeqPos = alignment.getStartSecondSeq();
        int currentfirstSeqPos = alignment.getStartFirstSeq();
        int index = 0;
        String firstPrefix = "";
        String secondPrefix = "";
        while (index + this.lineLength < secondSeqAlign.length()) {
            currentsecondSeqPos += this.lineLength;
            firstPrefix = "First Sequence:  \t";
            secondPrefix = "\nSecond Sequence: \t";
            alignmentString = String.valueOf(alignmentString) + firstPrefix + firstSeqAlign.substring(index, index + this.lineLength) + " " + String.valueOf((currentfirstSeqPos += this.lineLength) - 1) + "\n";
            i = 0;
            while (i < firstPrefix.length() - 1) {
                alignmentString = String.valueOf(alignmentString) + " ";
                ++i;
            }
            alignmentString = String.valueOf(alignmentString) + "\t";
            i = index;
            while (i < index + this.lineLength) {
                alignmentString = firstSeqAlign.substring(i, i + 1).equals(secondSeqAlign.substring(i, i + 1)) ? String.valueOf(alignmentString) + ":" : String.valueOf(alignmentString) + " ";
                ++i;
            }
            alignmentString = String.valueOf(alignmentString) + secondPrefix + secondSeqAlign.substring(index, index + this.lineLength) + " " + (currentsecondSeqPos - 1) + "\n\n";
            index += this.lineLength;
        }
        firstPrefix = "First Sequence:  \t";
        secondPrefix = "\nSecond Sequence: \t";
        alignmentString = String.valueOf(alignmentString) + firstPrefix + firstSeqAlign.substring(index) + " " + String.valueOf(alignment.getStartFirstSeq() + secondSeqAlign.length() - 1) + "\n";
        i = 0;
        while (i < firstPrefix.length() - 1) {
            alignmentString = String.valueOf(alignmentString) + " ";
            ++i;
        }
        alignmentString = String.valueOf(alignmentString) + "\t";
        i = index;
        while (i < secondSeqAlign.length()) {
            alignmentString = firstSeqAlign.substring(i, i + 1).equals(secondSeqAlign.substring(i, i + 1)) ? String.valueOf(alignmentString) + ":" : String.valueOf(alignmentString) + " ";
            ++i;
        }
        alignmentString = String.valueOf(alignmentString) + secondPrefix + secondSeqAlign.substring(index) + " " + (alignment.getStartSecondSeq() + firstSeqAlign.length() - 1) + "\n";
        alignment.setText(alignmentString);
        return alignment;
    }

    public static String reverse(String inputSequence) {
        char[] reverseChar = new char[inputSequence.length()];
        char[] inChar = inputSequence.toCharArray();
        String reverseSequence = new String();
        int j = 0;
        int i = inputSequence.length() - 1;
        while (i >= 0) {
            reverseChar[j++] = inChar[i];
            --i;
        }
        reverseSequence = String.copyValueOf(reverseChar);
        return reverseSequence;
    }

    public static String complement(String inputSequence) {
        char[] inChar = inputSequence.toCharArray();
        StringBuffer complementB = new StringBuffer();
        int i = 0;
        while (i < inputSequence.length()) {
            complementB.append(complementationMap.get(String.valueOf(inChar[i])));
            ++i;
        }
        return complementB.toString();
    }

    public static String reverseComplement(String inputSequence) {
        String seq = SequenceTools.complement(SequenceTools.reverse(inputSequence));
        return seq;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public float getMismatchScore() {
        return this.mismatchScore;
    }

    public void setMismatchScore(float mismatchScore) {
        this.mismatchScore = mismatchScore;
    }

    public float getGapScore() {
        return this.gapScore;
    }

    public void setGapScore(float gapScore) {
        this.gapScore = gapScore;
    }

    public float getMatchScore() {
        return this.matchScore;
    }

    public void setMatchScore(float matchScore) {
        this.matchScore = matchScore;
    }

    public float[][] getDpm() {
        return this.dpm;
    }

    public void setDpm(float[][] dpm) {
        this.dpm = dpm;
    }
}

