/*
 * Decompiled with CFR 0.152.
 */
package haubold.coalescent;

import haubold.coalescent.HaplotypePanel;
import haubold.coalescent.MutationObject;
import haubold.coalescent.Tree;
import haubold.coalescent.TreePanel;
import haubold.resources.demo.DemoFrame;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.Icons;
import haubold.resources.util.PrintableSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CoalescentDemo
extends DemoFrame {
    JPanel controlP;
    TreePanel treeP;
    HaplotypePanel haplotypeP;
    JButton stepB;
    JButton resetB;
    JButton animateB;
    JLabel sampleSizeL;
    JLabel thetaL;
    JSlider sampleSizeS;
    JSlider thetaS;
    JSlider stepSlider;
    SliderListener mySlideListener = new SliderListener();
    JTextField sampleSizeF;
    JTextField thetaF;
    PrintableSplitPane splitPane;
    JToolBar toolBar;
    BirkhaeuserGUIComponents bgc;
    int step = 0;
    int thetaMax = 500;
    int[] leafId;
    String[] stepBstr = new String[]{"Step 1", "Step 2", "Step 3"};
    String[] stepLstr = new String[]{"Generate genealogy", "Generate mutations", "Generate sample"};
    double[][] treeCoords;
    Tree tree;
    MutationObject mo = new MutationObject();
    double theta;
    boolean animate = false;
    private double dividerLocation;

    public CoalescentDemo(String title, String helpPath) {
        this.setTitle(title);
        this.setHelpPath(helpPath);
        this.tree = new Tree();
        this.treeP = new TreePanel();
        this.haplotypeP = new HaplotypePanel();
        this.stepB = new JButton(Icons.get2rightArrow());
        this.stepB.setToolTipText("Step1:generate genealogy");
        this.resetB = new JButton(Icons.getUndo());
        this.resetB.setToolTipText("Reset");
        this.stepB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CoalescentDemo.this.stepAction(e);
            }
        });
        this.resetB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CoalescentDemo.this.resetAction(e);
            }
        });
        this.animateB = new JButton(Icons.getRun());
        this.animateB.setToolTipText("Animate Display");
        this.animateB.addActionListener(new AnimateActionListener());
        this.bgc = new BirkhaeuserGUIComponents();
        this.sampleSizeS = this.bgc.getSlider(2, 50, 10, "Sample Size");
        this.sampleSizeS.addChangeListener(this.mySlideListener);
        this.thetaS = this.bgc.getSlider(0, this.thetaMax, 20, "theta");
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        int i = 0;
        while (i <= this.thetaMax) {
            hashtable.put(new Integer(i), new JLabel(String.valueOf(i / 10)));
            i += 100;
        }
        this.thetaS.setLabelTable(hashtable);
        this.thetaS.addChangeListener(this.mySlideListener);
        this.thetaL = new JLabel(String.valueOf((double)this.thetaS.getValue() / 10.0));
        Dimension dimension = new Dimension(30, 50);
        this.thetaL.setMinimumSize(dimension);
        this.thetaL.setMaximumSize(dimension);
        this.thetaL.setPreferredSize(dimension);
        this.thetaL.setHorizontalAlignment(4);
        this.sampleSizeL = new JLabel(String.valueOf(this.sampleSizeS.getValue()));
        dimension = new Dimension(20, 20);
        this.sampleSizeL.setMinimumSize(dimension);
        this.sampleSizeL.setMaximumSize(dimension);
        this.sampleSizeL.setPreferredSize(dimension);
        this.sampleSizeL.setHorizontalAlignment(4);
        this.stepSlider = this.bgc.getSlider(1, 10, 4, "Step Time");
        this.stepSlider.setEnabled(false);
        this.stepSlider.setSnapToTicks(true);
        this.toolBar = new JToolBar();
        this.toolBar.add(this.stepB);
        this.toolBar.add(this.animateB);
        this.toolBar.add(this.resetB);
        this.toolBar.add(this.stepSlider);
        this.toolBar.add(this.sampleSizeS);
        this.toolBar.add(this.sampleSizeL);
        this.toolBar.add(this.thetaS);
        this.toolBar.add(this.thetaL);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.splitPane = new PrintableSplitPane(0, true);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.add(this.treeP);
        this.splitPane.add(this.haplotypeP);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.splitPane.setDividerLocation(200);
        this.getFileMenu().getPrintMenuItem().setPrintable(this.splitPane);
    }

    private void step0() {
        int sampleSize = this.sampleSizeS.getValue();
        this.tree.makeTree(sampleSize);
        this.leafId = this.tree.getLeafId();
        this.treeCoords = this.tree.getTreeCoordinates();
        this.treeP.setMutations(false);
        this.treeP.drawTree(this.treeCoords, this.leafId);
        this.haplotypeP.setDrawing(false);
        this.haplotypeP.repaint();
    }

    private void step1() {
        this.theta = (double)this.thetaS.getValue() / 10.0;
        this.tree.mutate(this.theta);
        this.mo = this.tree.getMutationCoordinates();
        if ((double)this.mo.mutCoord.length > 0.0) {
            this.treeP.drawMutations(this.mo.mutCoord);
        }
    }

    private void step2() {
        this.haplotypeP.drawHaplotypes(this.mo.haplotypes);
    }

    private void step3() {
        this.treeP.setTree(false);
        this.treeP.setMutations(false);
        this.treeP.repaint();
        this.haplotypeP.setDrawing(false);
        this.haplotypeP.repaint();
    }

    private void stepAction(ActionEvent e) {
        if (this.step == 0) {
            this.step0();
            this.stepB.setToolTipText("Step2: generate mutations");
            ++this.step;
        } else if (this.step == 1) {
            this.step1();
            this.stepB.setToolTipText("Step3: generate haplotypes");
            ++this.step;
        } else if (this.step == 2) {
            this.step2();
            this.stepB.setToolTipText("Step1: generate genealogy");
            this.step = 0;
        }
    }

    private void resetAction(ActionEvent e) {
        this.treeCoords = null;
        this.stepB.setToolTipText("Step1: generate genealogy");
        this.sampleSizeS.setValue(10);
        this.thetaS.setValue(20);
        this.step3();
        this.step = 0;
    }

    public double getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(double dividerLocation) {
        this.dividerLocation = dividerLocation;
        this.splitPane.setDividerLocation(dividerLocation);
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent e) {
            CoalescentDemo.this.sampleSizeL.setText(String.valueOf(CoalescentDemo.this.sampleSizeS.getValue()));
            CoalescentDemo.this.thetaL.setText(String.valueOf((double)CoalescentDemo.this.thetaS.getValue() / 10.0));
        }
    }

    class AnimateActionListener
    implements ActionListener {
        Animation animation;

        AnimateActionListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            if (!CoalescentDemo.this.animate) {
                this.animation = new Animation();
                CoalescentDemo.this.animate = true;
                this.animation.start();
                CoalescentDemo.this.animateB.setIcon(Icons.getStop());
                CoalescentDemo.this.animateB.setToolTipText("Stop");
                CoalescentDemo.this.stepB.setEnabled(false);
                CoalescentDemo.this.resetB.setEnabled(false);
                CoalescentDemo.this.stepSlider.setEnabled(true);
            } else {
                CoalescentDemo.this.animate = false;
                CoalescentDemo.this.animateB.setIcon(Icons.getRun());
                CoalescentDemo.this.animateB.setToolTipText("Animate Display");
                CoalescentDemo.this.stepB.setEnabled(true);
                CoalescentDemo.this.resetB.setEnabled(true);
                CoalescentDemo.this.step3();
                CoalescentDemo.this.stepB.setToolTipText("Step1:generate genealogy");
                CoalescentDemo.this.step = 0;
                CoalescentDemo.this.stepSlider.setEnabled(false);
            }
        }
    }

    class Animation
    extends Thread {
        long sleepTime = 200L;

        Animation() {
        }

        public void run() {
            while (CoalescentDemo.this.animate) {
                this.sleepTime = CoalescentDemo.this.stepSlider.getValue() * 50;
                CoalescentDemo.this.step0();
                if (!CoalescentDemo.this.animate) break;
                try {
                    Animation.sleep(this.sleepTime);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (!CoalescentDemo.this.animate) break;
                CoalescentDemo.this.step1();
                if (!CoalescentDemo.this.animate) break;
                try {
                    Animation.sleep(this.sleepTime);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (!CoalescentDemo.this.animate) break;
                CoalescentDemo.this.step2();
                if (!CoalescentDemo.this.animate) break;
                try {
                    Animation.sleep(this.sleepTime);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

