/*
 * Decompiled with CFR 0.152.
 */
package haubold.coalescent;

import java.util.Random;

class NumericalTools {
    static Random ran = new Random();
    static double oldm = -1.0;
    static double alxm = 0.0;
    static double g = 0.0;
    static double sq = 0.0;

    NumericalTools() {
    }

    public static double nextPoisson(double xm) {
        double em = 0.0;
        double t = 0.0;
        double y = 0.0;
        if (xm < 12.0) {
            if (xm != oldm) {
                oldm = xm;
                g = Math.exp(-xm);
            }
            em = -1.0;
            t = 1.0;
            do {
                em += 1.0;
            } while ((t *= ran.nextDouble()) > g);
        } else {
            if (xm != oldm) {
                oldm = xm;
                sq = Math.sqrt(2.0 * xm);
                alxm = Math.log(xm);
                g = xm * alxm - NumericalTools.logGamma(xm + 1.0);
            }
            while (true) {
                if ((em = sq * (y = Math.tan(Math.PI * ran.nextDouble())) + xm) < 0.0) {
                    continue;
                }
                em = Math.floor(em);
                t = 0.9 * (1.0 + y * y) * Math.exp(em * alxm - NumericalTools.logGamma(em + 1.0) - g);
                if (!(ran.nextDouble() > t)) break;
            }
        }
        return em;
    }

    public static double logGamma(double xx) {
        double x;
        double stp = 2.5066282746310007;
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double y = x = xx;
        double tmp = x + 5.5;
        tmp = (x + 0.5) * Math.log(tmp) - tmp;
        double ser = 1.000000000190015;
        int j = 0;
        while (j < cof.length) {
            ser += cof[j] / (y += 1.0);
            ++j;
        }
        double gammln = tmp + Math.log(2.5066282746310007 * ser / x);
        return gammln;
    }
}

