/*
 * Decompiled with CFR 0.152.
 */
package haubold.dp;

import haubold.dp.DpmCell;
import haubold.resources.util.Arrow;
import haubold.resources.util.BirkhaeuserGUIComponents;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class DynamicProgramming
extends JPanel {
    public double numCooptimal;
    public double optimalScore;
    public int SETUP_MATRIX = 0;
    public int INITIALIZE_MATRIX = 1;
    public int FILL_MATRIX = 2;
    public int TRACE_BACK = 3;
    public int CLEAR_MATRIX = 4;
    private int alignmentMode;
    private Arrow arrow;
    private double scaleX;
    private double scaleY;
    private double dpm;
    private boolean traceBack;
    String sequence1;
    String sequence2;
    HashMap substitutionMap;
    double gapOpening;
    double gapExtension;
    boolean gapOpen = false;
    int gapLength;
    JScrollPane scrollPane;
    DpmCell[][] dpmMatrix;
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    double matchScore;
    double mismatchScore;

    DynamicProgramming() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.arrow = new Arrow();
        this.arrow.setArrowSize(5.0f);
    }

    public DynamicProgramming(String sequence1, String sequence2) {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.arrow = new Arrow();
        this.arrow.setArrowSize(5.0f);
    }

    public void setSequences(String seq1, String seq2) {
        this.sequence1 = seq1;
        this.sequence2 = seq2;
        int m = this.sequence2.length();
        int n = this.sequence1.length();
        Object[] headers = new Object[n + 2];
        Object[][] rows = new Object[m + 2][n + 2];
        headers[0] = "";
        rows[0][0] = "";
        headers[1] = "";
        rows[0][1] = "-";
        rows[1][0] = "-";
        int j = 0;
        while (j < n) {
            headers[j + 2] = "";
            rows[0][j + 2] = this.sequence1.substring(j, j + 1);
            ++j;
        }
        j = 0;
        while (j < m) {
            rows[j + 2][0] = this.sequence2.substring(j, j + 1);
            ++j;
        }
        m = this.sequence2.length();
        n = this.sequence1.length();
        this.dpmMatrix = new DpmCell[m + 1][n + 1];
        int i = 0;
        while (i < m + 1) {
            j = 0;
            while (j < n + 1) {
                this.dpmMatrix[i][j] = new DpmCell(i, j);
                ++j;
            }
            ++i;
        }
    }

    public void setParameters(HashMap sMap, double gapOp, double gapExt) {
        this.substitutionMap = new HashMap();
        this.substitutionMap = sMap;
        this.gapOpening = gapOp;
        this.gapExtension = gapExt;
    }

    void numberOfCooptimalAlignments(int startRow, int startColumn, int endRow, int endColumn) {
        int i = 0;
        int j = 0;
        this.dpmMatrix[startRow][startColumn].numCooptimal = 1.0;
        i = startRow - 1;
        while (i >= endRow) {
            this.dpmMatrix[i][startColumn].numCooptimal = 0.0;
            this.dpmMatrix[i][startColumn].numCooptimal = this.dpmMatrix[i + 1][startColumn].backVertical ? (this.dpmMatrix[i][startColumn].numCooptimal += this.dpmMatrix[i + 1][startColumn].numCooptimal) : 0.0;
            --i;
        }
        i = startColumn - 1;
        while (i >= endColumn) {
            this.dpmMatrix[startRow][i].numCooptimal = 0.0;
            this.dpmMatrix[startRow][i].numCooptimal = this.dpmMatrix[startRow][i + 1].backHorizontal ? (this.dpmMatrix[startRow][i].numCooptimal += this.dpmMatrix[startRow][i + 1].numCooptimal) : 0.0;
            --i;
        }
        i = startRow - 1;
        while (i >= endRow) {
            j = startColumn - 1;
            while (j >= endColumn) {
                this.dpmMatrix[i][j].numCooptimal = 0.0;
                if (this.dpmMatrix[i + 1][j].backVertical) {
                    this.dpmMatrix[i][j].numCooptimal += this.dpmMatrix[i + 1][j].numCooptimal;
                }
                if (this.dpmMatrix[i + 1][j + 1].backDiagonal) {
                    int a = i + 1;
                    int b = j + 1;
                    this.dpmMatrix[i][j].numCooptimal += this.dpmMatrix[i + 1][j + 1].numCooptimal;
                }
                if (this.dpmMatrix[i][j + 1].backHorizontal) {
                    this.dpmMatrix[i][j].numCooptimal += this.dpmMatrix[i][j + 1].numCooptimal;
                }
                --j;
            }
            --i;
        }
        this.numCooptimal = this.dpmMatrix[i + 1][j + 1].numCooptimal;
    }

    public void initializeGlobalAlignment() {
        int m = this.sequence2.length();
        int n = this.sequence1.length();
        this.dpmMatrix[0][0].score = 0.0;
        int i = 1;
        while (i <= n) {
            this.dpmMatrix[0][i].vertical = this.dpmMatrix[0][i].score = this.dpmMatrix[0][i - 1].score + this.gapExtension;
            this.dpmMatrix[0][i].backHorizontal = true;
            ++i;
        }
        i = 1;
        while (i <= m) {
            this.dpmMatrix[i][0].horizontal = this.dpmMatrix[i][0].score = this.dpmMatrix[i - 1][0].score + this.gapExtension;
            this.dpmMatrix[i][0].backVertical = true;
            ++i;
        }
    }

    public void fillGlobalAlignment() {
        int n = this.sequence1.length();
        int m = this.sequence2.length();
        int i = 1;
        while (i <= m) {
            int j = 1;
            while (j <= n) {
                double d = this.sequence2.substring(i - 1, i).equals(this.sequence1.substring(j - 1, j)) ? this.dpmMatrix[i - 1][j - 1].score + this.matchScore : this.dpmMatrix[i - 1][j - 1].score + this.mismatchScore;
                double h = Math.max(this.dpmMatrix[i][j - 1].horizontal, this.dpmMatrix[i][j - 1].score + this.gapOpening) + this.gapExtension;
                double v = Math.max(this.dpmMatrix[i - 1][j].vertical, this.dpmMatrix[i - 1][j].score + this.gapOpening) + this.gapExtension;
                this.dpmMatrix[i][j].score = Math.max(Math.max(h, d), v);
                this.dpmMatrix[i][j].vertical = v;
                this.dpmMatrix[i][j].horizontal = h;
                String result = String.valueOf(this.dpmMatrix[i][j].score);
                result.trim();
                if (v == this.dpmMatrix[i][j].score) {
                    this.dpmMatrix[i][j].backVertical = true;
                    result = "| " + result;
                } else {
                    result = "  " + result;
                }
                if (h == this.dpmMatrix[i][j].score) {
                    this.dpmMatrix[i][j].backHorizontal = true;
                    result = "-" + result;
                } else {
                    result = " " + result;
                }
                if (d == this.dpmMatrix[i][j].score) {
                    this.dpmMatrix[i][j].backDiagonal = true;
                    result = "\\" + result;
                } else {
                    result = "  " + result;
                }
                ++j;
            }
            ++i;
        }
    }

    public String[] traceBackGlobalAlignment() {
        String[] alignment = new String[]{new String(), new String(), new String()};
        int j = this.sequence1.length();
        int i = this.sequence2.length();
        this.dpmMatrix[i][j].optimal = true;
        this.optimalScore = this.dpmMatrix[i][j].score;
        int startColumn = j;
        int startRow = i;
        while (i > 0 || j > 0) {
            if (this.dpmMatrix[i][j].backDiagonal) {
                this.dpmMatrix[i - 1][j - 1].optimal = true;
                alignment[0] = String.valueOf(alignment[0]) + this.sequence1.substring(j - 1, j);
                alignment[2] = String.valueOf(alignment[2]) + this.sequence2.substring(i - 1, i);
                alignment[1] = this.sequence1.substring(j - 1, j).equals(this.sequence2.substring(i - 1, i)) ? String.valueOf(alignment[1]) + ":" : String.valueOf(alignment[1]) + " ";
                --i;
                --j;
                continue;
            }
            if (this.dpmMatrix[i][j].backHorizontal) {
                this.dpmMatrix[i][j - 1].optimal = true;
                alignment[0] = String.valueOf(alignment[0]) + this.sequence1.substring(j - 1, j);
                alignment[2] = String.valueOf(alignment[2]) + "-";
                alignment[1] = String.valueOf(alignment[1]) + " ";
                --j;
                continue;
            }
            if (this.dpmMatrix[i][j].backVertical) {
                this.dpmMatrix[i - 1][j].optimal = true;
                alignment[0] = String.valueOf(alignment[0]) + "-";
                alignment[2] = String.valueOf(alignment[2]) + this.sequence2.substring(i - 1, i);
                alignment[1] = String.valueOf(alignment[1]) + " ";
                --i;
                continue;
            }
            System.out.println("Error in reconstruction of Alignment");
        }
        int endColumn = j;
        int endRow = i;
        this.numberOfCooptimalAlignments(startRow, startColumn, endRow, endColumn);
        this.numCooptimal = this.dpmMatrix[endRow][endColumn].numCooptimal;
        StringBuffer str1 = new StringBuffer(alignment[0]);
        StringBuffer str2 = new StringBuffer(alignment[1]);
        StringBuffer str3 = new StringBuffer(alignment[2]);
        alignment[0] = str1.reverse().toString();
        alignment[1] = str2.reverse().toString();
        alignment[2] = str3.reverse().toString();
        return alignment;
    }

    public void initializeOverlapAlignment() {
        int m = this.sequence2.length();
        int n = this.sequence1.length();
        this.dpmMatrix[0][0].score = 0.0;
        int i = 1;
        while (i <= n) {
            this.dpmMatrix[0][i].vertical = this.dpmMatrix[0][i].score = 0.0;
            this.dpmMatrix[0][i].backHorizontal = true;
            ++i;
        }
        i = 1;
        while (i <= m) {
            this.dpmMatrix[i][0].horizontal = this.dpmMatrix[i][0].score = 0.0;
            this.dpmMatrix[i][0].backVertical = true;
            ++i;
        }
    }

    public void fillOverlapAlignment() {
        int n = this.sequence1.length();
        int m = this.sequence2.length();
        int i = 1;
        while (i <= m) {
            int j = 1;
            while (j <= n) {
                double d = this.sequence2.substring(i - 1, i).equals(this.sequence1.substring(j - 1, j)) ? this.dpmMatrix[i - 1][j - 1].score + this.matchScore : this.dpmMatrix[i - 1][j - 1].score + this.mismatchScore;
                double h = Math.max(this.dpmMatrix[i][j - 1].horizontal, this.dpmMatrix[i][j - 1].score + this.gapOpening) + this.gapExtension;
                double v = Math.max(this.dpmMatrix[i - 1][j].vertical, this.dpmMatrix[i - 1][j].score + this.gapOpening) + this.gapExtension;
                this.dpmMatrix[i][j].score = Math.max(Math.max(h, d), v);
                this.dpmMatrix[i][j].vertical = v;
                this.dpmMatrix[i][j].horizontal = h;
                String result = String.valueOf(this.dpmMatrix[i][j].score);
                result.trim();
                if (v == this.dpmMatrix[i][j].score) {
                    this.dpmMatrix[i][j].backVertical = true;
                    result = "| " + result;
                } else {
                    result = "  " + result;
                }
                if (h == this.dpmMatrix[i][j].score) {
                    this.dpmMatrix[i][j].backHorizontal = true;
                    result = "-" + result;
                } else {
                    result = " " + result;
                }
                if (d == this.dpmMatrix[i][j].score) {
                    this.dpmMatrix[i][j].backDiagonal = true;
                    result = "\\" + result;
                } else {
                    result = "  " + result;
                }
                ++j;
            }
            ++i;
        }
    }

    int[] findMaxOverlap() {
        int n = this.sequence1.length();
        int m = this.sequence2.length();
        int[] coordinates = new int[2];
        double maxScore = this.dpmMatrix[m][0].score;
        int row = m;
        int column = 0;
        int i = 1;
        while (i <= n) {
            if (this.dpmMatrix[m][i].score > maxScore) {
                maxScore = this.dpmMatrix[m][i].score;
                column = i;
            }
            ++i;
        }
        i = 0;
        while (i <= m) {
            if (this.dpmMatrix[i][n].score > maxScore) {
                maxScore = this.dpmMatrix[i][n].score;
                column = n;
                row = i;
            }
            ++i;
        }
        coordinates[0] = row;
        coordinates[1] = column;
        return coordinates;
    }

    public String[] traceBackOverlapAlignment() {
        int i;
        int column;
        String[] alignment = new String[]{new String(), new String(), new String()};
        int[] coordinates = this.findMaxOverlap();
        int row = coordinates[0];
        int startColumn = column = coordinates[1];
        int startRow = row;
        this.optimalScore = this.dpmMatrix[row][column].score;
        if (column < this.dpmMatrix[0].length) {
            i = this.sequence1.length() - 1;
            while (i >= column) {
                alignment[0] = String.valueOf(alignment[0]) + this.sequence1.substring(i, i + 1);
                alignment[2] = String.valueOf(alignment[2]) + "-";
                --i;
            }
        }
        if (row < this.dpmMatrix.length) {
            i = this.sequence2.length() - 1;
            while (i >= row) {
                alignment[2] = String.valueOf(alignment[2]) + this.sequence2.substring(i, i + 1);
                alignment[0] = String.valueOf(alignment[0]) + "-";
                --i;
            }
        }
        i = row;
        int j = column;
        this.dpmMatrix[i][j].optimal = true;
        while (i > 0 || j > 0) {
            if (this.dpmMatrix[i][j].backDiagonal) {
                this.dpmMatrix[i - 1][j - 1].optimal = true;
                alignment[0] = String.valueOf(alignment[0]) + this.sequence1.substring(j - 1, j);
                alignment[2] = String.valueOf(alignment[2]) + this.sequence2.substring(i - 1, i);
                alignment[1] = this.sequence1.substring(j - 1, j).equals(this.sequence2.substring(i - 1, i)) ? String.valueOf(alignment[1]) + ":" : String.valueOf(alignment[1]) + " ";
                --i;
                --j;
                continue;
            }
            if (this.dpmMatrix[i][j].backHorizontal) {
                this.dpmMatrix[i][j - 1].optimal = true;
                alignment[0] = String.valueOf(alignment[0]) + this.sequence1.substring(j - 1, j);
                alignment[2] = String.valueOf(alignment[2]) + "-";
                alignment[1] = String.valueOf(alignment[1]) + " ";
                --j;
                continue;
            }
            if (this.dpmMatrix[i][j].backVertical) {
                this.dpmMatrix[i - 1][j].optimal = true;
                alignment[0] = String.valueOf(alignment[0]) + "-";
                alignment[2] = String.valueOf(alignment[2]) + this.sequence2.substring(i - 1, i);
                alignment[1] = String.valueOf(alignment[1]) + " ";
                --i;
                continue;
            }
            System.out.println("Error in reconstruction of Alignment");
        }
        int endColumn = j;
        int endRow = i;
        this.numberOfCooptimalAlignments(startRow, startColumn, endRow, endColumn);
        this.numCooptimal = this.dpmMatrix[endRow][endColumn].numCooptimal;
        StringBuffer str1 = new StringBuffer(alignment[0]);
        StringBuffer str2 = new StringBuffer(alignment[1]);
        StringBuffer str3 = new StringBuffer(alignment[2]);
        alignment[0] = str1.reverse().toString();
        alignment[1] = str2.reverse().toString();
        alignment[2] = str3.reverse().toString();
        return alignment;
    }

    public void initializeLocalAlignment() {
        int m = this.sequence2.length();
        int n = this.sequence1.length();
        this.dpmMatrix[0][0].score = 0.0;
        int i = 1;
        while (i <= n) {
            this.dpmMatrix[0][i].vertical = this.dpmMatrix[0][i].score = 0.0;
            this.dpmMatrix[0][i].backHorizontal = false;
            ++i;
        }
        i = 1;
        while (i <= m) {
            this.dpmMatrix[i][0].horizontal = this.dpmMatrix[i][0].score = 0.0;
            this.dpmMatrix[i][0].backVertical = false;
            ++i;
        }
    }

    public void fillLocalAlignment() {
        int n = this.sequence1.length();
        int m = this.sequence2.length();
        int i = 1;
        while (i <= m) {
            int j = 1;
            while (j <= n) {
                double d = this.sequence2.substring(i - 1, i).equals(this.sequence1.substring(j - 1, j)) ? this.dpmMatrix[i - 1][j - 1].score + this.matchScore : this.dpmMatrix[i - 1][j - 1].score + this.mismatchScore;
                double h = Math.max(this.dpmMatrix[i][j - 1].horizontal, this.dpmMatrix[i][j - 1].score + this.gapOpening) + this.gapExtension;
                double v = Math.max(this.dpmMatrix[i - 1][j].vertical, this.dpmMatrix[i - 1][j].score + this.gapOpening) + this.gapExtension;
                this.dpmMatrix[i][j].score = Math.max(Math.max(Math.max(h, d), v), 0.0);
                this.dpmMatrix[i][j].vertical = v;
                this.dpmMatrix[i][j].horizontal = h;
                String result = String.valueOf(this.dpmMatrix[i][j].score);
                result.trim();
                if (v == this.dpmMatrix[i][j].score && v != 0.0) {
                    this.dpmMatrix[i][j].backVertical = true;
                    result = "| " + result;
                } else {
                    result = "  " + result;
                }
                if (h == this.dpmMatrix[i][j].score && h != 0.0) {
                    this.dpmMatrix[i][j].backHorizontal = true;
                    result = "-" + result;
                } else {
                    result = " " + result;
                }
                if (d == this.dpmMatrix[i][j].score && d != 0.0) {
                    this.dpmMatrix[i][j].backDiagonal = true;
                    result = "\\" + result;
                } else {
                    result = "  " + result;
                }
                ++j;
            }
            ++i;
        }
    }

    int[] findMaxLocal() {
        int n = this.sequence1.length();
        int m = this.sequence2.length();
        int[] coordinates = new int[2];
        double maxScore = this.dpmMatrix[0][0].score;
        int row = 0;
        int column = 0;
        int i = 0;
        while (i <= m) {
            int j = 0;
            while (j <= n) {
                if (this.dpmMatrix[i][j].score > maxScore) {
                    maxScore = this.dpmMatrix[i][j].score;
                    column = j;
                    row = i;
                }
                ++j;
            }
            ++i;
        }
        coordinates[0] = row;
        coordinates[1] = column;
        return coordinates;
    }

    public String[] traceBackLocalAlignment() {
        int j;
        String[] alignment = new String[]{new String(), new String(), new String()};
        int[] coordinates = this.findMaxLocal();
        int i = coordinates[0];
        int startColumn = j = coordinates[1];
        int startRow = i;
        this.optimalScore = this.dpmMatrix[i][j].score;
        this.dpmMatrix[i][j].optimal = true;
        while (this.dpmMatrix[i][j].score > 0.0) {
            if (this.dpmMatrix[i][j].backDiagonal) {
                this.dpmMatrix[i - 1][j - 1].optimal = true;
                alignment[0] = String.valueOf(alignment[0]) + this.sequence1.substring(j - 1, j);
                alignment[2] = String.valueOf(alignment[2]) + this.sequence2.substring(i - 1, i);
                alignment[1] = this.sequence1.substring(j - 1, j).equals(this.sequence2.substring(i - 1, i)) ? String.valueOf(alignment[1]) + ":" : String.valueOf(alignment[1]) + " ";
                --i;
                --j;
                continue;
            }
            if (this.dpmMatrix[i][j].backHorizontal) {
                this.dpmMatrix[i][j - 1].optimal = true;
                alignment[0] = String.valueOf(alignment[0]) + this.sequence1.substring(j - 1, j);
                alignment[2] = String.valueOf(alignment[2]) + "-";
                alignment[1] = String.valueOf(alignment[1]) + " ";
                --j;
                continue;
            }
            if (this.dpmMatrix[i][j].backVertical) {
                this.dpmMatrix[i - 1][j].optimal = true;
                alignment[0] = String.valueOf(alignment[0]) + "-";
                alignment[2] = String.valueOf(alignment[2]) + this.sequence2.substring(i - 1, i);
                alignment[1] = String.valueOf(alignment[1]) + " ";
                --i;
                continue;
            }
            System.out.println("Error in reconstruction of Alignment");
        }
        int endRow = i;
        int endColumn = j;
        this.numberOfCooptimalAlignments(startRow, startColumn, endRow, endColumn);
        this.numCooptimal = this.dpmMatrix[endRow][endColumn].numCooptimal;
        StringBuffer str1 = new StringBuffer(alignment[0]);
        StringBuffer str2 = new StringBuffer(alignment[1]);
        StringBuffer str3 = new StringBuffer(alignment[2]);
        alignment[0] = str1.reverse().toString();
        alignment[1] = str2.reverse().toString();
        alignment[2] = str3.reverse().toString();
        return alignment;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        DecimalFormat myFormat = new DecimalFormat("##.##");
        Dimension dim = this.getSize();
        int w = (int)dim.getWidth();
        int h = (int)dim.getHeight();
        g2.setColor(this.bgc.getColor1());
        g2.fillRect(0, 0, w, h);
        int maxLen = 0;
        int i = 0;
        while (i < this.dpmMatrix.length) {
            int j = 0;
            while (j < this.dpmMatrix[i].length) {
                if (String.valueOf((int)this.dpmMatrix[i][j].score).length() > maxLen) {
                    maxLen = String.valueOf((int)this.dpmMatrix[i][j].score).length();
                }
                ++j;
            }
            ++i;
        }
        int stepX = (int)Math.max((double)maxLen * 14.0, 26.0);
        int stepY = 24;
        this.scaleX = (double)this.getWidth() / (double)(this.sequence1.length() + 3) / (double)stepX;
        this.scaleY = (double)this.getHeight() / (double)(this.sequence2.length() + 4) / (double)stepY;
        double scale = Math.min(this.scaleX, this.scaleY);
        int tx = (int)(((double)this.getWidth() - (double)(this.sequence1.length() + 3) * (double)stepX * scale) / 2.0);
        int ty = (int)(((double)this.getHeight() - (double)(this.sequence2.length() + 3) * (double)stepY * scale) / 2.0);
        AffineTransform transform = g2.getTransform();
        g2.translate(tx, ty);
        g2.scale(scale, scale);
        String str = new String();
        Font courier = new Font("courier", 1, 10);
        Font times = new Font("times", 0, 10);
        g2.setFont(courier);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.traceBack = false;
        if (this.alignmentMode == this.SETUP_MATRIX) {
            this.setupMatrix(g2, stepX, stepY);
        } else if (this.alignmentMode == this.INITIALIZE_MATRIX) {
            this.setupMatrix(g2, stepX, stepY);
            this.initializeMatrix(g2, stepX, stepY);
        } else if (this.alignmentMode == this.FILL_MATRIX) {
            this.setupMatrix(g2, stepX, stepY);
            this.initializeMatrix(g2, stepX, stepY);
            this.fillMatrix(g2, stepX, stepY);
        } else if (this.alignmentMode == this.TRACE_BACK) {
            this.traceBack = true;
            this.setupMatrix(g2, stepX, stepY);
            this.initializeMatrix(g2, stepX, stepY);
            this.fillMatrix(g2, stepX, stepY);
        }
        g2.setTransform(transform);
    }

    private void setupMatrix(Graphics2D g2, int stepX, int stepY) {
        int rx1 = stepX - 2;
        int ry1 = stepY / 2 - 3;
        int rx2 = (this.sequence1.length() + 2) * stepX - stepX / 3;
        int ry2 = (this.sequence2.length() + 3) * stepY - stepY;
        g2.setColor(Color.black);
        g2.drawRoundRect(rx1, ry1, rx2, ry2, 30, 30);
        g2.drawLine(rx1, ry1 + stepY, rx2 + stepX - 2, ry1 + stepY);
        g2.drawLine(rx1 + stepX, ry1, rx1 + stepX, ry2 + stepY / 2 - 3);
        g2.setColor(Color.blue);
        g2.drawString("-", 2 * stepX, stepY);
        g2.drawString("-", stepX + stepX / 3, 2 * stepY);
        int i = 0;
        while (i < this.sequence1.length()) {
            g2.drawString(this.sequence1.substring(i, i + 1), (i + 3) * stepX - 2, stepY);
            ++i;
        }
        i = 0;
        while (i < this.sequence2.length()) {
            g2.drawString(this.sequence2.substring(i, i + 1), stepX + stepX / 3, (i + 3) * stepY);
            ++i;
        }
    }

    private void initializeMatrix(Graphics2D g2, int stepX, int stepY) {
        g2.setColor(Color.black);
        int i = 0;
        while (i < this.sequence1.length() + 1) {
            g2.drawString(String.valueOf((int)this.dpmMatrix[0][i].score), (i + 2) * stepX, 2 * stepY);
            if (this.dpmMatrix[0][i].backHorizontal) {
                this.arrow.drawArrow(g2, (i + 2) * stepX - 4, 2 * stepY - stepY / 4 + 3, (i + 2) * stepX - 2 * stepX / 4, 2 * stepY - stepY / 4 + 3);
            }
            ++i;
        }
        i = 1;
        while (i < this.sequence2.length() + 1) {
            g2.drawString(String.valueOf((int)this.dpmMatrix[i][0].score), 2 * stepX, (i + 2) * stepY);
            if (this.dpmMatrix[i][0].backVertical) {
                this.arrow.drawArrow(g2, 2 * stepX + stepX / 3 - 5, (i + 2) * stepY - stepY / 2, 2 * stepX + stepX / 3 - 5, (i + 2) * stepY - stepY + 2);
            }
            ++i;
        }
    }

    private void fillMatrix(Graphics2D g2, int stepX, int stepY) {
        int i = 0;
        while (i < this.sequence1.length() + 1) {
            int j = 0;
            while (j < this.sequence2.length() + 1) {
                if (this.traceBack && this.dpmMatrix[j][i].optimal) {
                    g2.setColor(Color.red);
                } else {
                    g2.setColor(Color.black);
                }
                g2.drawString(String.valueOf((int)this.dpmMatrix[j][i].score), (i + 2) * stepX, (j + 2) * stepY);
                if (this.dpmMatrix[j][i].backDiagonal) {
                    this.arrow.drawArrow(g2, (i + 2) * stepX - 4, (j + 2) * stepY - stepY / 2, (i + 2) * stepX - stepX / 2, (j + 2) * stepY - stepY + 2);
                    g2.setColor(Color.black);
                }
                if (this.dpmMatrix[j][i].backHorizontal) {
                    this.arrow.drawArrow(g2, (i + 2) * stepX - 4, (j + 2) * stepY - stepY / 4 + 3, (i + 2) * stepX - 2 * stepX / 4, (j + 2) * stepY - stepY / 4 + 3);
                }
                if (this.dpmMatrix[j][i].backVertical) {
                    this.arrow.drawArrow(g2, (i + 2) * stepX + stepX / 3 - 5, (j + 2) * stepY - stepY / 2, (i + 2) * stepX + stepX / 3 - 5, (j + 2) * stepY - stepY + 2);
                }
                ++j;
            }
            ++i;
        }
    }

    public void setAlignmentMode(int alignmentMode) {
        this.alignmentMode = alignmentMode;
    }

    public double getMatchScore() {
        return this.matchScore;
    }

    public void setMatchScore(double matchScore) {
        this.matchScore = matchScore;
    }

    public double getMismatchScore() {
        return this.mismatchScore;
    }

    public void setMismatchScore(double mismatchScore) {
        this.mismatchScore = mismatchScore;
    }

    public double getGapExtension() {
        return this.gapExtension;
    }

    public void setGapExtension(double gapExtension) {
        this.gapExtension = gapExtension;
    }

    public double getGapOpening() {
        return this.gapOpening;
    }

    public void setGapOpening(double gapOpening) {
        this.gapOpening = gapOpening;
    }
}

