/*
 * Decompiled with CFR 0.152.
 */
package haubold.drift;

import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.Icons;
import haubold.resources.util.PrintableJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class NoMutationPanel
extends PrintableJPanel {
    BirkhaeuserGUIComponents bgc;
    JToolBar toolBar;
    JSlider popSizeSlider;
    JSlider pSlider;
    JButton runButton;
    JButton stopButton;
    JButton resetButton;
    boolean stop;
    Random ran;
    int numPop;
    int initialPopSize;
    int initialP;
    int liveCount;
    ArrayList hList;
    ArrayList fList;
    XYSeriesCollection fDataset;
    XYSeriesCollection hDataset;
    JFreeChart chart;
    ChartPanel chartPanel;

    public NoMutationPanel() {
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.initialPopSize = 10;
        this.initialP = 50;
        this.bgc = new BirkhaeuserGUIComponents();
        this.popSizeSlider = this.bgc.getSlider(0, 100, this.initialPopSize, "Population Size");
        this.pSlider = this.bgc.getSlider(0, 100, this.initialP, "Initial frequency(A) x 100");
        this.runButton = new JButton(Icons.get1rightArrow());
        this.stopButton = new JButton(Icons.getStop());
        this.resetButton = new JButton(Icons.getUndo());
        this.runButton.addActionListener(new RunActionListener());
        this.stopButton.addActionListener(new StopActionListener());
        this.resetButton.addActionListener(new ResetActionListener());
        this.runButton.setToolTipText("Run");
        this.stopButton.setToolTipText("Stop");
        this.resetButton.setToolTipText("Reset");
        this.toolBar.add(this.popSizeSlider);
        this.toolBar.add(this.pSlider);
        this.toolBar.add(this.runButton);
        this.toolBar.add(this.stopButton);
        this.toolBar.add(this.resetButton);
        this.add((Component)this.toolBar, "North");
        this.fDataset = new XYSeriesCollection();
        this.hDataset = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)"", (String)"Generation", (String)"Frequency(A)", (XYDataset)this.fDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRange(false);
        rangeAxis.setRange(0.0, 1.0);
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setRange(1.0, 100.0);
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
        renderer1.setSeriesPaint(0, (Paint)Color.black);
        plot.setRenderer(0, (XYItemRenderer)renderer1);
        NumberAxis axis2 = new NumberAxis("Genetic diversity, H");
        axis2.setFixedDimension(10.0);
        axis2.setAutoRangeIncludesZero(false);
        axis2.setAutoRange(false);
        axis2.setLabelPaint((Paint)Color.red);
        axis2.setTickLabelPaint((Paint)Color.red);
        plot.setRangeAxis(1, (ValueAxis)axis2);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        plot.setDataset(1, (XYDataset)this.hDataset);
        plot.mapDatasetToRangeAxis(1, 1);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        renderer2.setSeriesPaint(0, (Paint)Color.red);
        plot.setRenderer(1, (XYItemRenderer)renderer2);
        this.chartPanel = new ChartPanel(this.chart);
        this.add((Component)this.chartPanel, "Center");
        this.stop = true;
        this.liveCount = 0;
        this.ran = new Random();
    }

    class StopActionListener
    implements ActionListener {
        StopActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            NoMutationPanel.this.stop = true;
            NoMutationPanel.this.stopButton.setEnabled(false);
            NoMutationPanel.this.resetButton.setEnabled(true);
        }
    }

    class ResetActionListener
    implements ActionListener {
        ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            NoMutationPanel.this.hDataset.removeAllSeries();
            NoMutationPanel.this.fDataset.removeAllSeries();
            NoMutationPanel.this.numPop = 0;
            NoMutationPanel.this.resetButton.setEnabled(false);
            NoMutationPanel.this.popSizeSlider.setValue(NoMutationPanel.this.initialPopSize);
            NoMutationPanel.this.pSlider.setValue(NoMutationPanel.this.initialP);
        }
    }

    class RunActionListener
    implements ActionListener {
        XYSeries hSeries;
        XYSeries fSeries;
        String hIdentifier;
        String fIdentifier;
        DataGenerator generator;

        RunActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (NoMutationPanel.this.stop) {
                NoMutationPanel.this.stop = false;
                NoMutationPanel.this.resetButton.setEnabled(false);
                NoMutationPanel.this.stopButton.setEnabled(true);
            }
            if (NoMutationPanel.this.popSizeSlider.getValue() > 1) {
                this.hIdentifier = new String();
                ++NoMutationPanel.this.numPop;
                this.hIdentifier = "Pop_" + NoMutationPanel.this.numPop + ", N=" + NoMutationPanel.this.popSizeSlider.getValue() + ", H";
                this.fIdentifier = new String();
                this.fIdentifier = "Pop_" + NoMutationPanel.this.numPop + ", N=" + NoMutationPanel.this.popSizeSlider.getValue() + ", F";
                this.hSeries = new XYSeries((Comparable)((Object)this.hIdentifier));
                this.fSeries = new XYSeries((Comparable)((Object)this.fIdentifier));
                NoMutationPanel.this.fDataset.addSeries(this.fSeries);
                NoMutationPanel.this.hDataset.addSeries(this.hSeries);
                this.generator = new DataGenerator(10, this.fSeries, this.hSeries);
                this.generator.start();
                ++NoMutationPanel.this.liveCount;
            }
        }
    }

    class DataGenerator
    extends Timer
    implements ActionListener {
        XYSeries fSeries;
        XYSeries hSeries;
        short[] pop1;
        short[] pop2;
        short indexFrom;
        short indexTo;
        int popSize;
        int popSizeMinusOne;
        double generationCounter;
        boolean first = true;

        DataGenerator(int interval, XYSeries fSeries, XYSeries hSeries) {
            super(interval, null);
            this.addActionListener(this);
            this.fSeries = fSeries;
            this.hSeries = hSeries;
            this.popSize = NoMutationPanel.this.popSizeSlider.getValue();
            this.popSizeMinusOne = this.popSize - 1;
            this.pop1 = new short[this.popSize];
            this.pop2 = new short[this.popSize];
            int n = Math.round((float)this.popSize * (float)NoMutationPanel.this.pSlider.getValue() / 100.0f);
            int i = 0;
            while (i < n) {
                this.pop1[i] = 1;
                ++i;
            }
            this.generationCounter = 0.0;
        }

        public void actionPerformed(ActionEvent event) {
            if (!NoMutationPanel.this.stop) {
                double f = 0.0;
                int i = 0;
                while (i < this.popSize) {
                    f += (double)this.pop1[i];
                    ++i;
                }
                f /= (double)this.popSize;
                double h = 0.0;
                i = 0;
                while (i < this.popSizeMinusOne) {
                    int j = i + 1;
                    while (j < this.popSize) {
                        if (this.pop1[i] != this.pop1[j]) {
                            h += 1.0;
                        }
                        ++j;
                    }
                    ++i;
                }
                h /= (double)this.popSize * (double)(this.popSize - 1) / 2.0;
                if (f != 0.0 && f != 1.0) {
                    i = 0;
                    while (i < this.popSize) {
                        int r = NoMutationPanel.this.ran.nextInt(this.popSize);
                        this.pop2[i] = this.pop1[r];
                        ++i;
                    }
                    i = 0;
                    while (i < this.popSize) {
                        this.pop1[i] = this.pop2[i];
                        ++i;
                    }
                    this.fSeries.add(this.generationCounter += 1.0, f);
                    this.hSeries.add(this.generationCounter, h);
                } else if (this.first) {
                    this.fSeries.add(this.generationCounter += 1.0, f);
                    this.hSeries.add(this.generationCounter, h);
                    this.first = false;
                    this.stop();
                    --NoMutationPanel.this.liveCount;
                    if (NoMutationPanel.this.liveCount == 0) {
                        NoMutationPanel.this.stopButton.setEnabled(false);
                        NoMutationPanel.this.resetButton.setEnabled(true);
                        NoMutationPanel.this.stop = true;
                    }
                }
            }
        }
    }
}

