/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.algorithm;

import haubold.hmm.algorithm.HiddenMarkovModel;

public class Backward {
    private double[][] backwardProbabilities;

    public double[][] computeBackward(HiddenMarkovModel hmm, int[] observedStates, double[] scale) {
        int states = hmm.getNumStates();
        int length = observedStates.length;
        this.backwardProbabilities = new double[states][length];
        double[][] observationProbabilities = hmm.getObservationProbabilities();
        double[][] transitionProbabilities = hmm.getTransitionProbabilities();
        double logP = 0.0;
        int i = 0;
        while (i < states) {
            this.backwardProbabilities[i][length - 1] = 1.0 / scale[length - 1];
            ++i;
        }
        i = length - 2;
        while (i >= 0) {
            int k;
            int j = 0;
            while (j < states) {
                double s = 0.0;
                k = 0;
                while (k < states) {
                    s += this.backwardProbabilities[k][i + 1] * transitionProbabilities[j][k] * observationProbabilities[k][observedStates[i + 1]];
                    ++k;
                }
                this.backwardProbabilities[j][i] = s;
                ++j;
            }
            k = 0;
            while (k < states) {
                double[] dArray = this.backwardProbabilities[k];
                int n = i;
                dArray[n] = dArray[n] / scale[i];
                ++k;
            }
            --i;
        }
        return this.backwardProbabilities;
    }

    public double[][] getBackwardProbabilities() {
        return this.backwardProbabilities;
    }
}

