/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.algorithm;

import haubold.hmm.algorithm.HiddenMarkovModel;
import java.util.Random;

public class RandomHmm
extends HiddenMarkovModel {
    private int numStates;
    private int numObservations;
    private Random ran;

    public RandomHmm(int numStates, int numObservations) {
        this.numStates = numStates;
        this.numObservations = numObservations;
        this.ran = new Random();
        this.generateRandomModel();
    }

    private void generateRandomModel() {
        int j;
        double r;
        double[][] tp = new double[this.numStates][this.numStates];
        double[][] op = new double[this.numStates][this.numObservations];
        double[] ip = new double[this.numStates];
        double s = 0.0;
        int i = 0;
        while (i < this.numStates - 1) {
            ip[i] = r = this.ran.nextDouble();
            s += r;
            ++i;
        }
        ip[this.numStates - 1] = 1.0 - s;
        s = 0.0;
        i = 0;
        while (i < this.numStates) {
            s = 0.0;
            j = 0;
            while (j < this.numStates - 1) {
                tp[i][j] = r = this.ran.nextDouble();
                s += r;
                ++j;
            }
            tp[i][this.numStates - 1] = 1.0 - s;
            ++i;
        }
        s = 0.0;
        i = 0;
        while (i < this.numStates) {
            s = 0.0;
            j = 0;
            while (j < this.numObservations - 1) {
                op[i][j] = r = this.ran.nextDouble();
                s += r;
                ++j;
            }
            op[i][this.numObservations - 1] = 1.0 - s;
            ++i;
        }
        this.setInitialProbabilities(ip);
        this.setTransitionProbabilities(tp);
        this.setObservationProbabilities(op);
    }
}

