/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.gui;

import haubold.hmm.algorithm.BaumWelch;
import haubold.hmm.algorithm.HiddenMarkovModel;
import haubold.hmm.algorithm.HmmSequence;
import haubold.hmm.algorithm.RandomHmm;
import haubold.hmm.algorithm.SequenceUnit;
import haubold.hmm.gui.BaumWelchThread;
import haubold.hmm.gui.HmmPane;
import haubold.hmm.gui.ModelPanel;
import haubold.hmm.gui.TimerThread;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.Icons;
import haubold.resources.util.PrintableJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class BaumWelchPanel
extends PrintableJPanel {
    private JSplitPane sliderPane;
    private JTextPane textPane;
    private JScrollPane scrollPane;
    private JSplitPane splitPane;
    private JPanel modelPanel;
    private HiddenMarkovModel trueModel;
    private HiddenMarkovModel initialModel;
    private HiddenMarkovModel newModel;
    private ModelPanel trueModelPanel;
    private ModelPanel initialModelPanel;
    private ModelPanel newModelPanel;
    private Random ran;
    private Border border;
    private HmmPane hmmPane;
    private BirkhaeuserGUIComponents bgc;
    private JToolBar toolBar;
    private JButton generateDataButton;
    private JButton estimateModelButton;
    private JButton initialModelButton;
    private JSlider numObsSlider;
    private int[] obsSeq;
    private BaumWelchThread baumWelchTread;
    private TimerThread timerThread;
    private boolean stopped = true;

    BaumWelchPanel(HiddenMarkovModel trueModel) {
        this.trueModel = trueModel;
        this.ran = new Random();
        this.bgc = new BirkhaeuserGUIComponents();
        this.initialModel = new RandomHmm(trueModel.getNumStates(), trueModel.getNumObservationSymbols());
        this.newModel = this.initialModel.copy();
        this.trueModelPanel = new ModelPanel(trueModel);
        this.initialModelPanel = new ModelPanel(this.initialModel);
        this.newModelPanel = new ModelPanel(this.newModel);
        this.trueModelPanel.setBackground(this.bgc.getColor1());
        this.initialModelPanel.setBackground(this.bgc.getColor3().brighter());
        this.newModelPanel.setBackground(Color.WHITE);
        this.trueModelPanel.setToolTipText("True Model");
        this.initialModelPanel.setToolTipText("Initial Model");
        this.newModelPanel.setToolTipText("New Model");
        this.modelPanel = new JPanel(new GridLayout(1, 3));
        this.modelPanel.add(this.trueModelPanel);
        this.modelPanel.add(this.initialModelPanel);
        this.modelPanel.add(this.newModelPanel);
        this.modelPanel.setMinimumSize(new Dimension(100, 100));
        this.modelPanel.repaint();
        this.hmmPane = new HmmPane();
        this.scrollPane = new JScrollPane(this.hmmPane);
        this.splitPane = new JSplitPane(0, this.modelPanel, this.scrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(-1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.toolBar = new JToolBar();
        this.generateDataButton = new JButton(Icons.get1rightArrow());
        this.generateDataButton.setToolTipText("Generate Data");
        this.initialModelButton = new JButton(Icons.getDie());
        this.initialModelButton.setToolTipText("Generate Random Initial Model");
        this.estimateModelButton = new JButton(Icons.getQuestionMark());
        this.estimateModelButton.setToolTipText("Estimate Hiden Markov Model");
        this.estimateModelButton.setEnabled(false);
        GenerateActionListener gal = new GenerateActionListener();
        EstimateActionListener eal = new EstimateActionListener();
        InitializeActionListener ial = new InitializeActionListener();
        this.generateDataButton.addActionListener(gal);
        this.estimateModelButton.addActionListener(eal);
        this.initialModelButton.addActionListener(ial);
        this.numObsSlider = this.bgc.getSlider(0, 5000, 2000, "Length Of Observation Sequence");
        this.toolBar.add(this.generateDataButton);
        this.toolBar.add(this.initialModelButton);
        this.toolBar.add(this.estimateModelButton);
        this.toolBar.add(this.numObsSlider);
        this.add((Component)this.toolBar, "North");
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public JPanel getModelPanel() {
        return this.modelPanel;
    }

    class GenerateActionListener
    implements ActionListener {
        HmmSequence hmmSequence = new HmmSequence();

        GenerateActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int it = BaumWelchPanel.this.numObsSlider.getValue();
            this.hmmSequence.setHmm(BaumWelchPanel.this.trueModelPanel.getHmm());
            SequenceUnit[] sequenceData = this.hmmSequence.generateHmmSequence(it);
            BaumWelchPanel.this.obsSeq = new int[sequenceData.length];
            int i = 0;
            while (i < sequenceData.length) {
                ((BaumWelchPanel)BaumWelchPanel.this).obsSeq[i] = sequenceData[i].getObservedState();
                ++i;
            }
            BaumWelchPanel.this.hmmPane.setSequenceData(sequenceData);
            BaumWelchPanel.this.estimateModelButton.setEnabled(true);
        }
    }

    class EstimateActionListener
    implements ActionListener {
        BaumWelch bw = new BaumWelch();
        HiddenMarkovModel im;

        EstimateActionListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            HiddenMarkovModel im = BaumWelchPanel.this.initialModelPanel.getHmm();
            this.bw.setMaxIt(10000);
            this.bw.setObsSeq(BaumWelchPanel.this.obsSeq);
            this.bw.setHmm(im.copy());
            BaumWelchPanel.this.baumWelchTread = new BaumWelchThread(this.bw, BaumWelchPanel.this.newModelPanel, BaumWelchPanel.this.estimateModelButton);
            BaumWelchPanel.this.timerThread = new TimerThread(BaumWelchPanel.this.newModelPanel, BaumWelchPanel.this.baumWelchTread);
            BaumWelchPanel.this.baumWelchTread.start();
            BaumWelchPanel.this.timerThread.start();
            BaumWelchPanel.this.stopped = false;
        }
    }

    class InitializeActionListener
    implements ActionListener {
        HiddenMarkovModel im;

        InitializeActionListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            this.im = new RandomHmm(BaumWelchPanel.this.trueModel.getNumStates(), BaumWelchPanel.this.trueModel.getNumObservationSymbols());
            BaumWelchPanel.this.initialModelPanel.setHmm(this.im);
            BaumWelchPanel.this.newModelPanel.setHmm(this.im.copy());
        }
    }
}

