/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.gui;

import haubold.hmm.algorithm.HiddenMarkovModel;
import haubold.resources.util.Arrow;
import haubold.resources.util.BirkhaeuserGUIComponents;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.text.DecimalFormat;
import javax.swing.JPanel;

public class ModelPanel
extends JPanel {
    private HiddenMarkovModel hmm;
    private float boxWidth = 50.0f;
    private float boxHeight;
    private DecimalFormat format;
    private QuadCurve2D.Float quad;
    private Arrow arrow;
    private BirkhaeuserGUIComponents bgc;
    private Color colorE1;
    private Color colorE2;
    private Color colorH1;
    private Color colorH2;
    private Rectangle histogram1;
    private Rectangle histogram2;
    private Ellipse2D startingPoint;
    private double scale;
    private double translateX;
    private double translateY;
    private boolean pending;
    private RenderingHints qualityHints;
    private int progress;

    public ModelPanel(HiddenMarkovModel hmm) {
        this.hmm = hmm;
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        this.qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.format = new DecimalFormat("0.##");
        this.arrow = new Arrow();
        this.bgc = new BirkhaeuserGUIComponents();
        this.colorE1 = this.bgc.getColor3();
        this.colorE2 = this.bgc.getColor5();
        this.colorH1 = this.bgc.getColor2();
        this.colorH2 = this.bgc.getColor4();
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.qualityHints);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(Color.black);
        if (!this.pending) {
            this.drawModel(g2);
        } else {
            this.drawPending(g2);
        }
    }

    private void drawPending(Graphics2D g2) {
        int h = this.getHeight();
        int w = this.getWidth();
        boolean c = false;
        double scaleY = (double)h / 200.0;
        double scaleX = (double)w / 200.0;
        this.scale = Math.min(scaleX, scaleY);
        double ty = ((double)h - 10.0 * this.scale) / 2.0;
        double tx = ((double)w - 170.0 * this.scale) / 2.0;
        int border = 10;
        g2.translate(tx, ty);
        g2.scale(this.scale, this.scale);
        g2.setColor(Color.BLACK);
        g2.drawString("Estimating Model", border, 0);
        g2.setColor(Color.BLACK);
        g2.drawRect(border - 4, 7, 118, 7);
        BasicStroke bs = new BasicStroke(7.0f);
        g2.setStroke(bs);
        g2.setColor(Color.red);
        g2.drawLine(border + this.progress, 10, border + this.progress + 10, 10);
    }

    private void drawModel(Graphics2D g2) {
        float y2;
        float y1 = this.boxWidth;
        float histX = y2 = 4.0f * this.boxWidth;
        int startX = (int)(1.1 * (double)this.boxWidth);
        int width = this.getWidth();
        int height = this.getHeight();
        AffineTransform transform = g2.getTransform();
        double xScale = (double)width / 300.0;
        double yScale = (double)height / 300.0;
        this.scale = Math.min(xScale, yScale);
        this.translateX = ((double)width - ((double)histX + 4.0 * (double)this.boxWidth - (double)startX) * this.scale) / 2.0;
        this.translateY = ((double)height - (double)(y2 + this.boxHeight - y1) * this.scale) / 2.0;
        g2.translate(this.translateX, this.translateY);
        g2.scale(this.scale, this.scale);
        g2.setColor(this.colorH1);
        this.histogram1 = new Rectangle((int)histX, (int)y1, (int)this.boxWidth, (int)this.boxHeight);
        if (this.hmm == null) {
            System.out.println("Model Panel: HMM is null");
        }
        this.drawHistogram(g2, this.histogram1, (float)this.hmm.getObservationProbabilities()[0][0]);
        g2.setColor(this.colorH2);
        this.histogram2 = new Rectangle((int)histX, (int)y2, (int)this.boxWidth, (int)this.boxHeight);
        this.drawHistogram(g2, this.histogram2, (float)this.hmm.getObservationProbabilities()[1][0]);
        g2.setColor(Color.black);
        this.drawSelfReferenceConcave(g2, histX + this.boxWidth / 2.0f, y1 - this.boxHeight);
        g2.drawString(this.format.format(this.hmm.getTransitionProbabilities()[0][0]), (int)((double)histX + 1.25 * (double)this.boxWidth), (int)((double)y1 - 1.25 * (double)this.boxHeight + 12.0));
        this.drawSelfReferenceConvex(g2, histX + this.boxWidth / 2.0f, y2);
        g2.drawString(this.format.format(this.hmm.getTransitionProbabilities()[1][1]), (int)((double)histX + 1.25 * (double)this.boxWidth), (int)(y2 + this.boxHeight / 4.0f));
        this.arrow = new Arrow();
        this.arrow.drawArrow(g2, histX + 0.1f * this.boxWidth, y2 - this.boxHeight, histX + 0.1f * this.boxWidth, y1);
        float middle = y1 + (y2 - y1 - this.boxHeight) / 2.0f;
        g2.drawString(this.format.format(this.hmm.getTransitionProbabilities()[1][0]), (int)histX - 25, (int)middle);
        this.arrow.drawArrow(g2, histX + 0.9f * this.boxWidth, y1, histX + 0.9f * this.boxWidth, y2 - this.boxHeight);
        g2.drawString(this.format.format(this.hmm.getTransitionProbabilities()[0][1]), (int)(histX + this.boxWidth + 5.0f), (int)middle);
        this.startingPoint = new Ellipse2D.Float(startX - 5, middle - 5.0f, 10.0f, 10.0f);
        g2.fill(this.startingPoint);
        this.arrow.drawArrow(g2, startX, middle, histX, y1 - this.boxHeight / 2.0f);
        this.arrow.drawArrow(g2, startX, middle, histX, y2 - this.boxHeight / 2.0f);
        g2.drawString(this.format.format(this.hmm.getInitialProbabilities()[0]), (float)startX + (histX - (float)startX) / 2.0f, y1 + (middle - y1) / 2.0f);
        g2.drawString(this.format.format(this.hmm.getInitialProbabilities()[1]), (float)startX + (histX - (float)startX) / 2.0f, y2 - (middle - y1) / 2.0f - 5.0f);
        g2.setTransform(transform);
    }

    private void drawSelfReferenceConcave(Graphics2D g2, float x, float y) {
        GeneralPath s = new GeneralPath();
        s.moveTo(x, y);
        s.curveTo(x + this.boxWidth / 2.0f, y - this.boxHeight / 2.0f, x + this.boxWidth, y + this.boxHeight / 4.0f, x + this.boxWidth / 2.0f, y + this.boxHeight / 2.0f);
        g2.draw(s);
        this.arrow.drawArrowHead(g2, x + this.boxWidth / 2.0f, y + this.boxHeight / 2.0f, x + 1.15f * this.boxWidth, y);
    }

    private void drawSelfReferenceConvex(Graphics2D g2, float x, float y) {
        GeneralPath s = new GeneralPath();
        s.moveTo(x, y);
        s.curveTo(x + this.boxWidth / 2.0f, y + this.boxHeight / 2.0f, x + this.boxWidth, y - this.boxHeight / 4.0f, x + this.boxWidth / 2.0f, y - this.boxHeight / 2.0f);
        g2.draw(s);
        this.arrow.drawArrowHead(g2, x + this.boxWidth / 2.0f, y - this.boxHeight / 2.0f, x + 1.15f * this.boxWidth, y);
    }

    private void drawHistogram(Graphics2D g, Rectangle rec, float p) {
        float boxX = (float)rec.getX();
        float boxY = (float)rec.getY();
        float letterHeight = 12.0f;
        this.boxHeight = this.boxWidth;
        g.fillRect((int)boxX, (int)(boxY - this.boxHeight), (int)this.boxWidth, (int)this.boxHeight);
        g.setColor(Color.black);
        g.drawLine((int)boxX, (int)(boxY - letterHeight), (int)(boxX + this.boxWidth), (int)(boxY - letterHeight));
        g.setColor(this.colorE1);
        g.drawString("A/T", boxX + 0.5f * this.boxWidth / 5.0f, boxY);
        g.setColor(this.colorE2);
        g.drawString("G/C", boxX + 2.5f * this.boxWidth / 5.0f, boxY);
        float histogramWidth = this.boxWidth / 5.0f;
        float maxHistHeight = this.boxHeight - 2.0f * letterHeight;
        float hYHeight = p * maxHistHeight;
        float hRHeight = (1.0f - p) * maxHistHeight;
        g.setColor(Color.black);
        g.drawRect((int)(boxX + 1.0f * this.boxWidth / 5.0f), (int)(boxY - letterHeight - hYHeight), (int)histogramWidth, (int)hYHeight);
        g.drawRect((int)(boxX + 3.0f * this.boxWidth / 5.0f), (int)(boxY - letterHeight - hRHeight), (int)histogramWidth, (int)hRHeight);
        g.setColor(this.colorE1);
        g.fillRect((int)(boxX + 1.0f * this.boxWidth / 5.0f), (int)(boxY - letterHeight - hYHeight), (int)histogramWidth, (int)hYHeight);
        g.setColor(this.colorE2);
        g.fillRect((int)(boxX + 3.0f * this.boxWidth / 5.0f), (int)(boxY - letterHeight - hRHeight), (int)histogramWidth, (int)hRHeight);
    }

    public Color getColorE1() {
        return this.colorE1;
    }

    public Color getColorE2() {
        return this.colorE2;
    }

    public Color getColorH1() {
        return this.colorH1;
    }

    public Color getColorH2() {
        return this.colorH2;
    }

    public void setColorE1(Color color) {
        this.colorE1 = color;
        this.repaint();
    }

    public void setColorE2(Color color) {
        this.colorE2 = color;
        this.repaint();
    }

    public void setColorH1(Color color) {
        this.colorH1 = color;
        this.repaint();
    }

    public void setColorH2(Color color) {
        this.colorH2 = color;
        this.repaint();
    }

    public void setHmm(HiddenMarkovModel model) {
        this.hmm = model;
        this.repaint();
    }

    public HiddenMarkovModel getHmm() {
        return this.hmm;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean b) {
        this.pending = b;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.repaint();
    }

    public double getScale() {
        return this.scale;
    }
}

