/*
 * Decompiled with CFR 0.152.
 */
package haubold.numAlignments;

import haubold.numAlignments.ResultPanel;
import haubold.resources.demo.DemoFrame;
import haubold.resources.util.BirkhaeuserGUIComponents;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumAlDemo
extends DemoFrame {
    JSlider mSlider;
    JSlider nSlider;
    JButton resetButton;
    JLabel titleLabel;
    JLabel mLabel;
    JLabel nLabel;
    JLabel resultLabel;
    JPanel mPanel;
    JPanel nPanel;
    ResultPanel resultPanel;
    DecimalFormat form;
    JToolBar toolBar = new JToolBar();
    BirkhaeuserGUIComponents bgc;
    static double[][] dpm = null;
    JRadioButton localButton;
    JRadioButton globalButton;
    int maxM = 400;
    int maxN = 400;
    static double[][] pascalsTriangle;

    public NumAlDemo(String titleString, String helpPath) {
        this.setTitle(titleString);
        this.setHelpPath(helpPath);
        this.bgc = new BirkhaeuserGUIComponents();
        this.mSlider = this.getSlider(0, this.maxM, 20);
        this.nSlider = this.getSlider(0, this.maxN, 20);
        this.mSlider.setBorder(new TitledBorder("Length of Sequence 1"));
        this.nSlider.setBorder(new TitledBorder("Length of Sequence 2"));
        this.initializeDp(this.maxM, this.maxN);
        this.mSlider.setPreferredSize(new Dimension(170, 65));
        this.nSlider.setPreferredSize(new Dimension(170, 65));
        this.mLabel = new JLabel();
        this.nLabel = new JLabel();
        Dimension size = new Dimension(70, 20);
        this.mLabel.setPreferredSize(size);
        this.mLabel.setMaximumSize(size);
        this.mLabel.setMinimumSize(size);
        this.nLabel.setPreferredSize(size);
        this.nLabel.setMaximumSize(size);
        this.nLabel.setMinimumSize(size);
        this.mLabel.setHorizontalAlignment(0);
        this.nLabel.setHorizontalAlignment(0);
        this.mLabel.setText(String.valueOf(this.mSlider.getValue()));
        this.nLabel.setText(String.valueOf(this.nSlider.getValue()));
        this.mLabel.setOpaque(true);
        this.nLabel.setOpaque(true);
        this.mLabel.setForeground(Color.red.brighter());
        this.nLabel.setForeground(Color.blue.brighter());
        this.resultPanel = new ResultPanel();
        this.resultPanel.setResult(NumAlDemo.numAl(this.mSlider.getValue(), this.nSlider.getValue(), false));
        this.globalButton = new JRadioButton("Global");
        this.globalButton.setSelected(true);
        this.localButton = new JRadioButton("Local");
        ButtonGroup bg = new ButtonGroup();
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1));
        bg.add(this.globalButton);
        bg.add(this.localButton);
        buttonPanel.add(this.globalButton);
        buttonPanel.add(this.localButton);
        SliderListener myListener = new SliderListener();
        this.nSlider.addChangeListener(myListener);
        this.mSlider.addChangeListener(myListener);
        this.globalButton.addChangeListener(myListener);
        this.localButton.addChangeListener(myListener);
        this.toolBar = new JToolBar();
        this.toolBar.add(this.mSlider);
        this.toolBar.add(this.mLabel);
        this.toolBar.add(this.nSlider);
        this.toolBar.add(this.nLabel);
        this.toolBar.add(buttonPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.resultPanel, "Center");
    }

    static double numAl(int m, int n, boolean local) {
        if (m == 0 || n == 0) {
            return 1.0;
        }
        if (!local) {
            return dpm[m][n];
        }
        double s = 0.0;
        int i = 1;
        while (i <= n) {
            int j = 1;
            while (j <= m) {
                s += dpm[j][i] * (double)(n - i + 1) * (double)(m - j + 1);
                ++j;
            }
            ++i;
        }
        return s;
    }

    private void constructPascalsTriangle(int max) {
        pascalsTriangle = new double[max + 1][max + 1];
        int i = 0;
        while (i <= max) {
            NumAlDemo.pascalsTriangle[0][i] = 1.0;
            NumAlDemo.pascalsTriangle[i][i] = 1.0;
            ++i;
        }
        i = 1;
        while (i <= max) {
            int j = 2;
            while (j <= max) {
                NumAlDemo.pascalsTriangle[i][j] = pascalsTriangle[i][j - 1] + pascalsTriangle[i - 1][j - 1];
                ++j;
            }
            ++i;
        }
    }

    private void initializeDp(int m, int n) {
        dpm = new double[m + 1][n + 1];
        int i = 0;
        while (i <= n) {
            NumAlDemo.dpm[0][i] = 1.0;
            ++i;
        }
        i = 1;
        while (i <= m) {
            NumAlDemo.dpm[i][0] = 1.0;
            ++i;
        }
        i = 1;
        while (i <= m) {
            int j = 1;
            while (j <= n) {
                NumAlDemo.dpm[i][j] = dpm[i - 1][j] + dpm[i - 1][j - 1] + dpm[i][j - 1];
                ++j;
            }
            ++i;
        }
    }

    private JSlider getSlider(int min, int max, int init) {
        JSlider slider = new JSlider(min, max, init);
        slider.setMajorTickSpacing(100);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setSnapToTicks(false);
        return slider;
    }

    class SliderListener
    implements ChangeListener {
        boolean local;

        SliderListener() {
        }

        public void stateChanged(ChangeEvent e) {
            NumAlDemo.this.mLabel.setText(String.valueOf(NumAlDemo.this.mSlider.getValue()));
            NumAlDemo.this.nLabel.setText(String.valueOf(NumAlDemo.this.nSlider.getValue()));
            this.local = NumAlDemo.this.localButton.isSelected();
            NumAlDemo.this.resultPanel.setResult(NumAlDemo.numAl(NumAlDemo.this.mSlider.getValue(), NumAlDemo.this.nSlider.getValue(), this.local));
        }
    }
}

