/*
 * Decompiled with CFR 0.152.
 */
package haubold.numAlignments;

import haubold.resources.util.BirkhaeuserGUIComponents;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.JPanel;

public class ResultPanel
extends JPanel {
    DecimalFormat form = new DecimalFormat("#0.##E0");
    double result;
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    Font font12 = new Font("Helvetica", 1, 12);

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.bgc.getColor1());
        g2.setFont(this.font12);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        String resultString1 = "Number of Possible Alignments ";
        String resultString2 = this.form.format(this.result);
        AffineTransform transform = g2.getTransform();
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl1 = new TextLayout(resultString1, this.font12, frc);
        TextLayout tl2 = new TextLayout(resultString2, this.font12, frc);
        Rectangle2D stringRect1 = tl1.getBounds();
        Rectangle2D stringRect2 = tl2.getBounds();
        double stringLength1 = stringRect1.getWidth();
        double stringLength2 = stringRect2.getWidth();
        double stringHeight = stringRect1.getHeight();
        double scaleX = (double)this.getWidth() / stringLength1 * 0.9;
        double scaleY = (double)this.getHeight() / stringHeight * 0.9;
        double scale = Math.min(scaleX, scaleY);
        int tx = (int)(((double)this.getWidth() - stringLength1 * scale) / 2.0);
        int ty = (int)(((double)this.getHeight() - stringHeight * scale) / 2.0);
        g2.translate(tx, ty);
        g2.scale(scale, scale);
        g2.setColor(Color.black);
        tl1.draw(g2, 0.0f, 0.0f);
        g2.setTransform(transform);
        tx = (int)(((double)this.getWidth() - stringLength2 * scale) / 2.0);
        ty = (int)(((double)this.getHeight() - stringHeight * scale) / 2.0);
        g2.translate(tx, ty);
        g2.scale(scale, scale);
        g2.setColor(this.bgc.getColor3());
        tl2.draw(g2, 0.0f, 20.0f);
    }

    public double getResult() {
        return this.result;
    }

    public void setResult(double result) {
        this.result = result;
        this.repaint();
    }
}

