/*
 * Decompiled with CFR 0.152.
 */
package haubold.phylogeny.distance;

public class DistanceComputation {
    char[][] alignment;
    double[][] jukesCantor;
    double[][] mismatches;
    double[][] normalizedMismatches;

    public DistanceComputation(char[][] alignment) {
        this.alignment = this.filterAlignment(alignment);
    }

    private double[][] computeJCDistances(char[][] alignment) {
        if (alignment == null) {
            return null;
        }
        int n = alignment.length;
        double[][] dm = this.computeNormalizedMismatches(alignment);
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                dm[i][j] = 0.75 * Math.log(3.0 / (4.0 * (1.0 - dm[i][j]) - 1.0));
                dm[j][i] = dm[i][j];
                ++j;
            }
            ++i;
        }
        return dm;
    }

    private double[][] computeNormalizedMismatches(char[][] alignment) {
        if (alignment == null) {
            return null;
        }
        int n = alignment.length;
        double l = alignment[0].length;
        double[][] dm = this.computeMismatches(alignment);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                dm[i][j] = dm[i][j] / l;
                ++j;
            }
            ++i;
        }
        return dm;
    }

    private double[][] computeMismatches(char[][] alignment) {
        if (alignment == null) {
            return null;
        }
        int n = alignment.length;
        int l = alignment[0].length;
        double[][] dm = new double[n][n];
        int i = 0;
        while (i < n) {
            dm[i][i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                dm[i][j] = 0.0;
                int k = 0;
                while (k < l) {
                    if (alignment[i][k] != alignment[j][k]) {
                        double[] dArray = dm[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + 1.0;
                    }
                    ++k;
                }
                dm[j][i] = dm[i][j];
                ++j;
            }
            ++i;
        }
        return dm;
    }

    private char[][] filterAlignment(char[][] alignment) {
        char[][] alignment2 = new char[alignment.length][alignment[0].length];
        boolean indel = false;
        int i = 1;
        while (i < alignment.length) {
            if (alignment[0].length != alignment[i].length) {
                return null;
            }
            ++i;
        }
        int c = 0;
        int j = 0;
        while (j < alignment[0].length) {
            indel = false;
            i = 0;
            while (i < alignment.length) {
                if (alignment[i][j] == '-') {
                    indel = true;
                    break;
                }
                ++i;
            }
            if (!indel) {
                i = 0;
                while (i < alignment.length) {
                    alignment2[i][c] = alignment[i][j];
                    ++i;
                }
                ++c;
            }
            ++j;
        }
        char[][] alignment3 = new char[alignment.length][c];
        j = 0;
        while (j < c) {
            i = 0;
            while (i < alignment.length) {
                alignment3[i][j] = alignment2[i][j];
                ++i;
            }
            ++j;
        }
        return alignment3;
    }

    public char[][] getAlignment() {
        return this.alignment;
    }

    public double[][] getJukesCantor() {
        return this.computeJCDistances(this.alignment);
    }

    public double[][] getMismatches() {
        return this.computeMismatches(this.alignment);
    }

    public double[][] getNormalizedMismatches() {
        return this.computeNormalizedMismatches(this.alignment);
    }

    public void setAlignment(char[][] alignment) {
        this.alignment = this.filterAlignment(alignment);
    }
}

